// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOchSignalIdVer13 implements OFOchSignalId {
    private static final Logger logger = LoggerFactory.getLogger(OFOchSignalIdVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 6;

        private final static short DEFAULT_GRID = (short) 0x0;
        private final static short DEFAULT_CS = (short) 0x0;
        private final static int DEFAULT_N = 0x0;
        private final static int DEFAULT_M = 0x0;

    // OF message fields
    private final short grid;
    private final short cs;
    private final int n;
    private final int m;
//
    // Immutable default instance
    final static OFOchSignalIdVer13 DEFAULT = new OFOchSignalIdVer13(
        DEFAULT_GRID, DEFAULT_CS, DEFAULT_N, DEFAULT_M
    );

    // package private constructor - used by readers, builders, and factory
    OFOchSignalIdVer13(short grid, short cs, int n, int m) {
        this.grid = grid;
        this.cs = cs;
        this.n = n;
        this.m = m;
    }

    // Accessors for OF message fields
    @Override
    public short getGrid() {
        return grid;
    }

    @Override
    public short getCs() {
        return cs;
    }

    @Override
    public int getN() {
        return n;
    }

    @Override
    public int getM() {
        return m;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOchSignalId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOchSignalId.Builder {
        final OFOchSignalIdVer13 parentMessage;

        // OF message fields
        private boolean gridSet;
        private short grid;
        private boolean csSet;
        private short cs;
        private boolean nSet;
        private int n;
        private boolean mSet;
        private int m;

        BuilderWithParent(OFOchSignalIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public short getGrid() {
        return grid;
    }

    @Override
    public OFOchSignalId.Builder setGrid(short grid) {
        this.grid = grid;
        this.gridSet = true;
        return this;
    }
    @Override
    public short getCs() {
        return cs;
    }

    @Override
    public OFOchSignalId.Builder setCs(short cs) {
        this.cs = cs;
        this.csSet = true;
        return this;
    }
    @Override
    public int getN() {
        return n;
    }

    @Override
    public OFOchSignalId.Builder setN(int n) {
        this.n = n;
        this.nSet = true;
        return this;
    }
    @Override
    public int getM() {
        return m;
    }

    @Override
    public OFOchSignalId.Builder setM(int m) {
        this.m = m;
        this.mSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOchSignalId build() {
                short grid = this.gridSet ? this.grid : parentMessage.grid;
                short cs = this.csSet ? this.cs : parentMessage.cs;
                int n = this.nSet ? this.n : parentMessage.n;
                int m = this.mSet ? this.m : parentMessage.m;

                //
                return new OFOchSignalIdVer13(
                    grid,
                    cs,
                    n,
                    m
                );
        }

    }

    static class Builder implements OFOchSignalId.Builder {
        // OF message fields
        private boolean gridSet;
        private short grid;
        private boolean csSet;
        private short cs;
        private boolean nSet;
        private int n;
        private boolean mSet;
        private int m;

    @Override
    public short getGrid() {
        return grid;
    }

    @Override
    public OFOchSignalId.Builder setGrid(short grid) {
        this.grid = grid;
        this.gridSet = true;
        return this;
    }
    @Override
    public short getCs() {
        return cs;
    }

    @Override
    public OFOchSignalId.Builder setCs(short cs) {
        this.cs = cs;
        this.csSet = true;
        return this;
    }
    @Override
    public int getN() {
        return n;
    }

    @Override
    public OFOchSignalId.Builder setN(int n) {
        this.n = n;
        this.nSet = true;
        return this;
    }
    @Override
    public int getM() {
        return m;
    }

    @Override
    public OFOchSignalId.Builder setM(int m) {
        this.m = m;
        this.mSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOchSignalId build() {
            short grid = this.gridSet ? this.grid : DEFAULT_GRID;
            short cs = this.csSet ? this.cs : DEFAULT_CS;
            int n = this.nSet ? this.n : DEFAULT_N;
            int m = this.mSet ? this.m : DEFAULT_M;


            return new OFOchSignalIdVer13(
                    grid,
                    cs,
                    n,
                    m
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOchSignalId> {
        @Override
        public OFOchSignalId readFrom(ByteBuf bb) throws OFParseError {
            short grid = U8.f(bb.readByte());
            short cs = U8.f(bb.readByte());
            int n = U16.f(bb.readShort());
            int m = U16.f(bb.readShort());

            OFOchSignalIdVer13 ochSignalIdVer13 = new OFOchSignalIdVer13(
                    grid,
                      cs,
                      n,
                      m
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", ochSignalIdVer13);
            return ochSignalIdVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOchSignalIdVer13Funnel FUNNEL = new OFOchSignalIdVer13Funnel();
    static class OFOchSignalIdVer13Funnel implements Funnel<OFOchSignalIdVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOchSignalIdVer13 message, PrimitiveSink sink) {
            sink.putShort(message.grid);
            sink.putShort(message.cs);
            sink.putInt(message.n);
            sink.putInt(message.m);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOchSignalIdVer13> {
        @Override
        public void write(ByteBuf bb, OFOchSignalIdVer13 message) {
            bb.writeByte(U8.t(message.grid));
            bb.writeByte(U8.t(message.cs));
            bb.writeShort(U16.t(message.n));
            bb.writeShort(U16.t(message.m));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOchSignalIdVer13(");
        b.append("grid=").append(grid);
        b.append(", ");
        b.append("cs=").append(cs);
        b.append(", ");
        b.append("n=").append(n);
        b.append(", ");
        b.append("m=").append(m);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOchSignalIdVer13 other = (OFOchSignalIdVer13) obj;

        if( grid != other.grid)
            return false;
        if( cs != other.cs)
            return false;
        if( n != other.n)
            return false;
        if( m != other.m)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + grid;
        result = prime * result + cs;
        result = prime * result + n;
        result = prime * result + m;
        return result;
    }

}
