// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;
import java.util.Arrays;

class OFOduSigIdTVer13 implements OFOduSigIdT {
    private static final Logger logger = LoggerFactory.getLogger(OFOduSigIdTVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 4;

        private final static int DEFAULT_TPN = 0x0;
        private final static byte[] DEFAULT_TSMAP = new byte[0];

    // OF message fields
    private final int tpn;
    private final byte[] tsmap;
//
    // Immutable default instance
    final static OFOduSigIdTVer13 DEFAULT = new OFOduSigIdTVer13(
        DEFAULT_TPN, DEFAULT_TSMAP
    );

    // package private constructor - used by readers, builders, and factory
    OFOduSigIdTVer13(int tpn, byte[] tsmap) {
        if(tsmap == null) {
            throw new NullPointerException("OFOduSigIdTVer13: property tsmap cannot be null");
        }
        this.tpn = tpn;
        this.tsmap = tsmap;
    }

    // Accessors for OF message fields
    @Override
    public int getTpn() {
        return tpn;
    }

    @Override
    public byte[] getTsmap() {
        return tsmap;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOduSigIdT.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOduSigIdT.Builder {
        final OFOduSigIdTVer13 parentMessage;

        // OF message fields
        private boolean tpnSet;
        private int tpn;
        private boolean tsmapSet;
        private byte[] tsmap;

        BuilderWithParent(OFOduSigIdTVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getTpn() {
        return tpn;
    }

    @Override
    public OFOduSigIdT.Builder setTpn(int tpn) {
        this.tpn = tpn;
        this.tpnSet = true;
        return this;
    }
    @Override
    public byte[] getTsmap() {
        return tsmap;
    }

    @Override
    public OFOduSigIdT.Builder setTsmap(byte[] tsmap) {
        this.tsmap = tsmap;
        this.tsmapSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOduSigIdT build() {
                int tpn = this.tpnSet ? this.tpn : parentMessage.tpn;
                byte[] tsmap = this.tsmapSet ? this.tsmap : parentMessage.tsmap;
                if(tsmap == null)
                    throw new NullPointerException("Property tsmap must not be null");

                //
                return new OFOduSigIdTVer13(
                    tpn,
                    tsmap
                );
        }

    }

    static class Builder implements OFOduSigIdT.Builder {
        // OF message fields
        private boolean tpnSet;
        private int tpn;
        private boolean tsmapSet;
        private byte[] tsmap;

    @Override
    public int getTpn() {
        return tpn;
    }

    @Override
    public OFOduSigIdT.Builder setTpn(int tpn) {
        this.tpn = tpn;
        this.tpnSet = true;
        return this;
    }
    @Override
    public byte[] getTsmap() {
        return tsmap;
    }

    @Override
    public OFOduSigIdT.Builder setTsmap(byte[] tsmap) {
        this.tsmap = tsmap;
        this.tsmapSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOduSigIdT build() {
            int tpn = this.tpnSet ? this.tpn : DEFAULT_TPN;
            byte[] tsmap = this.tsmapSet ? this.tsmap : DEFAULT_TSMAP;
            if(tsmap == null)
                throw new NullPointerException("Property tsmap must not be null");


            return new OFOduSigIdTVer13(
                    tpn,
                    tsmap
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOduSigIdT> {
        @Override
        public OFOduSigIdT readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int tpn = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            byte[] tsmap = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));

            OFOduSigIdTVer13 oduSigIdTVer13 = new OFOduSigIdTVer13(
                    tpn,
                      tsmap
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oduSigIdTVer13);
            return oduSigIdTVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOduSigIdTVer13Funnel FUNNEL = new OFOduSigIdTVer13Funnel();
    static class OFOduSigIdTVer13Funnel implements Funnel<OFOduSigIdTVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOduSigIdTVer13 message, PrimitiveSink sink) {
            sink.putInt(message.tpn);
            // FIXME: skip funnel of length
            sink.putBytes(message.tsmap);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOduSigIdTVer13> {
        @Override
        public void write(ByteBuf bb, OFOduSigIdTVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(U16.t(message.tpn));
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeBytes(message.tsmap);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOduSigIdTVer13(");
        b.append("tpn=").append(tpn);
        b.append(", ");
        b.append("tsmap=").append(Arrays.toString(tsmap));
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOduSigIdTVer13 other = (OFOduSigIdTVer13) obj;

        if( tpn != other.tpn)
            return false;
        if (!Arrays.equals(tsmap, other.tsmap))
                return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + tpn;
        result = prime * result + Arrays.hashCode(tsmap);
        return result;
    }

}
