// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmExpOchSigIdVer13 implements OFOxmExpOchSigId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmExpOchSigIdVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 14;

        private final static CircuitSignalID DEFAULT_VALUE = CircuitSignalID.NONE;

    // OF message fields
    private final CircuitSignalID value;
//
    // Immutable default instance
    final static OFOxmExpOchSigIdVer13 DEFAULT = new OFOxmExpOchSigIdVer13(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmExpOchSigIdVer13(CircuitSignalID value) {
        if(value == null) {
            throw new NullPointerException("OFOxmExpOchSigIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0xffff0a06L;
    }

    @Override
    public long getExperimenter() {
        return 0xff000007L;
    }

    @Override
    public CircuitSignalID getValue() {
        return value;
    }

    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.EXP_OCH_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxm<CircuitSignalID> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public CircuitSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOxmExpOchSigId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmExpOchSigId.Builder {
        final OFOxmExpOchSigIdVer13 parentMessage;

        // OF message fields
        private boolean valueSet;
        private CircuitSignalID value;

        BuilderWithParent(OFOxmExpOchSigIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0xffff0a06L;
    }

    @Override
    public long getExperimenter() {
        return 0xff000007L;
    }

    @Override
    public CircuitSignalID getValue() {
        return value;
    }

    @Override
    public OFOxmExpOchSigId.Builder setValue(CircuitSignalID value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.EXP_OCH_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<CircuitSignalID> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public CircuitSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOxmExpOchSigId build() {
                CircuitSignalID value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxmExpOchSigIdVer13(
                    value
                );
        }

    }

    static class Builder implements OFOxmExpOchSigId.Builder {
        // OF message fields
        private boolean valueSet;
        private CircuitSignalID value;

    @Override
    public long getTypeLen() {
        return 0xffff0a06L;
    }

    @Override
    public long getExperimenter() {
        return 0xff000007L;
    }

    @Override
    public CircuitSignalID getValue() {
        return value;
    }

    @Override
    public OFOxmExpOchSigId.Builder setValue(CircuitSignalID value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.EXP_OCH_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<CircuitSignalID> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public CircuitSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOxmExpOchSigId build() {
            CircuitSignalID value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxmExpOchSigIdVer13(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmExpOchSigId> {
        @Override
        public OFOxmExpOchSigId readFrom(ByteBuf bb) throws OFParseError {
            // fixed value property typeLen == 0xffff0a06L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0xffff0a06)
                throw new OFParseError("Wrong typeLen: Expected=0xffff0a06L(0xffff0a06L), got="+typeLen);
            // fixed value property experimenter == 0xff000007L
            int experimenter = bb.readInt();
            if(experimenter != (int) 0xff000007)
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got="+experimenter);
            CircuitSignalID value = CircuitSignalID.read6Bytes(bb);

            OFOxmExpOchSigIdVer13 oxmExpOchSigIdVer13 = new OFOxmExpOchSigIdVer13(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmExpOchSigIdVer13);
            return oxmExpOchSigIdVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmExpOchSigIdVer13Funnel FUNNEL = new OFOxmExpOchSigIdVer13Funnel();
    static class OFOxmExpOchSigIdVer13Funnel implements Funnel<OFOxmExpOchSigIdVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmExpOchSigIdVer13 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0xffff0a06L
            sink.putInt((int) 0xffff0a06);
            // fixed value property experimenter = 0xff000007L
            sink.putInt((int) 0xff000007);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmExpOchSigIdVer13> {
        @Override
        public void write(ByteBuf bb, OFOxmExpOchSigIdVer13 message) {
            // fixed value property typeLen = 0xffff0a06L
            bb.writeInt((int) 0xffff0a06);
            // fixed value property experimenter = 0xff000007L
            bb.writeInt((int) 0xff000007);
            message.value.write6Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmExpOchSigIdVer13(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmExpOchSigIdVer13 other = (OFOxmExpOchSigIdVer13) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
