// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver14;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnSwitchPipelineStatsEntryVer14 implements OFBsnSwitchPipelineStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSwitchPipelineStatsEntryVer14.class);
    // version: 1.4
    final static byte WIRE_VERSION = 5;
    final static int LENGTH = 256;

        private final static String DEFAULT_PIPELINE = "";

    // OF message fields
    private final String pipeline;
//
    // Immutable default instance
    final static OFBsnSwitchPipelineStatsEntryVer14 DEFAULT = new OFBsnSwitchPipelineStatsEntryVer14(
        DEFAULT_PIPELINE
    );

    // package private constructor - used by readers, builders, and factory
    OFBsnSwitchPipelineStatsEntryVer14(String pipeline) {
        if(pipeline == null) {
            throw new NullPointerException("OFBsnSwitchPipelineStatsEntryVer14: property pipeline cannot be null");
        }
        this.pipeline = pipeline;
    }

    // Accessors for OF message fields
    @Override
    public String getPipeline() {
        return pipeline;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



    public OFBsnSwitchPipelineStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnSwitchPipelineStatsEntry.Builder {
        final OFBsnSwitchPipelineStatsEntryVer14 parentMessage;

        // OF message fields
        private boolean pipelineSet;
        private String pipeline;

        BuilderWithParent(OFBsnSwitchPipelineStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public String getPipeline() {
        return pipeline;
    }

    @Override
    public OFBsnSwitchPipelineStatsEntry.Builder setPipeline(String pipeline) {
        this.pipeline = pipeline;
        this.pipelineSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



        @Override
        public OFBsnSwitchPipelineStatsEntry build() {
                String pipeline = this.pipelineSet ? this.pipeline : parentMessage.pipeline;
                if(pipeline == null)
                    throw new NullPointerException("Property pipeline must not be null");

                //
                return new OFBsnSwitchPipelineStatsEntryVer14(
                    pipeline
                );
        }

    }

    static class Builder implements OFBsnSwitchPipelineStatsEntry.Builder {
        // OF message fields
        private boolean pipelineSet;
        private String pipeline;

    @Override
    public String getPipeline() {
        return pipeline;
    }

    @Override
    public OFBsnSwitchPipelineStatsEntry.Builder setPipeline(String pipeline) {
        this.pipeline = pipeline;
        this.pipelineSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

//
        @Override
        public OFBsnSwitchPipelineStatsEntry build() {
            String pipeline = this.pipelineSet ? this.pipeline : DEFAULT_PIPELINE;
            if(pipeline == null)
                throw new NullPointerException("Property pipeline must not be null");


            return new OFBsnSwitchPipelineStatsEntryVer14(
                    pipeline
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnSwitchPipelineStatsEntry> {
        @Override
        public OFBsnSwitchPipelineStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            String pipeline = ChannelUtils.readFixedLengthString(bb, 256);

            OFBsnSwitchPipelineStatsEntryVer14 bsnSwitchPipelineStatsEntryVer14 = new OFBsnSwitchPipelineStatsEntryVer14(
                    pipeline
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnSwitchPipelineStatsEntryVer14);
            return bsnSwitchPipelineStatsEntryVer14;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnSwitchPipelineStatsEntryVer14Funnel FUNNEL = new OFBsnSwitchPipelineStatsEntryVer14Funnel();
    static class OFBsnSwitchPipelineStatsEntryVer14Funnel implements Funnel<OFBsnSwitchPipelineStatsEntryVer14> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnSwitchPipelineStatsEntryVer14 message, PrimitiveSink sink) {
            sink.putUnencodedChars(message.pipeline);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnSwitchPipelineStatsEntryVer14> {
        @Override
        public void write(ByteBuf bb, OFBsnSwitchPipelineStatsEntryVer14 message) {
            ChannelUtils.writeFixedLengthString(bb, message.pipeline, 256);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSwitchPipelineStatsEntryVer14(");
        b.append("pipeline=").append(pipeline);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnSwitchPipelineStatsEntryVer14 other = (OFBsnSwitchPipelineStatsEntryVer14) obj;

        if (pipeline == null) {
            if (other.pipeline != null)
                return false;
        } else if (!pipeline.equals(other.pipeline))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((pipeline == null) ? 0 : pipeline.hashCode());
        return result;
    }

}
