// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionNiciraMoveVer15 implements OFActionNiciraMove {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraMoveVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 24;

        private final static int DEFAULT_N_BITS = 0x0;
        private final static int DEFAULT_SRC_OFS = 0x0;
        private final static int DEFAULT_DST_OFS = 0x0;
        private final static long DEFAULT_SRC = 0x0L;
        private final static long DEFAULT_DST = 0x0L;

    // OF message fields
    private final int nBits;
    private final int srcOfs;
    private final int dstOfs;
    private final long src;
    private final long dst;
//
    // Immutable default instance
    final static OFActionNiciraMoveVer15 DEFAULT = new OFActionNiciraMoveVer15(
        DEFAULT_N_BITS, DEFAULT_SRC_OFS, DEFAULT_DST_OFS, DEFAULT_SRC, DEFAULT_DST
    );

    // package private constructor - used by readers, builders, and factory
    OFActionNiciraMoveVer15(int nBits, int srcOfs, int dstOfs, long src, long dst) {
        this.nBits = nBits;
        this.srcOfs = srcOfs;
        this.dstOfs = dstOfs;
        this.src = src;
        this.dst = dst;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x6;
    }

    @Override
    public int getNBits() {
        return nBits;
    }

    @Override
    public int getSrcOfs() {
        return srcOfs;
    }

    @Override
    public int getDstOfs() {
        return dstOfs;
    }

    @Override
    public long getSrc() {
        return src;
    }

    @Override
    public long getDst() {
        return dst;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFActionNiciraMove.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionNiciraMove.Builder {
        final OFActionNiciraMoveVer15 parentMessage;

        // OF message fields
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOfsSet;
        private int srcOfs;
        private boolean dstOfsSet;
        private int dstOfs;
        private boolean srcSet;
        private long src;
        private boolean dstSet;
        private long dst;

        BuilderWithParent(OFActionNiciraMoveVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x6;
    }

    @Override
    public int getNBits() {
        return nBits;
    }

    @Override
    public OFActionNiciraMove.Builder setNBits(int nBits) {
        this.nBits = nBits;
        this.nBitsSet = true;
        return this;
    }
    @Override
    public int getSrcOfs() {
        return srcOfs;
    }

    @Override
    public OFActionNiciraMove.Builder setSrcOfs(int srcOfs) {
        this.srcOfs = srcOfs;
        this.srcOfsSet = true;
        return this;
    }
    @Override
    public int getDstOfs() {
        return dstOfs;
    }

    @Override
    public OFActionNiciraMove.Builder setDstOfs(int dstOfs) {
        this.dstOfs = dstOfs;
        this.dstOfsSet = true;
        return this;
    }
    @Override
    public long getSrc() {
        return src;
    }

    @Override
    public OFActionNiciraMove.Builder setSrc(long src) {
        this.src = src;
        this.srcSet = true;
        return this;
    }
    @Override
    public long getDst() {
        return dst;
    }

    @Override
    public OFActionNiciraMove.Builder setDst(long dst) {
        this.dst = dst;
        this.dstSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFActionNiciraMove build() {
                int nBits = this.nBitsSet ? this.nBits : parentMessage.nBits;
                int srcOfs = this.srcOfsSet ? this.srcOfs : parentMessage.srcOfs;
                int dstOfs = this.dstOfsSet ? this.dstOfs : parentMessage.dstOfs;
                long src = this.srcSet ? this.src : parentMessage.src;
                long dst = this.dstSet ? this.dst : parentMessage.dst;

                //
                return new OFActionNiciraMoveVer15(
                    nBits,
                    srcOfs,
                    dstOfs,
                    src,
                    dst
                );
        }

    }

    static class Builder implements OFActionNiciraMove.Builder {
        // OF message fields
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOfsSet;
        private int srcOfs;
        private boolean dstOfsSet;
        private int dstOfs;
        private boolean srcSet;
        private long src;
        private boolean dstSet;
        private long dst;

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x6;
    }

    @Override
    public int getNBits() {
        return nBits;
    }

    @Override
    public OFActionNiciraMove.Builder setNBits(int nBits) {
        this.nBits = nBits;
        this.nBitsSet = true;
        return this;
    }
    @Override
    public int getSrcOfs() {
        return srcOfs;
    }

    @Override
    public OFActionNiciraMove.Builder setSrcOfs(int srcOfs) {
        this.srcOfs = srcOfs;
        this.srcOfsSet = true;
        return this;
    }
    @Override
    public int getDstOfs() {
        return dstOfs;
    }

    @Override
    public OFActionNiciraMove.Builder setDstOfs(int dstOfs) {
        this.dstOfs = dstOfs;
        this.dstOfsSet = true;
        return this;
    }
    @Override
    public long getSrc() {
        return src;
    }

    @Override
    public OFActionNiciraMove.Builder setSrc(long src) {
        this.src = src;
        this.srcSet = true;
        return this;
    }
    @Override
    public long getDst() {
        return dst;
    }

    @Override
    public OFActionNiciraMove.Builder setDst(long dst) {
        this.dst = dst;
        this.dstSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFActionNiciraMove build() {
            int nBits = this.nBitsSet ? this.nBits : DEFAULT_N_BITS;
            int srcOfs = this.srcOfsSet ? this.srcOfs : DEFAULT_SRC_OFS;
            int dstOfs = this.dstOfsSet ? this.dstOfs : DEFAULT_DST_OFS;
            long src = this.srcSet ? this.src : DEFAULT_SRC;
            long dst = this.dstSet ? this.dst : DEFAULT_DST;


            return new OFActionNiciraMoveVer15(
                    nBits,
                    srcOfs,
                    dstOfs,
                    src,
                    dst
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionNiciraMove> {
        @Override
        public OFActionNiciraMove readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 65535
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 24)
                throw new OFParseError("Wrong length: Expected=24(24), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x2320L
            int experimenter = bb.readInt();
            if(experimenter != 0x2320)
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got="+experimenter);
            // fixed value property subtype == 0x6
            short subtype = bb.readShort();
            if(subtype != (short) 0x6)
                throw new OFParseError("Wrong subtype: Expected=0x6(0x6), got="+subtype);
            int nBits = U16.f(bb.readShort());
            int srcOfs = U16.f(bb.readShort());
            int dstOfs = U16.f(bb.readShort());
            long src = U32.f(bb.readInt());
            long dst = U32.f(bb.readInt());

            OFActionNiciraMoveVer15 actionNiciraMoveVer15 = new OFActionNiciraMoveVer15(
                    nBits,
                      srcOfs,
                      dstOfs,
                      src,
                      dst
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionNiciraMoveVer15);
            return actionNiciraMoveVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionNiciraMoveVer15Funnel FUNNEL = new OFActionNiciraMoveVer15Funnel();
    static class OFActionNiciraMoveVer15Funnel implements Funnel<OFActionNiciraMoveVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionNiciraMoveVer15 message, PrimitiveSink sink) {
            // fixed value property type = 65535
            sink.putShort((short) 0xffff);
            // fixed value property length = 24
            sink.putShort((short) 0x18);
            // fixed value property experimenter = 0x2320L
            sink.putInt(0x2320);
            // fixed value property subtype = 0x6
            sink.putShort((short) 0x6);
            sink.putInt(message.nBits);
            sink.putInt(message.srcOfs);
            sink.putInt(message.dstOfs);
            sink.putLong(message.src);
            sink.putLong(message.dst);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionNiciraMoveVer15> {
        @Override
        public void write(ByteBuf bb, OFActionNiciraMoveVer15 message) {
            // fixed value property type = 65535
            bb.writeShort((short) 0xffff);
            // fixed value property length = 24
            bb.writeShort((short) 0x18);
            // fixed value property experimenter = 0x2320L
            bb.writeInt(0x2320);
            // fixed value property subtype = 0x6
            bb.writeShort((short) 0x6);
            bb.writeShort(U16.t(message.nBits));
            bb.writeShort(U16.t(message.srcOfs));
            bb.writeShort(U16.t(message.dstOfs));
            bb.writeInt(U32.t(message.src));
            bb.writeInt(U32.t(message.dst));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraMoveVer15(");
        b.append("nBits=").append(nBits);
        b.append(", ");
        b.append("srcOfs=").append(srcOfs);
        b.append(", ");
        b.append("dstOfs=").append(dstOfs);
        b.append(", ");
        b.append("src=").append(src);
        b.append(", ");
        b.append("dst=").append(dst);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionNiciraMoveVer15 other = (OFActionNiciraMoveVer15) obj;

        if( nBits != other.nBits)
            return false;
        if( srcOfs != other.srcOfs)
            return false;
        if( dstOfs != other.dstOfs)
            return false;
        if( src != other.src)
            return false;
        if( dst != other.dst)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + nBits;
        result = prime * result + srcOfs;
        result = prime * result + dstOfs;
        result = prime *  (int) (src ^ (src >>> 32));
        result = prime *  (int) (dst ^ (dst >>> 32));
        return result;
    }

}
