// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFControllerStatusPropUriVer15 implements OFControllerStatusPropUri {
    private static final Logger logger = LoggerFactory.getLogger(OFControllerStatusPropUriVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 36;


    // OF message fields
    private final OFConnectionIndex uri;
//

    // package private constructor - used by readers, builders, and factory
    OFControllerStatusPropUriVer15(OFConnectionIndex uri) {
        if(uri == null) {
            throw new NullPointerException("OFControllerStatusPropUriVer15: property uri cannot be null");
        }
        this.uri = uri;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x0;
    }

    @Override
    public OFConnectionIndex getUri() {
        return uri;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFControllerStatusPropUri.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFControllerStatusPropUri.Builder {
        final OFControllerStatusPropUriVer15 parentMessage;

        // OF message fields
        private boolean uriSet;
        private OFConnectionIndex uri;

        BuilderWithParent(OFControllerStatusPropUriVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x0;
    }

    @Override
    public OFConnectionIndex getUri() {
        return uri;
    }

    @Override
    public OFControllerStatusPropUri.Builder setUri(OFConnectionIndex uri) {
        this.uri = uri;
        this.uriSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFControllerStatusPropUri build() {
                OFConnectionIndex uri = this.uriSet ? this.uri : parentMessage.uri;
                if(uri == null)
                    throw new NullPointerException("Property uri must not be null");

                //
                return new OFControllerStatusPropUriVer15(
                    uri
                );
        }

    }

    static class Builder implements OFControllerStatusPropUri.Builder {
        // OF message fields
        private boolean uriSet;
        private OFConnectionIndex uri;

    @Override
    public int getType() {
        return 0x0;
    }

    @Override
    public OFConnectionIndex getUri() {
        return uri;
    }

    @Override
    public OFControllerStatusPropUri.Builder setUri(OFConnectionIndex uri) {
        this.uri = uri;
        this.uriSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFControllerStatusPropUri build() {
            if(!this.uriSet)
                throw new IllegalStateException("Property uri doesn't have default value -- must be set");
            if(uri == null)
                throw new NullPointerException("Property uri must not be null");


            return new OFControllerStatusPropUriVer15(
                    uri
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFControllerStatusPropUri> {
        @Override
        public OFControllerStatusPropUri readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x0
            short type = bb.readShort();
            if(type != (short) 0x0)
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 36)
                throw new OFParseError("Wrong length: Expected=36(36), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            OFConnectionIndex uri = OFConnectionIndex.read4Bytes(bb);

            OFControllerStatusPropUriVer15 controllerStatusPropUriVer15 = new OFControllerStatusPropUriVer15(
                    uri
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", controllerStatusPropUriVer15);
            return controllerStatusPropUriVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFControllerStatusPropUriVer15Funnel FUNNEL = new OFControllerStatusPropUriVer15Funnel();
    static class OFControllerStatusPropUriVer15Funnel implements Funnel<OFControllerStatusPropUriVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFControllerStatusPropUriVer15 message, PrimitiveSink sink) {
            // fixed value property type = 0x0
            sink.putShort((short) 0x0);
            // fixed value property length = 36
            sink.putShort((short) 0x24);
            message.uri.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFControllerStatusPropUriVer15> {
        @Override
        public void write(ByteBuf bb, OFControllerStatusPropUriVer15 message) {
            // fixed value property type = 0x0
            bb.writeShort((short) 0x0);
            // fixed value property length = 36
            bb.writeShort((short) 0x24);
            message.uri.write4Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFControllerStatusPropUriVer15(");
        b.append("uri=").append(uri);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFControllerStatusPropUriVer15 other = (OFControllerStatusPropUriVer15) obj;

        if (uri == null) {
            if (other.uri != null)
                return false;
        } else if (!uri.equals(other.uri))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((uri == null) ? 0 : uri.hashCode());
        return result;
    }

}
