// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFTimeVer15 implements OFTime {
    private static final Logger logger = LoggerFactory.getLogger(OFTimeVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 16;

        private final static U64 DEFAULT_SECONDS = U64.ZERO;
        private final static long DEFAULT_NANOSECONDS = 0x0L;

    // OF message fields
    private final U64 seconds;
    private final long nanoseconds;
//
    // Immutable default instance
    final static OFTimeVer15 DEFAULT = new OFTimeVer15(
        DEFAULT_SECONDS, DEFAULT_NANOSECONDS
    );

    // package private constructor - used by readers, builders, and factory
    OFTimeVer15(U64 seconds, long nanoseconds) {
        if(seconds == null) {
            throw new NullPointerException("OFTimeVer15: property seconds cannot be null");
        }
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    // Accessors for OF message fields
    @Override
    public U64 getSeconds() {
        return seconds;
    }

    @Override
    public long getNanoseconds() {
        return nanoseconds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFTime.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFTime.Builder {
        final OFTimeVer15 parentMessage;

        // OF message fields
        private boolean secondsSet;
        private U64 seconds;
        private boolean nanosecondsSet;
        private long nanoseconds;

        BuilderWithParent(OFTimeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public U64 getSeconds() {
        return seconds;
    }

    @Override
    public OFTime.Builder setSeconds(U64 seconds) {
        this.seconds = seconds;
        this.secondsSet = true;
        return this;
    }
    @Override
    public long getNanoseconds() {
        return nanoseconds;
    }

    @Override
    public OFTime.Builder setNanoseconds(long nanoseconds) {
        this.nanoseconds = nanoseconds;
        this.nanosecondsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFTime build() {
                U64 seconds = this.secondsSet ? this.seconds : parentMessage.seconds;
                if(seconds == null)
                    throw new NullPointerException("Property seconds must not be null");
                long nanoseconds = this.nanosecondsSet ? this.nanoseconds : parentMessage.nanoseconds;

                //
                return new OFTimeVer15(
                    seconds,
                    nanoseconds
                );
        }

    }

    static class Builder implements OFTime.Builder {
        // OF message fields
        private boolean secondsSet;
        private U64 seconds;
        private boolean nanosecondsSet;
        private long nanoseconds;

    @Override
    public U64 getSeconds() {
        return seconds;
    }

    @Override
    public OFTime.Builder setSeconds(U64 seconds) {
        this.seconds = seconds;
        this.secondsSet = true;
        return this;
    }
    @Override
    public long getNanoseconds() {
        return nanoseconds;
    }

    @Override
    public OFTime.Builder setNanoseconds(long nanoseconds) {
        this.nanoseconds = nanoseconds;
        this.nanosecondsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFTime build() {
            U64 seconds = this.secondsSet ? this.seconds : DEFAULT_SECONDS;
            if(seconds == null)
                throw new NullPointerException("Property seconds must not be null");
            long nanoseconds = this.nanosecondsSet ? this.nanoseconds : DEFAULT_NANOSECONDS;


            return new OFTimeVer15(
                    seconds,
                    nanoseconds
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFTime> {
        @Override
        public OFTime readFrom(ByteBuf bb) throws OFParseError {
            U64 seconds = U64.ofRaw(bb.readLong());
            long nanoseconds = U32.f(bb.readInt());
            // pad: 4 bytes
            bb.skipBytes(4);

            OFTimeVer15 timeVer15 = new OFTimeVer15(
                    seconds,
                      nanoseconds
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", timeVer15);
            return timeVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFTimeVer15Funnel FUNNEL = new OFTimeVer15Funnel();
    static class OFTimeVer15Funnel implements Funnel<OFTimeVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFTimeVer15 message, PrimitiveSink sink) {
            message.seconds.putTo(sink);
            sink.putLong(message.nanoseconds);
            // skip pad (4 bytes)
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFTimeVer15> {
        @Override
        public void write(ByteBuf bb, OFTimeVer15 message) {
            bb.writeLong(message.seconds.getValue());
            bb.writeInt(U32.t(message.nanoseconds));
            // pad: 4 bytes
            bb.writeZero(4);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFTimeVer15(");
        b.append("seconds=").append(seconds);
        b.append(", ");
        b.append("nanoseconds=").append(nanoseconds);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFTimeVer15 other = (OFTimeVer15) obj;

        if (seconds == null) {
            if (other.seconds != null)
                return false;
        } else if (!seconds.equals(other.seconds))
            return false;
        if( nanoseconds != other.nanoseconds)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((seconds == null) ? 0 : seconds.hashCode());
        result = prime *  (int) (nanoseconds ^ (nanoseconds >>> 32));
        return result;
    }

}
