/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFTableStatsEntry;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFTableStatsEntryVer10;

public class OFTableStatsEntryVer10Test {
    OFFactory factory;
    static final byte[] TABLE_STATS_ENTRY_SERIALIZED = new byte[]{3, 0, 0, 0, 102, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, -1, -1, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, -1, -1, -1, -1, -1, -127, 17, 17, 17, 17, 17, 17, 17};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_STATS_ENTRY_SERIALIZED);
        OFTableStatsEntry tableStatsEntry = OFTableStatsEntryVer10.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_STATS_ENTRY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        tableStatsEntry.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_STATS_ENTRY_SERIALIZED));
    }
}

