/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFAdaptationsType;
import org.projectfloodlight.openflow.protocol.OFExpPortDescReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportLayerClass;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportSignalType;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.ver13.OFExpPortDescReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;

public class OFExpPortDescReplyVer13Test {
    OFFactory factory;
    static final byte[] EXP_PORT_DESC_REPLY_SERIALIZED = new byte[]{4, 19, 0, 88, 18, 52, 86, 120, -1, -1, 0, 0, 0, 0, 0, 0, -1, 0, 0, 7, 0, 0, 0, 1, 0, 0, 0, 1, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105, 110, 116, 101, 114, 102, 97, 99, 101, 49, 50, 51, 52, 53, 54, 55, 0, 0, 0, 96, 0, 0, 0, 4, 0, 2, 0, 24, 12, 0, 0, 0, 0, 2, 0, 16, 0, 0, 0, 0, 3, 1, 6, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFExpPortDescReply.Builder builder = this.factory.buildExpPortDescReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of()).setEntries((List)ImmutableList.of((Object)this.factory.buildExpPort().setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"00:00:00:00:00:00")).setName("interface1234567").setConfig((Set)Sets.immutableEnumSet((Enum)OFPortConfig.NO_FWD, (Enum[])new OFPortConfig[]{OFPortConfig.NO_PACKET_IN})).setState((Set)Sets.immutableEnumSet((Enum)OFPortState.LIVE, (Enum[])new OFPortState[0])).setProperties((List)ImmutableList.of((Object)this.factory.buildExpPortDescPropOpticalTransport().setPortSignalType(OFPortOpticalTransportSignalType.OTU2).setFeatures((List)ImmutableList.of((Object)this.factory.buildExpPortOpticalTransportLayerStack().setValue((List)ImmutableList.of((Object)this.factory.buildExpPortOpticalTransportLayerEntry().setLayerClass(OFPortOpticalTransportLayerClass.ODU).setSignalType((short)1).setAdaptation(OFAdaptationsType.ODUK_ODUIJ).build())).build())).build())).build())).build();
        OFExpPortDescReply expPortDescReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        expPortDescReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)EXP_PORT_DESC_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFExpPortDescReply.Builder builder = this.factory.buildExpPortDescReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of()).setEntries((List)ImmutableList.of((Object)this.factory.buildExpPort().setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"00:00:00:00:00:00")).setName("interface1234567").setConfig((Set)Sets.immutableEnumSet((Enum)OFPortConfig.NO_FWD, (Enum[])new OFPortConfig[]{OFPortConfig.NO_PACKET_IN})).setState((Set)Sets.immutableEnumSet((Enum)OFPortState.LIVE, (Enum[])new OFPortState[0])).setProperties((List)ImmutableList.of((Object)this.factory.buildExpPortDescPropOpticalTransport().setPortSignalType(OFPortOpticalTransportSignalType.OTU2).setFeatures((List)ImmutableList.of((Object)this.factory.buildExpPortOpticalTransportLayerStack().setValue((List)ImmutableList.of((Object)this.factory.buildExpPortOpticalTransportLayerEntry().setLayerClass(OFPortOpticalTransportLayerClass.ODU).setSignalType((short)1).setAdaptation(OFAdaptationsType.ODUK_ODUIJ).build())).build())).build())).build())).build();
        OFExpPortDescReply expPortDescReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])EXP_PORT_DESC_REPLY_SERIALIZED);
        OFExpPortDescReply expPortDescReplyRead = OFExpPortDescReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)EXP_PORT_DESC_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)expPortDescReplyBuilt, (Object)expPortDescReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])EXP_PORT_DESC_REPLY_SERIALIZED);
        OFExpPortDescReply expPortDescReply = OFExpPortDescReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)EXP_PORT_DESC_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        expPortDescReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)EXP_PORT_DESC_REPLY_SERIALIZED));
    }
}

