/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBadActionCode;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadActionErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFErrorMsgs;
import org.projectfloodlight.openflow.protocol.ver15.OFBadActionErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFErrorMsgsVer15;
import org.projectfloodlight.openflow.types.OFErrorCauseData;

public class OFBadActionErrorMsgVer15Test {
    OFErrorMsgs factory;
    static final byte[] BAD_ACTION_ERROR_MSG_SERIALIZED = new byte[]{6, 1, 0, 15, 18, 52, 86, 120, 0, 2, 0, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFErrorMsgsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBadActionErrorMsg.Builder builder = this.factory.buildBadActionErrorMsg();
        builder.setXid(305419896L).setCode(OFBadActionCode.BAD_TYPE).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFBadActionErrorMsg badActionErrorMsg = builder.build();
        ByteBuf bb = Unpooled.buffer();
        badActionErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BAD_ACTION_ERROR_MSG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBadActionErrorMsg.Builder builder = this.factory.buildBadActionErrorMsg();
        builder.setXid(305419896L).setCode(OFBadActionCode.BAD_TYPE).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFBadActionErrorMsg badActionErrorMsgBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BAD_ACTION_ERROR_MSG_SERIALIZED);
        OFBadActionErrorMsg badActionErrorMsgRead = OFBadActionErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BAD_ACTION_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)badActionErrorMsgBuilt, (Object)badActionErrorMsgRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BAD_ACTION_ERROR_MSG_SERIALIZED);
        OFBadActionErrorMsg badActionErrorMsg = OFBadActionErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BAD_ACTION_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        badActionErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BAD_ACTION_ERROR_MSG_SERIALIZED));
    }
}

