/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBundleAddMsg;
import org.projectfloodlight.openflow.protocol.OFBundleFlags;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleAddMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.types.BundleId;
import org.projectfloodlight.openflow.types.U64;

public class OFBundleAddMsgVer15Test {
    OFFactory factory;
    static final byte[] BUNDLE_ADD_MSG_SERIALIZED = new byte[]{6, 34, 0, 50, 18, 52, 86, 120, 0, 0, 0, 1, 0, 0, 1, 6, 2, 0, 11, 17, 17, 17, 17, 97, 98, 99, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 59, -102, -54, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBundleAddMsg.Builder builder = this.factory.buildBundleAddMsg();
        builder.setXid(305419896L).setBundleId(BundleId.of((int)1)).setFlags((Set)ImmutableSet.of((Object)OFBundleFlags.ATOMIC)).setProperties((List)ImmutableList.of((Object)this.factory.buildBundlePropTime().setScheduledTime((List)ImmutableList.of((Object)this.factory.buildTime().setSeconds(U64.of((long)1L)).setNanoseconds(1000000000L).build())).build())).setMessage((OFMessage)this.factory.buildEchoRequest().setXid(0x11111111L).setData(new byte[]{97, 98, 99}).build()).build();
        OFBundleAddMsg bundleAddMsg = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bundleAddMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BUNDLE_ADD_MSG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBundleAddMsg.Builder builder = this.factory.buildBundleAddMsg();
        builder.setXid(305419896L).setBundleId(BundleId.of((int)1)).setFlags((Set)ImmutableSet.of((Object)OFBundleFlags.ATOMIC)).setProperties((List)ImmutableList.of((Object)this.factory.buildBundlePropTime().setScheduledTime((List)ImmutableList.of((Object)this.factory.buildTime().setSeconds(U64.of((long)1L)).setNanoseconds(1000000000L).build())).build())).setMessage((OFMessage)this.factory.buildEchoRequest().setXid(0x11111111L).setData(new byte[]{97, 98, 99}).build()).build();
        OFBundleAddMsg bundleAddMsgBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BUNDLE_ADD_MSG_SERIALIZED);
        OFBundleAddMsg bundleAddMsgRead = OFBundleAddMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BUNDLE_ADD_MSG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bundleAddMsgBuilt, (Object)bundleAddMsgRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BUNDLE_ADD_MSG_SERIALIZED);
        OFBundleAddMsg bundleAddMsg = OFBundleAddMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BUNDLE_ADD_MSG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bundleAddMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BUNDLE_ADD_MSG_SERIALIZED));
    }
}

