/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.op4j.exceptions.ExecutionException;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnToDateMidnight {
    private static final TimestampToDateMidnight TIMESTAMP_TO_DATE_MIDNIGHT = new TimestampToDateMidnight();
    private static final LongToDateMidnight LONG_TO_DATE_MIDNIGHT = new LongToDateMidnight();
    private static final IntegerFieldCollectionToDateMidnight INTEGER_FIELD_COLLECTION_TO_DATE_MIDNIGHT = new IntegerFieldCollectionToDateMidnight();
    private static final IntegerFieldArrayToDateMidnight INTEGER_FIELD_ARRAY_TO_DATE_MIDNIGHT = new IntegerFieldArrayToDateMidnight();
    private static final StringFieldCollectionToDateMidnight STRING_FIELD_COLLECTION_TO_DATE_MIDNIGHT = new StringFieldCollectionToDateMidnight();
    private static final StringFieldArrayToDateMidnight STRING_FIELD_ARRAY_TO_DATE_MIDNIGHT = new StringFieldArrayToDateMidnight();

    private FnToDateMidnight() {
    }

    public static final Function<String, DateMidnight> fromString(String pattern) {
        return new StringToDateMidnight(pattern);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, DateTimeZone dateTimeZone) {
        return new StringToDateMidnight(pattern, dateTimeZone);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, Chronology chronology) {
        return new StringToDateMidnight(pattern, chronology);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, Locale locale) {
        return new StringToDateMidnight(pattern, locale);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, String locale) {
        return new StringToDateMidnight(pattern, locale);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, Locale locale, DateTimeZone dateTimeZone) {
        return new StringToDateMidnight(pattern, locale, dateTimeZone);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, String locale, DateTimeZone dateTimeZone) {
        return new StringToDateMidnight(pattern, locale, dateTimeZone);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, Locale locale, Chronology chronology) {
        return new StringToDateMidnight(pattern, locale, chronology);
    }

    public static final Function<String, DateMidnight> fromString(String pattern, String locale, Chronology chronology) {
        return new StringToDateMidnight(pattern, locale, chronology);
    }

    public static final <T extends Date> Function<T, DateMidnight> fromDate() {
        return new DateToDateMidnight();
    }

    public static final <T extends Date> Function<T, DateMidnight> fromDate(DateTimeZone dateTimeZone) {
        return new DateToDateMidnight(dateTimeZone);
    }

    public static final <T extends Date> Function<T, DateMidnight> fromDate(Chronology chronology) {
        return new DateToDateMidnight(chronology);
    }

    public static final Function<Timestamp, DateMidnight> fromTimestamp() {
        return TIMESTAMP_TO_DATE_MIDNIGHT;
    }

    public static final Function<Timestamp, DateMidnight> fromTimestamp(DateTimeZone dateTimeZone) {
        return new TimestampToDateMidnight(dateTimeZone);
    }

    public static final Function<Timestamp, DateMidnight> fromTimestamp(Chronology chronology) {
        return new TimestampToDateMidnight(chronology);
    }

    public static final Function<Long, DateMidnight> fromLong() {
        return LONG_TO_DATE_MIDNIGHT;
    }

    public static final Function<Long, DateMidnight> fromLong(DateTimeZone dateTimeZone) {
        return new LongToDateMidnight(dateTimeZone);
    }

    public static final Function<Long, DateMidnight> fromLong(Chronology chronology) {
        return new LongToDateMidnight(chronology);
    }

    public static final Function<Collection<Integer>, DateMidnight> fromIntegerFieldCollection() {
        return INTEGER_FIELD_COLLECTION_TO_DATE_MIDNIGHT;
    }

    public static final Function<Collection<Integer>, DateMidnight> fromIntegerFieldCollection(Chronology chronology) {
        return new IntegerFieldCollectionToDateMidnight(chronology);
    }

    public static final Function<Integer[], DateMidnight> fromIntegerFieldArray() {
        return INTEGER_FIELD_ARRAY_TO_DATE_MIDNIGHT;
    }

    public static final Function<Integer[], DateMidnight> fromIntegerFieldArray(Chronology chronology) {
        return new IntegerFieldArrayToDateMidnight(chronology);
    }

    public static final Function<Collection<String>, DateMidnight> fromStringFieldCollection() {
        return STRING_FIELD_COLLECTION_TO_DATE_MIDNIGHT;
    }

    public static final Function<Collection<String>, DateMidnight> fromStringFieldCollection(Chronology chronology) {
        return new StringFieldCollectionToDateMidnight(chronology);
    }

    public static final Function<String[], DateMidnight> fromStringFieldArray() {
        return STRING_FIELD_ARRAY_TO_DATE_MIDNIGHT;
    }

    public static final Function<String[], DateMidnight> fromStringFieldArray(Chronology chronology) {
        return new StringFieldArrayToDateMidnight(chronology);
    }

    public static final <T extends Calendar> Function<T, DateMidnight> fromCalendar() {
        return new CalendarToDateMidnight();
    }

    public static final <T extends Calendar> Function<T, DateMidnight> fromCalendar(DateTimeZone dateTimeZone) {
        return new CalendarToDateMidnight(dateTimeZone);
    }

    public static final <T extends Calendar> Function<T, DateMidnight> fromCalendar(Chronology chronology) {
        return new CalendarToDateMidnight(chronology);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarToDateMidnight<T extends Calendar>
    extends BaseToDateMidnight<T> {
        public CalendarToDateMidnight() {
        }

        public CalendarToDateMidnight(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public CalendarToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateMidnight(object, this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateMidnight(object, this.chronology);
            }
            return new DateMidnight(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldArrayToDateMidnight
    extends BaseToDateMidnight<String[]> {
        public StringFieldArrayToDateMidnight() {
        }

        public StringFieldArrayToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(String[] object, ExecCtx ctx) throws Exception {
            String day;
            if (object.length < 1 || object.length > 3) {
                throw new ExecutionException("String arguments array for DateMidnight conversion should of size between 1 and 3 (year, month, day). Size " + object.length + " is not valid.");
            }
            String year = object[0];
            String month = object.length >= 2 ? object[1] : "0";
            String string = day = object.length >= 3 ? object[2] : "0";
            if (this.chronology != null) {
                return new DateMidnight(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), this.chronology);
            }
            return new DateMidnight(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldCollectionToDateMidnight
    extends BaseToDateMidnight<Collection<String>> {
        public StringFieldCollectionToDateMidnight() {
        }

        public StringFieldCollectionToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(Collection<String> object, ExecCtx ctx) throws Exception {
            String day;
            if (object.size() < 1 || object.size() > 3) {
                throw new ExecutionException("String arguments list for DateMidnight conversion should of size between 1 and 3 (year, month, day). Size " + object.size() + " is not valid.");
            }
            Iterator<String> iterator = object.iterator();
            String year = iterator.next();
            String month = object.size() >= 2 ? iterator.next() : "0";
            String string = day = object.size() >= 3 ? iterator.next() : "0";
            if (this.chronology != null) {
                return new DateMidnight(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), this.chronology);
            }
            return new DateMidnight(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldArrayToDateMidnight
    extends BaseToDateMidnight<Integer[]> {
        public IntegerFieldArrayToDateMidnight() {
        }

        public IntegerFieldArrayToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(Integer[] object, ExecCtx ctx) throws Exception {
            int day;
            if (object.length < 1 || object.length > 3) {
                throw new ExecutionException("Integer arguments array for DateMidnight conversion should of size between 1 and 3 (year, month, day). Size " + object.length + " is not valid.");
            }
            int year = object[0];
            int month = object.length >= 2 ? object[1] : 0;
            int n = day = object.length >= 3 ? object[2] : 0;
            if (this.chronology != null) {
                return new DateMidnight(year, month, day, this.chronology);
            }
            return new DateMidnight(year, month, day);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldCollectionToDateMidnight
    extends BaseToDateMidnight<Collection<Integer>> {
        public IntegerFieldCollectionToDateMidnight() {
        }

        public IntegerFieldCollectionToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(Collection<Integer> object, ExecCtx ctx) throws Exception {
            int day;
            if (object.size() < 1 || object.size() > 3) {
                throw new ExecutionException("Integer arguments list for DateMidnight conversion should of size between 1 and 3 (year, month, day). Size " + object.size() + " is not valid.");
            }
            Iterator<Integer> iterator = object.iterator();
            int year = iterator.next();
            int month = object.size() >= 2 ? iterator.next() : 1;
            int n = day = object.size() >= 3 ? iterator.next() : 1;
            if (this.chronology != null) {
                return new DateMidnight(year, month, day, this.chronology);
            }
            return new DateMidnight(year, month, day);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongToDateMidnight
    extends BaseToDateMidnight<Long> {
        public LongToDateMidnight() {
        }

        public LongToDateMidnight(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public LongToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(Long object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateMidnight(object.longValue(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateMidnight(object.longValue(), this.chronology);
            }
            return new DateMidnight(object.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampToDateMidnight
    extends BaseToDateMidnight<Timestamp> {
        public TimestampToDateMidnight() {
        }

        public TimestampToDateMidnight(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public TimestampToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(Timestamp object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateMidnight(object.getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateMidnight(object.getTime(), this.chronology);
            }
            return new DateMidnight(object.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateToDateMidnight<T extends Date>
    extends BaseToDateMidnight<T> {
        public DateToDateMidnight() {
        }

        public DateToDateMidnight(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public DateToDateMidnight(Chronology chronology) {
            super(chronology);
        }

        public DateMidnight nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateMidnight(((Date)object).getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateMidnight(((Date)object).getTime(), this.chronology);
            }
            return new DateMidnight(((Date)object).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringToDateMidnight
    extends BaseToDateMidnight<String> {
        private final String pattern;
        private final Locale locale;

        public StringToDateMidnight(String pattern) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToDateMidnight(String pattern, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToDateMidnight(String pattern, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToDateMidnight(String pattern, Locale locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToDateMidnight(String pattern, String locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToDateMidnight(String pattern, Locale locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToDateMidnight(String pattern, String locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToDateMidnight(String pattern, Locale locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToDateMidnight(String pattern, String locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public DateMidnight nullAsNullExecute(String object, ExecCtx ctx) throws Exception {
            DateTimeFormatter dateTimeFormatter = null;
            if (this.locale == null) {
                if (StringUtils.contains((String)this.pattern, (String)"MMM") || StringUtils.contains((String)this.pattern, (String)"EEE")) {
                    throw new ExecutionException("The use of MMM, MMMM, EEE or EEEE as part of the date pattern requires a Locale");
                }
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern);
            } else {
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern).withLocale(this.locale);
            }
            DateMidnight result = new DateMidnight();
            if (this.dateTimeZone != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(this.dateTimeZone);
            }
            if (this.chronology != null) {
                dateTimeFormatter = dateTimeFormatter.withChronology(this.chronology);
            }
            result = dateTimeFormatter.parseDateTime(object).toDateMidnight();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseToDateMidnight<T>
    extends AbstractNullAsNullFunction<T, DateMidnight> {
        final DateTimeZone dateTimeZone;
        final Chronology chronology;

        public BaseToDateMidnight() {
            this.dateTimeZone = null;
            this.chronology = null;
        }

        public BaseToDateMidnight(DateTimeZone dateTimeZone) {
            Validate.notNull((Object)dateTimeZone, (String)"dateTimeZone can't be null");
            this.dateTimeZone = dateTimeZone;
            this.chronology = null;
        }

        public BaseToDateMidnight(Chronology chronology) {
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.dateTimeZone = null;
            this.chronology = chronology;
        }
    }
}

