/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.op4j.exceptions.ExecutionException;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnToLocalTime {
    private static final TimestampToLocalTime TIMESTAMP_TO_LOCAL_TIME = new TimestampToLocalTime();
    private static final LongToLocalTime LONG_TO_LOCAL_TIME = new LongToLocalTime();
    private static final IntegerFieldCollectionToLocalTime INTEGER_FIELD_LIST_TO_LOCAL_TIME = new IntegerFieldCollectionToLocalTime();
    private static final IntegerFieldArrayToLocalTime INTEGER_FIELD_ARRAY_TO_LOCAL_TIME = new IntegerFieldArrayToLocalTime();
    private static final StringFieldCollectionToLocalTime STRING_FIELD_LIST_TO_LOCAL_TIME = new StringFieldCollectionToLocalTime();
    private static final StringFieldArrayToLocalTime STRING_FIELD_ARRAY_TO_LOCAL_TIME = new StringFieldArrayToLocalTime();

    private FnToLocalTime() {
    }

    public static final Function<String, LocalTime> fromString(String pattern) {
        return new StringToLocalTime(pattern);
    }

    public static final Function<String, LocalTime> fromString(String pattern, DateTimeZone dateTimeZone) {
        return new StringToLocalTime(pattern, dateTimeZone);
    }

    public static final Function<String, LocalTime> fromString(String pattern, Chronology chronology) {
        return new StringToLocalTime(pattern, chronology);
    }

    public static final Function<String, LocalTime> fromString(String pattern, Locale locale) {
        return new StringToLocalTime(pattern, locale);
    }

    public static final Function<String, LocalTime> fromString(String pattern, String locale) {
        return new StringToLocalTime(pattern, locale);
    }

    public static final Function<String, LocalTime> fromString(String pattern, Locale locale, DateTimeZone dateTimeZone) {
        return new StringToLocalTime(pattern, locale, dateTimeZone);
    }

    public static final Function<String, LocalTime> fromString(String pattern, String locale, DateTimeZone dateTimeZone) {
        return new StringToLocalTime(pattern, locale, dateTimeZone);
    }

    public static final Function<String, LocalTime> fromString(String pattern, Locale locale, Chronology chronology) {
        return new StringToLocalTime(pattern, locale, chronology);
    }

    public static final Function<String, LocalTime> fromString(String pattern, String locale, Chronology chronology) {
        return new StringToLocalTime(pattern, locale, chronology);
    }

    public static final <T extends Date> Function<T, LocalTime> fromDate() {
        return new DateToLocalTime();
    }

    public static final <T extends Date> Function<T, LocalTime> fromDate(DateTimeZone dateTimeZone) {
        return new DateToLocalTime(dateTimeZone);
    }

    public static final <T extends Date> Function<T, LocalTime> fromDate(Chronology chronology) {
        return new DateToLocalTime(chronology);
    }

    public static final Function<Timestamp, LocalTime> fromTimestamp() {
        return TIMESTAMP_TO_LOCAL_TIME;
    }

    public static final Function<Timestamp, LocalTime> fromTimestamp(DateTimeZone dateTimeZone) {
        return new TimestampToLocalTime(dateTimeZone);
    }

    public static final Function<Timestamp, LocalTime> fromTimestamp(Chronology chronology) {
        return new TimestampToLocalTime(chronology);
    }

    public static final Function<Long, LocalTime> fromLong() {
        return LONG_TO_LOCAL_TIME;
    }

    public static final Function<Long, LocalTime> fromLong(DateTimeZone dateTimeZone) {
        return new LongToLocalTime(dateTimeZone);
    }

    public static final Function<Long, LocalTime> fromLong(Chronology chronology) {
        return new LongToLocalTime(chronology);
    }

    public static final Function<Collection<Integer>, LocalTime> fromIntegerFieldCollection() {
        return INTEGER_FIELD_LIST_TO_LOCAL_TIME;
    }

    public static final Function<Collection<Integer>, LocalTime> fromIntegerFieldCollection(Chronology chronology) {
        return new IntegerFieldCollectionToLocalTime(chronology);
    }

    public static final Function<Integer[], LocalTime> fromIntegerFieldArray() {
        return INTEGER_FIELD_ARRAY_TO_LOCAL_TIME;
    }

    public static final Function<Integer[], LocalTime> fromIntegerFieldArray(Chronology chronology) {
        return new IntegerFieldArrayToLocalTime(chronology);
    }

    public static final Function<Collection<String>, LocalTime> fromStringFieldCollection() {
        return STRING_FIELD_LIST_TO_LOCAL_TIME;
    }

    public static final Function<Collection<String>, LocalTime> fromStringFieldCollection(Chronology chronology) {
        return new StringFieldCollectionToLocalTime(chronology);
    }

    public static final Function<String[], LocalTime> fromStringFieldArray() {
        return STRING_FIELD_ARRAY_TO_LOCAL_TIME;
    }

    public static final Function<String[], LocalTime> fromStringFieldArray(Chronology chronology) {
        return new StringFieldArrayToLocalTime(chronology);
    }

    public static final <T extends Calendar> Function<T, LocalTime> fromCalendar() {
        return new CalendarToLocalTime();
    }

    public static final <T extends Calendar> Function<T, LocalTime> fromCalendar(DateTimeZone dateTimeZone) {
        return new CalendarToLocalTime(dateTimeZone);
    }

    public static final <T extends Calendar> Function<T, LocalTime> fromCalendar(Chronology chronology) {
        return new CalendarToLocalTime(chronology);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarToLocalTime<T extends Calendar>
    extends BaseToLocalTime<T> {
        public CalendarToLocalTime() {
        }

        public CalendarToLocalTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public CalendarToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalTime(object, this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalTime(object, this.chronology);
            }
            return new LocalTime(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldArrayToLocalTime
    extends BaseToLocalTime<String[]> {
        public StringFieldArrayToLocalTime() {
        }

        public StringFieldArrayToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(String[] object, ExecCtx ctx) throws Exception {
            String milli;
            if (object.length < 1 || object.length > 4) {
                throw new ExecutionException("String arguments array for LocalTime conversion should have a size between 1 and 4. Size " + object.length + " is not valid.");
            }
            String hour = object[0];
            String minute = object.length >= 2 ? object[1] : "0";
            String second = object.length >= 3 ? object[2] : "0";
            String string = milli = object.length >= 4 ? object[3] : "0";
            if (this.chronology != null) {
                return new LocalTime(Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli), this.chronology);
            }
            return new LocalTime(Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldCollectionToLocalTime
    extends BaseToLocalTime<Collection<String>> {
        public StringFieldCollectionToLocalTime() {
        }

        public StringFieldCollectionToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(Collection<String> object, ExecCtx ctx) throws Exception {
            String milli;
            if (object.size() < 1 || object.size() > 4) {
                throw new ExecutionException("String arguments list for LocalTime conversion should have a size between 1 and 4. Size " + object.size() + " is not valid.");
            }
            Iterator<String> iterator = object.iterator();
            String hour = iterator.next();
            String minute = object.size() >= 2 ? iterator.next() : "0";
            String second = object.size() >= 3 ? iterator.next() : "0";
            String string = milli = object.size() >= 4 ? iterator.next() : "0";
            if (this.chronology != null) {
                return new LocalTime(Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli), this.chronology);
            }
            return new LocalTime(Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldArrayToLocalTime
    extends BaseToLocalTime<Integer[]> {
        public IntegerFieldArrayToLocalTime() {
        }

        public IntegerFieldArrayToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(Integer[] object, ExecCtx ctx) throws Exception {
            int milli;
            if (object.length < 1 || object.length > 4) {
                throw new ExecutionException("Integer arguments array for LocalTime conversion should have a size between 1 and 4. Size " + object.length + " is not valid.");
            }
            int hour = object[0];
            int minute = object.length >= 2 ? object[1] : 0;
            int second = object.length >= 3 ? object[2] : 0;
            int n = milli = object.length >= 4 ? object[3] : 0;
            if (this.chronology != null) {
                return new LocalTime(hour, minute, second, milli, this.chronology);
            }
            return new LocalTime(hour, minute, second, milli);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldCollectionToLocalTime
    extends BaseToLocalTime<Collection<Integer>> {
        public IntegerFieldCollectionToLocalTime() {
        }

        public IntegerFieldCollectionToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(Collection<Integer> object, ExecCtx ctx) throws Exception {
            int milli;
            if (object.size() < 1 || object.size() > 4) {
                throw new ExecutionException("Integer arguments list for LocalTime conversion should have a size between 1 and 4. Size " + object.size() + " is not valid.");
            }
            Iterator<Integer> iterator = object.iterator();
            int hour = iterator.next();
            int minute = object.size() >= 2 ? iterator.next() : 0;
            int second = object.size() >= 3 ? iterator.next() : 0;
            int n = milli = object.size() >= 4 ? iterator.next() : 0;
            if (this.chronology != null) {
                return new LocalTime(hour, minute, second, milli, this.chronology);
            }
            return new LocalTime(hour, minute, second, milli);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongToLocalTime
    extends BaseToLocalTime<Long> {
        public LongToLocalTime() {
        }

        public LongToLocalTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public LongToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(Long object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalTime(object.longValue(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalTime(object.longValue(), this.chronology);
            }
            return new LocalTime(object.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampToLocalTime
    extends BaseToLocalTime<Timestamp> {
        public TimestampToLocalTime() {
        }

        public TimestampToLocalTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public TimestampToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(Timestamp object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalTime(object.getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalTime(object.getTime(), this.chronology);
            }
            return new LocalTime(object.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateToLocalTime<T extends Date>
    extends BaseToLocalTime<T> {
        public DateToLocalTime() {
        }

        public DateToLocalTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public DateToLocalTime(Chronology chronology) {
            super(chronology);
        }

        public LocalTime nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalTime(((Date)object).getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalTime(((Date)object).getTime(), this.chronology);
            }
            return new LocalTime(((Date)object).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringToLocalTime
    extends BaseToLocalTime<String> {
        private final String pattern;
        private final Locale locale;

        public StringToLocalTime(String pattern) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToLocalTime(String pattern, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToLocalTime(String pattern, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToLocalTime(String pattern, Locale locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToLocalTime(String pattern, String locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToLocalTime(String pattern, Locale locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToLocalTime(String pattern, String locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToLocalTime(String pattern, Locale locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToLocalTime(String pattern, String locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public LocalTime nullAsNullExecute(String object, ExecCtx ctx) throws Exception {
            DateTimeFormatter dateTimeFormatter = null;
            if (this.locale == null) {
                if (StringUtils.contains((String)this.pattern, (String)"MMM") || StringUtils.contains((String)this.pattern, (String)"EEE")) {
                    throw new ExecutionException("The use of MMM, MMMM, EEE or EEEE as part of the date pattern requires a Locale");
                }
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern);
            } else {
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern).withLocale(this.locale);
            }
            LocalTime result = new LocalTime();
            if (this.dateTimeZone != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(this.dateTimeZone);
            }
            if (this.chronology != null) {
                dateTimeFormatter = dateTimeFormatter.withChronology(this.chronology);
            }
            result = dateTimeFormatter.parseDateTime(object).toLocalTime();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseToLocalTime<T>
    extends AbstractNullAsNullFunction<T, LocalTime> {
        final DateTimeZone dateTimeZone;
        final Chronology chronology;

        public BaseToLocalTime() {
            this.dateTimeZone = null;
            this.chronology = null;
        }

        public BaseToLocalTime(DateTimeZone dateTimeZone) {
            Validate.notNull((Object)dateTimeZone, (String)"dateTimeZone can't be null");
            this.dateTimeZone = dateTimeZone;
            this.chronology = null;
        }

        public BaseToLocalTime(Chronology chronology) {
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.dateTimeZone = null;
            this.chronology = chronology;
        }
    }
}

