/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnJodaToString {
    private FnJodaToString() {
    }

    public static final Function<BaseDateTime, String> fromBaseDateTime() {
        return new BaseDateTimeToStr();
    }

    public static final Function<BaseDateTime, String> fromBaseDateTime(FormatType formatType, String format) {
        return new BaseDateTimeToStr(formatType, format);
    }

    public static final Function<BaseDateTime, String> fromBaseDateTime(FormatType formatType, String format, Locale locale) {
        return new BaseDateTimeToStr(formatType, format, locale);
    }

    public static final Function<BaseDateTime, String> fromBaseDateTime(FormatType formatType, String format, Chronology chronology) {
        return new BaseDateTimeToStr(formatType, format, chronology);
    }

    public static final Function<BaseDateTime, String> fromBaseDateTime(FormatType formatType, String format, String locale) {
        return new BaseDateTimeToStr(formatType, format, locale);
    }

    public static final Function<BaseDateTime, String> fromBaseDateTime(DateTimeFormatter formatter) {
        return new BaseDateTimeToStr(formatter);
    }

    public static final Function<LocalTime, String> fromLocalTime() {
        return new LocalTimeToStr();
    }

    public static final Function<LocalTime, String> fromLocalTime(FormatType formatType, String format) {
        return new LocalTimeToStr(formatType, format);
    }

    public static final Function<LocalTime, String> fromLocalTime(FormatType formatType, String format, Locale locale) {
        return new LocalTimeToStr(formatType, format, locale);
    }

    public static final Function<LocalTime, String> fromLocalTime(FormatType formatType, String format, Chronology chronology) {
        return new LocalTimeToStr(formatType, format, chronology);
    }

    public static final Function<LocalTime, String> fromLocalTime(FormatType formatType, String format, String locale) {
        return new LocalTimeToStr(formatType, format, locale);
    }

    public static final Function<LocalTime, String> fromLocalTime(DateTimeFormatter formatter) {
        return new LocalTimeToStr(formatter);
    }

    public static final Function<LocalDate, String> fromLocalDate() {
        return new LocalDateToStr();
    }

    public static final Function<LocalDate, String> fromLocalDate(FormatType formatType, String format) {
        return new LocalDateToStr(formatType, format);
    }

    public static final Function<LocalDate, String> fromLocalDate(FormatType formatType, String format, Locale locale) {
        return new LocalDateToStr(formatType, format, locale);
    }

    public static final Function<LocalDate, String> fromLocalDate(FormatType formatType, String format, Chronology chronology) {
        return new LocalDateToStr(formatType, format, chronology);
    }

    public static final Function<LocalDate, String> fromLocalDate(FormatType formatType, String format, String locale) {
        return new LocalDateToStr(formatType, format, locale);
    }

    public static final Function<LocalDate, String> fromLocalDate(DateTimeFormatter formatter) {
        return new LocalDateToStr(formatter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LocalDateToStr
    extends AbstractNullAsNullFunction<LocalDate, String> {
        private final ConversionType conversionType;
        private final DateTimeFormatter formatter;
        private final String pattern;
        private final String style;
        private final Locale locale;
        private final Chronology chronology;

        public LocalDateToStr() {
            this.formatter = null;
            this.conversionType = null;
            this.pattern = null;
            this.style = null;
            this.locale = null;
            this.chronology = null;
        }

        public LocalDateToStr(DateTimeFormatter formatter) {
            Validate.notNull((Object)formatter, (String)"formatter can't be null");
            this.formatter = formatter;
            this.conversionType = ConversionType.FROM_FORMATTER;
            this.pattern = null;
            this.style = null;
            this.locale = null;
            this.chronology = null;
        }

        public LocalDateToStr(FormatType formatType, String format) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            this.locale = null;
            this.chronology = null;
            this.formatter = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public LocalDateToStr(FormatType formatType, String format, Chronology chronology) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.chronology = chronology;
            this.locale = null;
            this.formatter = null;
            switch (formatType) {
                case PATTERN: {
                    this.style = null;
                    this.pattern = format;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.style = format;
                    this.pattern = null;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public LocalDateToStr(FormatType formatType, String format, Locale locale) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.locale = locale;
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public LocalDateToStr(FormatType formatType, String format, String locale) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.locale = LocaleUtils.toLocale((String)locale);
            this.chronology = null;
            this.formatter = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public String nullAsNullExecute(LocalDate localDate, ExecCtx ctx) throws Exception {
            if (this.conversionType == null) {
                return localDate.toString();
            }
            switch (this.conversionType) {
                case FROM_FORMATTER: {
                    return localDate.toString(this.formatter);
                }
            }
            DateTimeFormatter f = null;
            f = ConversionType.FROM_PATTERN.equals((Object)this.conversionType) ? DateTimeFormat.forPattern((String)this.pattern) : DateTimeFormat.forStyle((String)this.style);
            if (this.locale != null) {
                f = f.withLocale(this.locale);
            }
            if (this.chronology != null) {
                f = f.withChronology(this.chronology);
            }
            return localDate.toString(f);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ConversionType {
            FROM_PATTERN,
            FROM_STYLE,
            FROM_FORMATTER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LocalTimeToStr
    extends AbstractNullAsNullFunction<LocalTime, String> {
        private final ConversionType conversionType;
        private final DateTimeFormatter formatter;
        private final String pattern;
        private final String style;
        private final Locale locale;
        private final Chronology chronology;

        public LocalTimeToStr() {
            this.conversionType = null;
            this.formatter = null;
            this.pattern = null;
            this.style = null;
            this.locale = null;
            this.chronology = null;
        }

        public LocalTimeToStr(DateTimeFormatter formatter) {
            Validate.notNull((Object)formatter, (String)"formatter can't be null");
            this.conversionType = ConversionType.FROM_FORMATTER;
            this.formatter = formatter;
            this.pattern = null;
            this.style = null;
            this.locale = null;
            this.chronology = null;
        }

        public LocalTimeToStr(FormatType formatType, String format) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            this.locale = null;
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public LocalTimeToStr(FormatType formatType, String format, Chronology chronology) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.chronology = chronology;
            this.locale = null;
            this.formatter = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public LocalTimeToStr(FormatType formatType, String format, Locale locale) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.locale = locale;
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public LocalTimeToStr(FormatType formatType, String format, String locale) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.locale = LocaleUtils.toLocale((String)locale);
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public String nullAsNullExecute(LocalTime localTime, ExecCtx ctx) throws Exception {
            if (this.conversionType == null) {
                return localTime.toString();
            }
            switch (this.conversionType) {
                case FROM_FORMATTER: {
                    return localTime.toString(this.formatter);
                }
            }
            DateTimeFormatter f = null;
            f = ConversionType.FROM_PATTERN.equals((Object)this.conversionType) ? DateTimeFormat.forPattern((String)this.pattern) : DateTimeFormat.forStyle((String)this.style);
            if (this.locale != null) {
                f = f.withLocale(this.locale);
            }
            if (this.chronology != null) {
                f = f.withChronology(this.chronology);
            }
            return localTime.toString(f);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ConversionType {
            FROM_PATTERN,
            FROM_STYLE,
            FROM_FORMATTER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BaseDateTimeToStr
    extends AbstractNullAsNullFunction<BaseDateTime, String> {
        private final ConversionType conversionType;
        private final DateTimeFormatter formatter;
        private final String pattern;
        private final String style;
        private final Locale locale;
        private final Chronology chronology;

        public BaseDateTimeToStr() {
            this.conversionType = null;
            this.formatter = null;
            this.pattern = null;
            this.style = null;
            this.locale = null;
            this.chronology = null;
        }

        public BaseDateTimeToStr(DateTimeFormatter formatter) {
            Validate.notNull((Object)formatter, (String)"formatter can't be null");
            this.conversionType = ConversionType.FROM_FORMATTER;
            this.formatter = formatter;
            this.pattern = null;
            this.style = null;
            this.locale = null;
            this.chronology = null;
        }

        public BaseDateTimeToStr(FormatType formatType, String format) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            this.locale = null;
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public BaseDateTimeToStr(FormatType formatType, String format, Chronology chronology) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.chronology = chronology;
            this.locale = null;
            this.formatter = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public BaseDateTimeToStr(FormatType formatType, String format, Locale locale) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.locale = locale;
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public BaseDateTimeToStr(FormatType formatType, String format, String locale) {
            Validate.notNull((Object)((Object)formatType), (String)"formatType can't be null");
            Validate.notEmpty((String)format, (String)"format can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.locale = LocaleUtils.toLocale((String)locale);
            this.formatter = null;
            this.chronology = null;
            switch (formatType) {
                case PATTERN: {
                    this.pattern = format;
                    this.style = null;
                    this.conversionType = ConversionType.FROM_PATTERN;
                    break;
                }
                default: {
                    this.pattern = null;
                    this.style = format;
                    this.conversionType = ConversionType.FROM_STYLE;
                }
            }
        }

        public String nullAsNullExecute(BaseDateTime baseDateTime, ExecCtx ctx) throws Exception {
            if (this.conversionType == null) {
                return baseDateTime.toString();
            }
            switch (this.conversionType) {
                case FROM_FORMATTER: {
                    return baseDateTime.toString(this.formatter);
                }
            }
            DateTimeFormatter f = null;
            f = ConversionType.FROM_PATTERN.equals((Object)this.conversionType) ? DateTimeFormat.forPattern((String)this.pattern) : DateTimeFormat.forStyle((String)this.style);
            if (this.locale != null) {
                f = f.withLocale(this.locale);
            }
            if (this.chronology != null) {
                f = f.withChronology(this.chronology);
            }
            return baseDateTime.toString(f);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ConversionType {
            FROM_PATTERN,
            FROM_STYLE,
            FROM_FORMATTER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatType {
        PATTERN,
        STYLE;

    }
}

