/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.op4j.exceptions.ExecutionException;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnToDateTime {
    private static final TimestampToDateTime TIMESTAMP_TO_DATE_TIME = new TimestampToDateTime();
    private static final LongToDateTime LONG_TO_DATE_TIME = new LongToDateTime();
    private static final IntegerFieldCollectionToDateTime INTEGER_FIELD_COLLECTION_TO_DATE_TIME = new IntegerFieldCollectionToDateTime();
    private static final IntegerFieldArrayToDateTime INTEGER_FIELD_ARRAY_TO_DATE_TIME = new IntegerFieldArrayToDateTime();
    private static final StringFieldCollectionToDateTime STRING_FIELD_COLLECTION_TO_DATE_TIME = new StringFieldCollectionToDateTime();
    private static final StringFieldArrayToDateTime STRING_FIELD_ARRAY_TO_DATE_TIME = new StringFieldArrayToDateTime();

    private FnToDateTime() {
    }

    public static final Function<String, DateTime> fromString(String pattern) {
        return new StringToDateTime(pattern);
    }

    public static final Function<String, DateTime> fromString(String pattern, DateTimeZone dateTimeZone) {
        return new StringToDateTime(pattern, dateTimeZone);
    }

    public static final Function<String, DateTime> fromString(String pattern, Chronology chronology) {
        return new StringToDateTime(pattern, chronology);
    }

    public static final Function<String, DateTime> fromString(String pattern, Locale locale) {
        return new StringToDateTime(pattern, locale);
    }

    public static final Function<String, DateTime> fromString(String pattern, String locale) {
        return new StringToDateTime(pattern, locale);
    }

    public static final Function<String, DateTime> fromString(String pattern, Locale locale, DateTimeZone dateTimeZone) {
        return new StringToDateTime(pattern, locale, dateTimeZone);
    }

    public static final Function<String, DateTime> fromString(String pattern, String locale, DateTimeZone dateTimeZone) {
        return new StringToDateTime(pattern, locale, dateTimeZone);
    }

    public static final Function<String, DateTime> fromString(String pattern, Locale locale, Chronology chronology) {
        return new StringToDateTime(pattern, locale, chronology);
    }

    public static final Function<String, DateTime> fromString(String pattern, String locale, Chronology chronology) {
        return new StringToDateTime(pattern, locale, chronology);
    }

    public static final <T extends Date> Function<T, DateTime> fromDate() {
        return new DateToDateTime();
    }

    public static final <T extends Date> Function<T, DateTime> fromDate(DateTimeZone dateTimeZone) {
        return new DateToDateTime(dateTimeZone);
    }

    public static final <T extends Date> Function<T, DateTime> fromDate(Chronology chronology) {
        return new DateToDateTime(chronology);
    }

    public static final Function<Timestamp, DateTime> fromTimestamp() {
        return TIMESTAMP_TO_DATE_TIME;
    }

    public static final Function<Timestamp, DateTime> fromTimestamp(DateTimeZone dateTimeZone) {
        return new TimestampToDateTime(dateTimeZone);
    }

    public static final Function<Timestamp, DateTime> fromTimestamp(Chronology chronology) {
        return new TimestampToDateTime(chronology);
    }

    public static final Function<Long, DateTime> fromLong() {
        return LONG_TO_DATE_TIME;
    }

    public static final Function<Long, DateTime> fromLong(DateTimeZone dateTimeZone) {
        return new LongToDateTime(dateTimeZone);
    }

    public static final Function<Long, DateTime> fromLong(Chronology chronology) {
        return new LongToDateTime(chronology);
    }

    public static final Function<Collection<Integer>, DateTime> fromIntegerFieldCollection() {
        return INTEGER_FIELD_COLLECTION_TO_DATE_TIME;
    }

    public static final Function<Collection<Integer>, DateTime> fromIntegerFieldCollection(Chronology chronology) {
        return new IntegerFieldCollectionToDateTime(chronology);
    }

    public static final Function<Integer[], DateTime> fromIntegerFieldArray() {
        return INTEGER_FIELD_ARRAY_TO_DATE_TIME;
    }

    public static final Function<Integer[], DateTime> fromIntegerFieldArray(Chronology chronology) {
        return new IntegerFieldArrayToDateTime(chronology);
    }

    public static final Function<Collection<String>, DateTime> fromStringFieldCollection() {
        return STRING_FIELD_COLLECTION_TO_DATE_TIME;
    }

    public static final Function<Collection<String>, DateTime> fromStringFieldCollection(Chronology chronology) {
        return new StringFieldCollectionToDateTime(chronology);
    }

    public static final Function<String[], DateTime> fromStringFieldArray() {
        return STRING_FIELD_ARRAY_TO_DATE_TIME;
    }

    public static final Function<String[], DateTime> fromStringFieldArray(Chronology chronology) {
        return new StringFieldArrayToDateTime(chronology);
    }

    public static final <T extends Calendar> Function<T, DateTime> fromCalendar() {
        return new CalendarToDateTime();
    }

    public static final <T extends Calendar> Function<T, DateTime> fromCalendar(DateTimeZone dateTimeZone) {
        return new CalendarToDateTime(dateTimeZone);
    }

    public static final <T extends Calendar> Function<T, DateTime> fromCalendar(Chronology chronology) {
        return new CalendarToDateTime(chronology);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarToDateTime<T extends Calendar>
    extends BaseToDateTime<T> {
        public CalendarToDateTime() {
        }

        public CalendarToDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public CalendarToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateTime(object, this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateTime(object, this.chronology);
            }
            return new DateTime(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldArrayToDateTime
    extends BaseToDateTime<String[]> {
        public StringFieldArrayToDateTime() {
        }

        public StringFieldArrayToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(String[] object, ExecCtx ctx) throws Exception {
            String milli;
            if (object.length < 4 || object.length > 7) {
                throw new ExecutionException("String arguments array for DateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.length + " is not valid.");
            }
            String year = object[0];
            String month = object[1];
            String day = object[2];
            String hour = object[3];
            String minute = object.length >= 5 ? object[4] : "0";
            String second = object.length >= 6 ? object[5] : "0";
            String string = milli = object.length >= 7 ? object[6] : "0";
            if (this.chronology != null) {
                return new DateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli), this.chronology);
            }
            return new DateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldCollectionToDateTime
    extends BaseToDateTime<Collection<String>> {
        public StringFieldCollectionToDateTime() {
        }

        public StringFieldCollectionToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(Collection<String> object, ExecCtx ctx) throws Exception {
            String milli;
            if (object.size() < 4 || object.size() > 7) {
                throw new ExecutionException("String arguments list for DateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.size() + " is not valid.");
            }
            Iterator<String> iterator = object.iterator();
            String year = iterator.next();
            String month = iterator.next();
            String day = iterator.next();
            String hour = iterator.next();
            String minute = object.size() >= 5 ? iterator.next() : "0";
            String second = object.size() >= 6 ? iterator.next() : "0";
            String string = milli = object.size() >= 7 ? iterator.next() : "0";
            if (this.chronology != null) {
                return new DateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli), this.chronology);
            }
            return new DateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldArrayToDateTime
    extends BaseToDateTime<Integer[]> {
        public IntegerFieldArrayToDateTime() {
        }

        public IntegerFieldArrayToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(Integer[] object, ExecCtx ctx) throws Exception {
            int milli;
            if (object.length < 4 || object.length > 7) {
                throw new ExecutionException("Integer arguments array for DateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.length + " is not valid.");
            }
            int year = object[0];
            int month = object[1];
            int day = object[2];
            int hour = object[3];
            int minute = object.length >= 5 ? object[4] : 0;
            int second = object.length >= 6 ? object[5] : 0;
            int n = milli = object.length >= 7 ? object[6] : 0;
            if (this.chronology != null) {
                return new DateTime(year, month, day, hour, minute, second, milli, this.chronology);
            }
            return new DateTime(year, month, day, hour, minute, second, milli);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldCollectionToDateTime
    extends BaseToDateTime<Collection<Integer>> {
        public IntegerFieldCollectionToDateTime() {
        }

        public IntegerFieldCollectionToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(Collection<Integer> object, ExecCtx ctx) throws Exception {
            int milli;
            if (object.size() < 4 || object.size() > 7) {
                throw new ExecutionException("Integer arguments list for DateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.size() + " is not valid.");
            }
            Iterator<Integer> iterator = object.iterator();
            int year = iterator.next();
            int month = iterator.next();
            int day = iterator.next();
            int hour = iterator.next();
            int minute = object.size() >= 5 ? iterator.next() : 0;
            int second = object.size() >= 6 ? iterator.next() : 0;
            int n = milli = object.size() >= 7 ? iterator.next() : 0;
            if (this.chronology != null) {
                return new DateTime(year, month, day, hour, minute, second, milli, this.chronology);
            }
            return new DateTime(year, month, day, hour, minute, second, milli);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongToDateTime
    extends BaseToDateTime<Long> {
        public LongToDateTime() {
        }

        public LongToDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public LongToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(Long object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateTime(object.longValue(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateTime(object.longValue(), this.chronology);
            }
            return new DateTime(object.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampToDateTime
    extends BaseToDateTime<Timestamp> {
        public TimestampToDateTime() {
        }

        public TimestampToDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public TimestampToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(Timestamp object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateTime(object.getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateTime(object.getTime(), this.chronology);
            }
            return new DateTime(object.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateToDateTime<T extends Date>
    extends BaseToDateTime<T> {
        public DateToDateTime() {
        }

        public DateToDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public DateToDateTime(Chronology chronology) {
            super(chronology);
        }

        public DateTime nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new DateTime(((Date)object).getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new DateTime(((Date)object).getTime(), this.chronology);
            }
            return new DateTime(((Date)object).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringToDateTime
    extends BaseToDateTime<String> {
        private final String pattern;
        private final Locale locale;

        public StringToDateTime(String pattern) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToDateTime(String pattern, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToDateTime(String pattern, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToDateTime(String pattern, Locale locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToDateTime(String pattern, String locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToDateTime(String pattern, Locale locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToDateTime(String pattern, String locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToDateTime(String pattern, Locale locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToDateTime(String pattern, String locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public DateTime nullAsNullExecute(String object, ExecCtx ctx) throws Exception {
            DateTimeFormatter dateTimeFormatter = null;
            if (this.locale == null) {
                if (StringUtils.contains((String)this.pattern, (String)"MMM") || StringUtils.contains((String)this.pattern, (String)"EEE")) {
                    throw new ExecutionException("The use of MMM, MMMM, EEE or EEEE as part of the date pattern requires a Locale");
                }
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern);
            } else {
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern).withLocale(this.locale);
            }
            DateTime result = new DateTime();
            if (this.dateTimeZone != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(this.dateTimeZone);
            }
            if (this.chronology != null) {
                dateTimeFormatter = dateTimeFormatter.withChronology(this.chronology);
            }
            result = dateTimeFormatter.parseDateTime(object).toDateTime();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseToDateTime<T>
    extends AbstractNullAsNullFunction<T, DateTime> {
        final DateTimeZone dateTimeZone;
        final Chronology chronology;

        public BaseToDateTime() {
            this.dateTimeZone = null;
            this.chronology = null;
        }

        public BaseToDateTime(DateTimeZone dateTimeZone) {
            Validate.notNull((Object)dateTimeZone, (String)"dateTimeZone can't be null");
            this.dateTimeZone = dateTimeZone;
            this.chronology = null;
        }

        public BaseToDateTime(Chronology chronology) {
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.dateTimeZone = null;
            this.chronology = chronology;
        }
    }
}

