/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.op4j.exceptions.ExecutionException;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnLocalDate {
    private static final TimestampToLocalDate TIMESTAMP_TO_LOCAL_DATE = new TimestampToLocalDate();
    private static final LongToLocalDate LONG_TO_LOCAL_DATE = new LongToLocalDate();
    private static final IntegerFieldCollectionToLocalDate INTEGER_FIELD_COLLECTION_TO_LOCAL_DATE = new IntegerFieldCollectionToLocalDate();
    private static final IntegerFieldArrayToLocalDate INTEGER_FIELD_ARRAY_TO_LOCAL_DATE = new IntegerFieldArrayToLocalDate();
    private static final StringFieldCollectionToLocalDate STRING_FIELD_COLLECTION_TO_LOCAL_DATE = new StringFieldCollectionToLocalDate();
    private static final StringFieldArrayToLocalDate STRING_FIELD_ARRAY_TO_LOCAL_DATE = new StringFieldArrayToLocalDate();

    private FnLocalDate() {
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern) {
        return new StringToLocalDate(pattern);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, DateTimeZone dateTimeZone) {
        return new StringToLocalDate(pattern, dateTimeZone);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, Chronology chronology) {
        return new StringToLocalDate(pattern, chronology);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, Locale locale) {
        return new StringToLocalDate(pattern, locale);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, String locale) {
        return new StringToLocalDate(pattern, locale);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, Locale locale, DateTimeZone dateTimeZone) {
        return new StringToLocalDate(pattern, locale, dateTimeZone);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, String locale, DateTimeZone dateTimeZone) {
        return new StringToLocalDate(pattern, locale, dateTimeZone);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, Locale locale, Chronology chronology) {
        return new StringToLocalDate(pattern, locale, chronology);
    }

    public static final Function<String, LocalDate> strToLocalDate(String pattern, String locale, Chronology chronology) {
        return new StringToLocalDate(pattern, locale, chronology);
    }

    public static final <T extends Date> Function<T, LocalDate> dateToLocalDate() {
        return new DateToLocalDate();
    }

    public static final <T extends Date> Function<T, LocalDate> dateToLocalDate(DateTimeZone dateTimeZone) {
        return new DateToLocalDate(dateTimeZone);
    }

    public static final <T extends Date> Function<T, LocalDate> dateToLocalDate(Chronology chronology) {
        return new DateToLocalDate(chronology);
    }

    public static final Function<Timestamp, LocalDate> timestampToLocalDate() {
        return TIMESTAMP_TO_LOCAL_DATE;
    }

    public static final Function<Timestamp, LocalDate> timestampToLocalDate(DateTimeZone dateTimeZone) {
        return new TimestampToLocalDate(dateTimeZone);
    }

    public static final Function<Timestamp, LocalDate> timestampToLocalDate(Chronology chronology) {
        return new TimestampToLocalDate(chronology);
    }

    public static final Function<Long, LocalDate> longToLocalDate() {
        return LONG_TO_LOCAL_DATE;
    }

    public static final Function<Long, LocalDate> longToLocalDate(DateTimeZone dateTimeZone) {
        return new LongToLocalDate(dateTimeZone);
    }

    public static final Function<Long, LocalDate> longToLocalDate(Chronology chronology) {
        return new LongToLocalDate(chronology);
    }

    public static final Function<Collection<Integer>, LocalDate> integerFieldCollectionToLocalDate() {
        return INTEGER_FIELD_COLLECTION_TO_LOCAL_DATE;
    }

    public static final Function<Collection<Integer>, LocalDate> integerFieldCollectionToLocalDate(Chronology chronology) {
        return new IntegerFieldCollectionToLocalDate(chronology);
    }

    public static final Function<Integer[], LocalDate> integerFieldArrayToLocalDate() {
        return INTEGER_FIELD_ARRAY_TO_LOCAL_DATE;
    }

    public static final Function<Integer[], LocalDate> integerFieldArrayToLocalDate(Chronology chronology) {
        return new IntegerFieldArrayToLocalDate(chronology);
    }

    public static final Function<Collection<String>, LocalDate> strFieldCollectionToLocalDate() {
        return STRING_FIELD_COLLECTION_TO_LOCAL_DATE;
    }

    public static final Function<Collection<String>, LocalDate> strFieldCollectionToLocalDate(Chronology chronology) {
        return new StringFieldCollectionToLocalDate(chronology);
    }

    public static final Function<String[], LocalDate> strFieldArrayToLocalDate() {
        return STRING_FIELD_ARRAY_TO_LOCAL_DATE;
    }

    public static final Function<String[], LocalDate> strFieldArrayToLocalDate(Chronology chronology) {
        return new StringFieldArrayToLocalDate(chronology);
    }

    public static final <T extends Calendar> Function<T, LocalDate> calendarToLocalDate() {
        return new CalendarToLocalDate();
    }

    public static final <T extends Calendar> Function<T, LocalDate> calendarToLocalDate(DateTimeZone dateTimeZone) {
        return new CalendarToLocalDate(dateTimeZone);
    }

    public static final <T extends Calendar> Function<T, LocalDate> calendarToLocalDate(Chronology chronology) {
        return new CalendarToLocalDate(chronology);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarToLocalDate<T extends Calendar>
    extends BaseToLocalDate<T> {
        public CalendarToLocalDate() {
        }

        public CalendarToLocalDate(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public CalendarToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalDate(object, this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalDate(object, this.chronology);
            }
            return new LocalDate(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldArrayToLocalDate
    extends BaseToLocalDate<String[]> {
        public StringFieldArrayToLocalDate() {
        }

        public StringFieldArrayToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(String[] object, ExecCtx ctx) throws Exception {
            String day;
            if (object.length < 1 || object.length > 3) {
                throw new ExecutionException("String arguments array for LocalDate conversion should a size between 1 and 3. Size " + object.length + " is not valid.");
            }
            String year = object[0];
            String month = object.length >= 2 ? object[1] : "1";
            String string = day = object.length >= 3 ? object[2] : "1";
            if (this.chronology != null) {
                return new LocalDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), this.chronology);
            }
            return new LocalDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldCollectionToLocalDate
    extends BaseToLocalDate<Collection<String>> {
        public StringFieldCollectionToLocalDate() {
        }

        public StringFieldCollectionToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(Collection<String> object, ExecCtx ctx) throws Exception {
            String day;
            if (object.size() < 1 || object.size() > 3) {
                throw new ExecutionException("String arguments list for LocalDate conversion should hava a size between 1 and 3. Size " + object.size() + " is not valid.");
            }
            Iterator<String> iterator = object.iterator();
            String year = iterator.next();
            String month = object.size() >= 2 ? iterator.next() : "1";
            String string = day = object.size() >= 3 ? iterator.next() : "1";
            if (this.chronology != null) {
                return new LocalDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), this.chronology);
            }
            return new LocalDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldArrayToLocalDate
    extends BaseToLocalDate<Integer[]> {
        public IntegerFieldArrayToLocalDate() {
        }

        public IntegerFieldArrayToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(Integer[] object, ExecCtx ctx) throws Exception {
            int day;
            if (object.length < 1 || object.length > 3) {
                throw new ExecutionException("Integer arguments array for LocalDate conversion should hava a size between 1 and 3. Size " + object.length + " is not valid.");
            }
            int year = object[0];
            int month = object.length >= 2 ? object[1] : 1;
            int n = day = object.length >= 3 ? object[2] : 1;
            if (this.chronology != null) {
                return new LocalDate(year, month, day, this.chronology);
            }
            return new LocalDate(year, month, day);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldCollectionToLocalDate
    extends BaseToLocalDate<Collection<Integer>> {
        public IntegerFieldCollectionToLocalDate() {
        }

        public IntegerFieldCollectionToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(Collection<Integer> object, ExecCtx ctx) throws Exception {
            int day;
            if (object.size() < 1 || object.size() > 3) {
                throw new ExecutionException("Integer arguments list for LocalDate conversion should hava a size between 1 and 3. Size " + object.size() + " is not valid.");
            }
            Iterator<Integer> iterator = object.iterator();
            int year = iterator.next();
            int month = object.size() >= 2 ? iterator.next() : 1;
            int n = day = object.size() >= 3 ? iterator.next() : 1;
            if (this.chronology != null) {
                return new LocalDate(year, month, day, this.chronology);
            }
            return new LocalDate(year, month, day);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongToLocalDate
    extends BaseToLocalDate<Long> {
        public LongToLocalDate() {
        }

        public LongToLocalDate(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public LongToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(Long object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalDate(object.longValue(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalDate(object.longValue(), this.chronology);
            }
            return new LocalDate(object.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampToLocalDate
    extends BaseToLocalDate<Timestamp> {
        public TimestampToLocalDate() {
        }

        public TimestampToLocalDate(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public TimestampToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(Timestamp object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalDate(object.getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalDate(object.getTime(), this.chronology);
            }
            return new LocalDate(object.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateToLocalDate<T extends Date>
    extends BaseToLocalDate<T> {
        public DateToLocalDate() {
        }

        public DateToLocalDate(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public DateToLocalDate(Chronology chronology) {
            super(chronology);
        }

        public LocalDate nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new LocalDate(((Date)object).getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new LocalDate(((Date)object).getTime(), this.chronology);
            }
            return new LocalDate(((Date)object).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringToLocalDate
    extends BaseToLocalDate<String> {
        private final String pattern;
        private final Locale locale;

        public StringToLocalDate(String pattern) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToLocalDate(String pattern, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToLocalDate(String pattern, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToLocalDate(String pattern, Locale locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToLocalDate(String pattern, String locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToLocalDate(String pattern, Locale locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToLocalDate(String pattern, String locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToLocalDate(String pattern, Locale locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToLocalDate(String pattern, String locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public LocalDate nullAsNullExecute(String object, ExecCtx ctx) throws Exception {
            DateTimeFormatter dateTimeFormatter = null;
            if (this.locale == null) {
                if (StringUtils.contains((String)this.pattern, (String)"MMM") || StringUtils.contains((String)this.pattern, (String)"EEE")) {
                    throw new ExecutionException("The use of MMM, MMMM, EEE or EEEE as part of the date pattern requires a Locale");
                }
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern);
            } else {
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern).withLocale(this.locale);
            }
            LocalDate result = new LocalDate();
            if (this.dateTimeZone != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(this.dateTimeZone);
            }
            if (this.chronology != null) {
                dateTimeFormatter = dateTimeFormatter.withChronology(this.chronology);
            }
            result = dateTimeFormatter.parseDateTime(object).toLocalDate();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseToLocalDate<T>
    extends AbstractNullAsNullFunction<T, LocalDate> {
        final DateTimeZone dateTimeZone;
        final Chronology chronology;

        public BaseToLocalDate() {
            this.dateTimeZone = null;
            this.chronology = null;
        }

        public BaseToLocalDate(DateTimeZone dateTimeZone) {
            Validate.notNull((Object)dateTimeZone, (String)"dateTimeZone can't be null");
            this.dateTimeZone = dateTimeZone;
            this.chronology = null;
        }

        public BaseToLocalDate(Chronology chronology) {
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.chronology = chronology;
            this.dateTimeZone = null;
        }
    }
}

