/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.base.BaseDateTime;
import org.op4j.exceptions.ExecutionException;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnPeriod {
    private static final DateFieldCollectionToPeriod DATE_FIELD_COLLECTION_TO_PERIOD = new DateFieldCollectionToPeriod();
    private static final Function<Collection<Timestamp>, Period> TIMESTAMP_FIELD_COLLECTION_TO_PERIOD = new TimestampFieldCollectionToPeriod();
    private static final Function<Timestamp[], Period> TIMESTAMP_FIELD_ARRAY_TO_PERIOD = new TimestampFieldArrayToPeriod();
    private static final Function<Long, Period> LONG_TO_PERIOD = new LongToPeriod();
    private static final Function<Collection<Long>, Period> LONG_FIELD_COLLECTION_TO_PERIOD = new LongFieldCollectionToPeriod();
    private static final Function<Long[], Period> LONG_FIELD_ARRAY_TO_PERIOD = new LongFieldArrayToPeriod();
    private static final Function<Collection<? extends Calendar>, Period> CALENDAR_FIELD_COLLECTION_TO_PERIOD = new CalendarFieldCollectionToPeriod();
    private static final Function<Collection<? extends BaseDateTime>, Period> BASE_DATE_TIME_FIELD_COLLECTION_TO_PERIOD = new BaseDateTimeFieldCollectionToPeriod();
    private static final Function<Collection<Integer>, Period> INTEGER_FIELD_COLLECTION_TO_PERIOD = new IntegerFieldCollectionToPeriod();
    private static final Function<Integer[], Period> INTEGER_FIELD_ARRAY_TO_PERIOD = new IntegerFieldArrayToPeriod();
    private static final Function<Collection<String>, Period> STRING_FIELD_COLLECTION_TO_PERIOD = new StringFieldCollectionToPeriod();
    private static final Function<String[], Period> STRING_FIELD_ARRAY_TO_PERIOD = new StringFieldArrayToPeriod();

    private FnPeriod() {
    }

    public static final Function<Collection<? extends Date>, Period> dateFieldCollectionToPeriod() {
        return DATE_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<? extends Date>, Period> dateFieldCollectionToPeriod(Chronology chronology) {
        return new DateFieldCollectionToPeriod(chronology);
    }

    public static final Function<Collection<? extends Date>, Period> dateFieldCollectionToPeriod(PeriodType periodType) {
        return new DateFieldCollectionToPeriod(periodType);
    }

    public static final Function<Collection<? extends Date>, Period> dateFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
        return new DateFieldCollectionToPeriod(periodType, chronology);
    }

    public static final <T extends Date> Function<T[], Period> dateFieldArrayToPeriod() {
        return new DateFieldArrayToPeriod();
    }

    public static final <T extends Date> Function<T[], Period> dateFieldArrayToPeriod(Chronology chronology) {
        return new DateFieldArrayToPeriod(chronology);
    }

    public static final <T extends Date> Function<T[], Period> dateFieldArrayToPeriod(PeriodType periodType) {
        return new DateFieldArrayToPeriod(periodType);
    }

    public static final <T extends Date> Function<T[], Period> dateFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
        return new DateFieldArrayToPeriod(periodType, chronology);
    }

    public static final Function<Collection<Timestamp>, Period> timestampFieldCollectionToPeriod() {
        return TIMESTAMP_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<Timestamp>, Period> timestampFieldCollectionToPeriod(Chronology chronology) {
        return new TimestampFieldCollectionToPeriod(chronology);
    }

    public static final Function<Collection<Timestamp>, Period> timestampFieldCollectionToPeriod(PeriodType periodType) {
        return new TimestampFieldCollectionToPeriod(periodType);
    }

    public static final Function<Collection<Timestamp>, Period> timestampFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
        return new TimestampFieldCollectionToPeriod(periodType, chronology);
    }

    public static final Function<Timestamp[], Period> timestampFieldArrayToPeriod() {
        return TIMESTAMP_FIELD_ARRAY_TO_PERIOD;
    }

    public static final Function<Timestamp[], Period> timestampFieldArrayToPeriod(Chronology chronology) {
        return new TimestampFieldArrayToPeriod(chronology);
    }

    public static final Function<Timestamp[], Period> timestampFieldArrayToPeriod(PeriodType periodType) {
        return new TimestampFieldArrayToPeriod(periodType);
    }

    public static final Function<Timestamp[], Period> timestampFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
        return new TimestampFieldArrayToPeriod(periodType, chronology);
    }

    public static final Function<Long, Period> longToPeriod() {
        return LONG_TO_PERIOD;
    }

    public static final Function<Long, Period> longToPeriod(Chronology chronology) {
        return new LongToPeriod(chronology);
    }

    public static final Function<Long, Period> longToPeriod(PeriodType periodType) {
        return new LongToPeriod(periodType);
    }

    public static final Function<Long, Period> longToPeriod(PeriodType periodType, Chronology chronology) {
        return new LongToPeriod(periodType, chronology);
    }

    public static final Function<Collection<Long>, Period> longFieldCollectionToPeriod() {
        return LONG_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<Long>, Period> longFieldCollectionToPeriod(Chronology chronology) {
        return new LongFieldCollectionToPeriod(chronology);
    }

    public static final Function<Collection<Long>, Period> longFieldCollectionToPeriod(PeriodType periodType) {
        return new LongFieldCollectionToPeriod(periodType);
    }

    public static final Function<Collection<Long>, Period> longFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
        return new LongFieldCollectionToPeriod(periodType, chronology);
    }

    public static final Function<Long[], Period> longFieldArrayToPeriod() {
        return LONG_FIELD_ARRAY_TO_PERIOD;
    }

    public static final Function<Long[], Period> longFieldArrayToPeriod(Chronology chronology) {
        return new LongFieldArrayToPeriod(chronology);
    }

    public static final Function<Long[], Period> longFieldArrayToPeriod(PeriodType periodType) {
        return new LongFieldArrayToPeriod(periodType);
    }

    public static final Function<Long[], Period> longFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
        return new LongFieldArrayToPeriod(periodType, chronology);
    }

    public static final Function<Collection<? extends Calendar>, Period> calendarFieldCollectionToPeriod() {
        return CALENDAR_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<? extends Calendar>, Period> calendarFieldCollectionToPeriod(Chronology chronology) {
        return new CalendarFieldCollectionToPeriod(chronology);
    }

    public static final Function<Collection<? extends Calendar>, Period> calendarFieldCollectionToPeriod(PeriodType periodType) {
        return new CalendarFieldCollectionToPeriod(periodType);
    }

    public static final Function<Collection<? extends Calendar>, Period> calendarFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
        return new CalendarFieldCollectionToPeriod(periodType, chronology);
    }

    public static final <T extends Calendar> Function<T[], Period> calendarFieldArrayToPeriod() {
        return new CalendarFieldArrayToPeriod();
    }

    public static final <T extends Calendar> Function<T[], Period> calendarFieldArrayToPeriod(Chronology chronology) {
        return new CalendarFieldArrayToPeriod(chronology);
    }

    public static final <T extends Calendar> Function<T[], Period> calendarFieldArrayToPeriod(PeriodType periodType) {
        return new CalendarFieldArrayToPeriod(periodType);
    }

    public static final <T extends Calendar> Function<T[], Period> calendarFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
        return new CalendarFieldArrayToPeriod(periodType, chronology);
    }

    public static final Function<Collection<? extends BaseDateTime>, Period> baseDateTimeFieldCollectionToPeriod() {
        return BASE_DATE_TIME_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<? extends BaseDateTime>, Period> baseDateTimeFieldCollectionToPeriod(Chronology chronology) {
        return new BaseDateTimeFieldCollectionToPeriod(chronology);
    }

    public static final Function<Collection<? extends BaseDateTime>, Period> baseDateTimeFieldCollectionToPeriod(PeriodType periodType) {
        return new BaseDateTimeFieldCollectionToPeriod(periodType);
    }

    public static final Function<Collection<? extends BaseDateTime>, Period> baseDateTimeFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
        return new BaseDateTimeFieldCollectionToPeriod(periodType, chronology);
    }

    public static final <T extends BaseDateTime> Function<T[], Period> baseDateTimeFieldArrayToPeriod() {
        return new BaseDateTimeFieldArrayToPeriod();
    }

    public static final <T extends BaseDateTime> Function<T[], Period> baseDateTimeFieldArrayToPeriod(Chronology chronology) {
        return new BaseDateTimeFieldArrayToPeriod(chronology);
    }

    public static final <T extends BaseDateTime> Function<T[], Period> baseDateTimeFieldArrayToPeriod(PeriodType periodType) {
        return new BaseDateTimeFieldArrayToPeriod(periodType);
    }

    public static final <T extends BaseDateTime> Function<T[], Period> baseDateTimeFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
        return new BaseDateTimeFieldArrayToPeriod(periodType, chronology);
    }

    public static final Function<Collection<Integer>, Period> integerFieldCollectionToPeriod() {
        return INTEGER_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<Integer>, Period> integerFieldCollectionToPeriod(PeriodType periodType) {
        return new IntegerFieldCollectionToPeriod(periodType);
    }

    public static final Function<Integer[], Period> integerFieldArrayToPeriod() {
        return INTEGER_FIELD_ARRAY_TO_PERIOD;
    }

    public static final Function<Integer[], Period> integerFieldArrayToPeriod(PeriodType periodType) {
        return new IntegerFieldArrayToPeriod(periodType);
    }

    public static final Function<Collection<String>, Period> strFieldCollectionToPeriod() {
        return STRING_FIELD_COLLECTION_TO_PERIOD;
    }

    public static final Function<Collection<String>, Period> strFieldCollectionToPeriod(PeriodType periodType) {
        return new StringFieldCollectionToPeriod(periodType);
    }

    public static final Function<String[], Period> strFieldArrayToPeriod() {
        return STRING_FIELD_ARRAY_TO_PERIOD;
    }

    public static final Function<String[], Period> strFieldArrayToPeriod(PeriodType periodType) {
        return new StringFieldArrayToPeriod(periodType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldArrayToPeriod
    extends BaseToPeriod<String[]> {
        public StringFieldArrayToPeriod() {
        }

        public StringFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public Period nullAsNullExecute(String[] strings, ExecCtx ctx) throws Exception {
            if (this.periodType != null) {
                if (strings.length != this.periodType.size()) {
                    throw new ExecutionException("String arguments array for Period conversion with the periodType " + this.periodType.getName() + " should have size " + this.periodType.size() + ". Size " + strings.length + " is not valid.");
                }
                int currentIndex = 0;
                int years = 0;
                int months = 0;
                int weeks = 0;
                int days = 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int millis = 0;
                if (this.periodType.isSupported(DurationFieldType.years())) {
                    years = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.months())) {
                    months = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.weeks())) {
                    weeks = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.days())) {
                    days = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.hours())) {
                    hours = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.minutes())) {
                    minutes = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.seconds())) {
                    seconds = Integer.parseInt(strings[currentIndex++]);
                }
                if (this.periodType.isSupported(DurationFieldType.millis())) {
                    millis = Integer.parseInt(strings[currentIndex++]);
                }
                return new Period(years, months, weeks, days, hours, minutes, seconds, millis, this.periodType);
            }
            if (strings.length != 4 && strings.length != 8) {
                throw new ExecutionException("String arguments array for Period conversion without a PeriodType should of sizes 4 (hours, minutes, seconds, milliseconds), 8 (years, months, weeks, days, hours, minutes, seconds and milliseconds). Size " + strings.length + " is not valid.");
            }
            if (strings.length == 4) {
                return new Period(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), Integer.parseInt(strings[3]));
            }
            return new Period(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), Integer.parseInt(strings[3]), Integer.parseInt(strings[4]), Integer.parseInt(strings[5]), Integer.parseInt(strings[6]), Integer.parseInt(strings[7]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldCollectionToPeriod
    extends BaseToPeriod<Collection<String>> {
        public StringFieldCollectionToPeriod() {
        }

        public StringFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public Period nullAsNullExecute(Collection<String> strings, ExecCtx ctx) throws Exception {
            Iterator<String> iterator = strings.iterator();
            if (this.periodType != null) {
                if (strings.size() != this.periodType.size()) {
                    throw new ExecutionException("String arguments list for Period conversion with the periodType " + this.periodType.getName() + " should have size " + this.periodType.size() + ". Size " + strings.size() + " is not valid.");
                }
                int years = 0;
                int months = 0;
                int weeks = 0;
                int days = 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int millis = 0;
                if (this.periodType.isSupported(DurationFieldType.years())) {
                    years = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.months())) {
                    months = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.weeks())) {
                    weeks = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.days())) {
                    days = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.hours())) {
                    hours = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.minutes())) {
                    minutes = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.seconds())) {
                    seconds = Integer.parseInt(iterator.next());
                }
                if (this.periodType.isSupported(DurationFieldType.millis())) {
                    millis = Integer.parseInt(iterator.next());
                }
                return new Period(years, months, weeks, days, hours, minutes, seconds, millis, this.periodType);
            }
            if (strings.size() != 4 && strings.size() != 8) {
                throw new ExecutionException("String arguments list for Period conversion without a PeriodType should of sizes 4 (hours, minutes, seconds, milliseconds), 8 (years, months, weeks, days, hours, minutes, seconds and milliseconds). Size " + strings.size() + " is not valid.");
            }
            if (strings.size() == 4) {
                return new Period(Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()));
            }
            return new Period(Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()), Integer.parseInt(iterator.next()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldArrayToPeriod
    extends BaseToPeriod<Integer[]> {
        public IntegerFieldArrayToPeriod() {
        }

        public IntegerFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public Period nullAsNullExecute(Integer[] integers, ExecCtx ctx) throws Exception {
            if (this.periodType != null) {
                if (integers.length != this.periodType.size()) {
                    throw new ExecutionException("Integer arguments array for Period conversion with the periodType " + this.periodType.getName() + " should have size " + this.periodType.size() + ". Size " + integers.length + " is not valid.");
                }
                int currentIndex = 0;
                int years = 0;
                int months = 0;
                int weeks = 0;
                int days = 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int millis = 0;
                if (this.periodType.isSupported(DurationFieldType.years())) {
                    years = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.months())) {
                    months = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.weeks())) {
                    weeks = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.days())) {
                    days = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.hours())) {
                    hours = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.minutes())) {
                    minutes = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.seconds())) {
                    seconds = integers[currentIndex++];
                }
                if (this.periodType.isSupported(DurationFieldType.millis())) {
                    millis = integers[currentIndex++];
                }
                return new Period(years, months, weeks, days, hours, minutes, seconds, millis, this.periodType);
            }
            if (integers.length != 4 && integers.length != 8) {
                throw new ExecutionException("Integer arguments array for Period conversion without a PeriodType should of sizes 4 (hours, minutes, seconds, milliseconds), 8 (years, months, weeks, days, hours, minutes, seconds and milliseconds). Size " + integers.length + " is not valid.");
            }
            if (integers.length == 4) {
                return new Period(integers[0].intValue(), integers[1].intValue(), integers[2].intValue(), integers[3].intValue());
            }
            return new Period(integers[0].intValue(), integers[1].intValue(), integers[2].intValue(), integers[3].intValue(), integers[4].intValue(), integers[5].intValue(), integers[6].intValue(), integers[7].intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldCollectionToPeriod
    extends BaseToPeriod<Collection<Integer>> {
        public IntegerFieldCollectionToPeriod() {
        }

        public IntegerFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public Period nullAsNullExecute(Collection<Integer> integers, ExecCtx ctx) throws Exception {
            Iterator<Integer> iterator = integers.iterator();
            if (this.periodType != null) {
                if (integers.size() != this.periodType.size()) {
                    throw new ExecutionException("Integer arguments list for Period conversion with the periodType " + this.periodType.getName() + " should have size " + this.periodType.size() + ". Size " + integers.size() + " is not valid.");
                }
                int years = 0;
                int months = 0;
                int weeks = 0;
                int days = 0;
                int hours = 0;
                int minutes = 0;
                int seconds = 0;
                int millis = 0;
                if (this.periodType.isSupported(DurationFieldType.years())) {
                    years = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.months())) {
                    months = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.weeks())) {
                    weeks = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.days())) {
                    days = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.hours())) {
                    hours = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.minutes())) {
                    minutes = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.seconds())) {
                    seconds = iterator.next();
                }
                if (this.periodType.isSupported(DurationFieldType.millis())) {
                    millis = iterator.next();
                }
                return new Period(years, months, weeks, days, hours, minutes, seconds, millis, this.periodType);
            }
            if (integers.size() != 4 && integers.size() != 8) {
                throw new ExecutionException("Integer arguments list for Period conversion without a PeriodType should of sizes 4 (hours, minutes, seconds, milliseconds), 8 (years, months, weeks, days, hours, minutes, seconds and milliseconds). Size " + integers.size() + " is not valid.");
            }
            if (integers.size() == 4) {
                return new Period(iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue());
            }
            return new Period(iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue(), iterator.next().intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BaseDateTimeFieldArrayToPeriod<T extends BaseDateTime>
    extends BaseToPeriod<T[]> {
        public BaseDateTimeFieldArrayToPeriod() {
        }

        public BaseDateTimeFieldArrayToPeriod(Chronology chronology) {
            super(chronology);
        }

        public BaseDateTimeFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public BaseDateTimeFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(T[] dateTimes, ExecCtx ctx) throws Exception {
            if (dateTimes.length != 2) {
                throw new ExecutionException("DateTime arguments array for Period conversion should have size 2. Size " + dateTimes.length + " is not valid.");
            }
            if (this.periodType != null && this.chronology != null) {
                return new Period(dateTimes[0].getMillis(), dateTimes[1].getMillis(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(dateTimes[0], dateTimes[1], this.periodType);
            }
            if (this.chronology != null) {
                return new Period(dateTimes[0].getMillis(), dateTimes[1].getMillis(), this.chronology);
            }
            return new Period(dateTimes[0], dateTimes[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BaseDateTimeFieldCollectionToPeriod
    extends BaseToPeriod<Collection<? extends BaseDateTime>> {
        public BaseDateTimeFieldCollectionToPeriod() {
        }

        public BaseDateTimeFieldCollectionToPeriod(Chronology chronology) {
            super(chronology);
        }

        public BaseDateTimeFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public BaseDateTimeFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Collection<? extends BaseDateTime> dateTimes, ExecCtx ctx) throws Exception {
            if (dateTimes.size() != 2) {
                throw new ExecutionException("DateTime arguments list for Period conversion should have size 2. Size " + dateTimes.size() + " is not valid.");
            }
            Iterator<? extends BaseDateTime> iterator = dateTimes.iterator();
            if (this.periodType != null && this.chronology != null) {
                return new Period(iterator.next().getMillis(), iterator.next().getMillis(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period((ReadableInstant)iterator.next(), (ReadableInstant)iterator.next(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(iterator.next().getMillis(), iterator.next().getMillis(), this.chronology);
            }
            return new Period((ReadableInstant)iterator.next(), (ReadableInstant)iterator.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarFieldArrayToPeriod<T extends Calendar>
    extends BaseToPeriod<T[]> {
        public CalendarFieldArrayToPeriod() {
        }

        public CalendarFieldArrayToPeriod(Chronology chronology) {
            super(chronology);
        }

        public CalendarFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public CalendarFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(T[] calendars, ExecCtx ctx) throws Exception {
            if (calendars.length != 2) {
                throw new ExecutionException("Calendar arguments array for Period conversion should have size 2. Size " + calendars.length + " is not valid.");
            }
            if (this.periodType != null && this.chronology != null) {
                return new Period(((Calendar)calendars[0]).getTimeInMillis(), ((Calendar)calendars[1]).getTimeInMillis(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(((Calendar)calendars[0]).getTimeInMillis(), ((Calendar)calendars[1]).getTimeInMillis(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(((Calendar)calendars[0]).getTimeInMillis(), ((Calendar)calendars[1]).getTimeInMillis(), this.chronology);
            }
            return new Period(((Calendar)calendars[0]).getTimeInMillis(), ((Calendar)calendars[1]).getTimeInMillis());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarFieldCollectionToPeriod
    extends BaseToPeriod<Collection<? extends Calendar>> {
        public CalendarFieldCollectionToPeriod() {
        }

        public CalendarFieldCollectionToPeriod(Chronology chronology) {
            super(chronology);
        }

        public CalendarFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public CalendarFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Collection<? extends Calendar> calendars, ExecCtx ctx) throws Exception {
            if (calendars.size() != 2) {
                throw new ExecutionException("Calendar arguments list for Period conversion should have size 2. Size " + calendars.size() + " is not valid.");
            }
            Iterator<? extends Calendar> iterator = calendars.iterator();
            if (this.periodType != null && this.chronology != null) {
                return new Period(iterator.next().getTimeInMillis(), iterator.next().getTimeInMillis(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(iterator.next().getTimeInMillis(), iterator.next().getTimeInMillis(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(iterator.next().getTimeInMillis(), iterator.next().getTimeInMillis(), this.chronology);
            }
            return new Period(iterator.next().getTimeInMillis(), iterator.next().getTimeInMillis());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongFieldArrayToPeriod
    extends BaseToPeriod<Long[]> {
        public LongFieldArrayToPeriod() {
        }

        public LongFieldArrayToPeriod(Chronology chronology) {
            super(chronology);
        }

        public LongFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public LongFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Long[] longs, ExecCtx ctx) throws Exception {
            if (longs.length != 2) {
                throw new ExecutionException("Long arguments array for Period conversion should have size 2. Size " + longs.length + " is not valid.");
            }
            if (this.periodType != null && this.chronology != null) {
                return new Period(longs[0].longValue(), longs[1].longValue(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(longs[0].longValue(), longs[1].longValue(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(longs[0].longValue(), longs[1].longValue(), this.chronology);
            }
            return new Period(longs[0].longValue(), longs[1].longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongFieldCollectionToPeriod
    extends BaseToPeriod<Collection<Long>> {
        public LongFieldCollectionToPeriod() {
        }

        public LongFieldCollectionToPeriod(Chronology chronology) {
            super(chronology);
        }

        public LongFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public LongFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Collection<Long> longs, ExecCtx ctx) throws Exception {
            if (longs.size() != 2) {
                throw new ExecutionException("Long arguments list for Period conversion should have size 2. Size " + longs.size() + " is not valid.");
            }
            Iterator<Long> iterator = longs.iterator();
            if (this.periodType != null && this.chronology != null) {
                return new Period(iterator.next().longValue(), iterator.next().longValue(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(iterator.next().longValue(), iterator.next().longValue(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(iterator.next().longValue(), iterator.next().longValue(), this.chronology);
            }
            return new Period(iterator.next().longValue(), iterator.next().longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongToPeriod
    extends BaseToPeriod<Long> {
        public LongToPeriod() {
        }

        public LongToPeriod(Chronology chronology) {
            super(chronology);
        }

        public LongToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public LongToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Long theLong, ExecCtx ctx) throws Exception {
            if (this.periodType != null && this.chronology != null) {
                return new Period(theLong.longValue(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(theLong.longValue(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(theLong.longValue(), this.chronology);
            }
            return new Period(theLong.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampFieldArrayToPeriod
    extends BaseToPeriod<Timestamp[]> {
        public TimestampFieldArrayToPeriod() {
        }

        public TimestampFieldArrayToPeriod(Chronology chronology) {
            super(chronology);
        }

        public TimestampFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public TimestampFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Timestamp[] timestamps, ExecCtx ctx) throws Exception {
            if (timestamps.length != 2) {
                throw new ExecutionException("Timestamp arguments array for Period conversion should of sizes 2. Size " + timestamps.length + " is not valid.");
            }
            if (this.periodType != null && this.chronology != null) {
                return new Period(timestamps[0].getTime(), timestamps[1].getTime(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(timestamps[0].getTime(), timestamps[1].getTime(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(timestamps[0].getTime(), timestamps[1].getTime(), this.chronology);
            }
            return new Period(timestamps[0].getTime(), timestamps[1].getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampFieldCollectionToPeriod
    extends BaseToPeriod<Collection<Timestamp>> {
        public TimestampFieldCollectionToPeriod() {
        }

        public TimestampFieldCollectionToPeriod(Chronology chronology) {
            super(chronology);
        }

        public TimestampFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public TimestampFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Collection<Timestamp> timestamps, ExecCtx ctx) throws Exception {
            if (timestamps.size() != 2) {
                throw new ExecutionException("Timestamp arguments list for Period conversion should of sizes 2. Size " + timestamps.size() + " is not valid.");
            }
            Iterator<Timestamp> iterator = timestamps.iterator();
            if (this.periodType != null && this.chronology != null) {
                return new Period(iterator.next().getTime(), iterator.next().getTime(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(iterator.next().getTime(), iterator.next().getTime(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(iterator.next().getTime(), iterator.next().getTime(), this.chronology);
            }
            return new Period(iterator.next().getTime(), iterator.next().getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateFieldArrayToPeriod<T extends Date>
    extends BaseToPeriod<T[]> {
        public DateFieldArrayToPeriod() {
        }

        public DateFieldArrayToPeriod(Chronology chronology) {
            super(chronology);
        }

        public DateFieldArrayToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public DateFieldArrayToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(T[] dates, ExecCtx ctx) throws Exception {
            if (dates.length != 2) {
                throw new ExecutionException("Date arguments array for Period conversion should have size 2. Size " + dates.length + " is not valid.");
            }
            if (this.periodType != null && this.chronology != null) {
                return new Period(((Date)dates[0]).getTime(), ((Date)dates[1]).getTime(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(((Date)dates[0]).getTime(), ((Date)dates[1]).getTime(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(((Date)dates[0]).getTime(), ((Date)dates[1]).getTime(), this.chronology);
            }
            return new Period(((Date)dates[0]).getTime(), ((Date)dates[1]).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateFieldCollectionToPeriod
    extends BaseToPeriod<Collection<? extends Date>> {
        public DateFieldCollectionToPeriod() {
        }

        public DateFieldCollectionToPeriod(Chronology chronology) {
            super(chronology);
        }

        public DateFieldCollectionToPeriod(PeriodType periodType) {
            super(periodType);
        }

        public DateFieldCollectionToPeriod(PeriodType periodType, Chronology chronology) {
            super(periodType, chronology);
        }

        public Period nullAsNullExecute(Collection<? extends Date> dates, ExecCtx ctx) throws Exception {
            if (dates.size() != 2) {
                throw new ExecutionException("Date arguments list for Period conversion should have size 2. Size " + dates.size() + " is not valid.");
            }
            Iterator<? extends Date> iterator = dates.iterator();
            if (this.periodType != null && this.chronology != null) {
                return new Period(iterator.next().getTime(), iterator.next().getTime(), this.periodType, this.chronology);
            }
            if (this.periodType != null) {
                return new Period(iterator.next().getTime(), iterator.next().getTime(), this.periodType);
            }
            if (this.chronology != null) {
                return new Period(iterator.next().getTime(), iterator.next().getTime(), this.chronology);
            }
            return new Period(iterator.next().getTime(), iterator.next().getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseToPeriod<T>
    extends AbstractNullAsNullFunction<T, Period> {
        final Chronology chronology;
        final PeriodType periodType;

        public BaseToPeriod() {
            this.chronology = null;
            this.periodType = null;
        }

        public BaseToPeriod(Chronology chronology) {
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.chronology = chronology;
            this.periodType = null;
        }

        public BaseToPeriod(PeriodType periodType) {
            Validate.notNull((Object)periodType, (String)"periodType can't be null");
            this.chronology = null;
            this.periodType = periodType;
        }

        public BaseToPeriod(PeriodType periodType, Chronology chronology) {
            Validate.notNull((Object)periodType, (String)"periodType can't be null");
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.chronology = chronology;
            this.periodType = periodType;
        }
    }
}

