/*
 * Decompiled with CFR 0.152.
 */
package org.op4j.jodatime.functions;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.op4j.exceptions.ExecutionException;
import org.op4j.functions.AbstractNullAsNullFunction;
import org.op4j.functions.ExecCtx;
import org.op4j.functions.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnMutableDateTime {
    private static final TimestampToMutableDateTime TIMESTAMP_TO_MUTABLE_DATE_TIME = new TimestampToMutableDateTime();
    private static final LongToMutableDateTime LONG_TO_MUTABLE_DATE_TIME = new LongToMutableDateTime();
    private static final IntegerFieldCollectionToMutableDateTime INTEGER_FIELD_COLLECTION_TO_MUTABLE_DATE_TIME = new IntegerFieldCollectionToMutableDateTime();
    private static final IntegerFieldArrayToMutableDateTime INTEGER_FIELD_ARRAY_TO_MUTABLE_DATE_TIME = new IntegerFieldArrayToMutableDateTime();
    private static final StringFieldCollectionToMutableDateTime STRING_FIELD_COLLECTION_TO_MUTABLE_DATE_TIME = new StringFieldCollectionToMutableDateTime();
    private static final StringFieldArrayToMutableDateTime STRING_FIELD_ARRAY_TO_MUTABLE_DATE_TIME = new StringFieldArrayToMutableDateTime();

    private FnMutableDateTime() {
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern) {
        return new StringToMutableDateTime(pattern);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, DateTimeZone dateTimeZone) {
        return new StringToMutableDateTime(pattern, dateTimeZone);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, Chronology chronology) {
        return new StringToMutableDateTime(pattern, chronology);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, Locale locale) {
        return new StringToMutableDateTime(pattern, locale);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, String locale) {
        return new StringToMutableDateTime(pattern, locale);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, Locale locale, DateTimeZone dateTimeZone) {
        return new StringToMutableDateTime(pattern, locale, dateTimeZone);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, String locale, DateTimeZone dateTimeZone) {
        return new StringToMutableDateTime(pattern, locale, dateTimeZone);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, Locale locale, Chronology chronology) {
        return new StringToMutableDateTime(pattern, locale, chronology);
    }

    public static final Function<String, MutableDateTime> strToMutableDateTime(String pattern, String locale, Chronology chronology) {
        return new StringToMutableDateTime(pattern, locale, chronology);
    }

    public static final <T extends Date> Function<T, MutableDateTime> dateToMutableDateTime() {
        return new DateToMutableDateTime();
    }

    public static final <T extends Date> Function<T, MutableDateTime> dateToMutableDateTime(DateTimeZone dateTimeZone) {
        return new DateToMutableDateTime(dateTimeZone);
    }

    public static final <T extends Date> Function<T, MutableDateTime> dateToMutableDateTime(Chronology chronology) {
        return new DateToMutableDateTime(chronology);
    }

    public static final Function<Timestamp, MutableDateTime> timestampToMutableDateTime() {
        return TIMESTAMP_TO_MUTABLE_DATE_TIME;
    }

    public static final Function<Timestamp, MutableDateTime> timestampToMutableDateTime(DateTimeZone dateTimeZone) {
        return new TimestampToMutableDateTime(dateTimeZone);
    }

    public static final Function<Timestamp, MutableDateTime> timestampToMutableDateTime(Chronology chronology) {
        return new TimestampToMutableDateTime(chronology);
    }

    public static final Function<Long, MutableDateTime> longToMutableDateTime() {
        return LONG_TO_MUTABLE_DATE_TIME;
    }

    public static final Function<Long, MutableDateTime> longToMutableDateTime(DateTimeZone dateTimeZone) {
        return new LongToMutableDateTime(dateTimeZone);
    }

    public static final Function<Long, MutableDateTime> longToMutableDateTime(Chronology chronology) {
        return new LongToMutableDateTime(chronology);
    }

    public static final Function<Collection<Integer>, MutableDateTime> integerFieldCollectionToMutableDateTime() {
        return INTEGER_FIELD_COLLECTION_TO_MUTABLE_DATE_TIME;
    }

    public static final Function<Collection<Integer>, MutableDateTime> integerFieldCollectionToMutableDateTime(Chronology chronology) {
        return new IntegerFieldCollectionToMutableDateTime(chronology);
    }

    public static final Function<Integer[], MutableDateTime> integerFieldArrayToMutableDateTime() {
        return INTEGER_FIELD_ARRAY_TO_MUTABLE_DATE_TIME;
    }

    public static final Function<Integer[], MutableDateTime> integerFieldArrayToMutableDateTime(Chronology chronology) {
        return new IntegerFieldArrayToMutableDateTime(chronology);
    }

    public static final Function<Collection<String>, MutableDateTime> strFieldCollectionToMutableDateTime() {
        return STRING_FIELD_COLLECTION_TO_MUTABLE_DATE_TIME;
    }

    public static final Function<Collection<String>, MutableDateTime> strFieldCollectionToMutableDateTime(Chronology chronology) {
        return new StringFieldCollectionToMutableDateTime(chronology);
    }

    public static final Function<String[], MutableDateTime> strFieldArrayToMutableDateTime() {
        return STRING_FIELD_ARRAY_TO_MUTABLE_DATE_TIME;
    }

    public static final Function<String[], MutableDateTime> strFieldArrayToMutableDateTime(Chronology chronology) {
        return new StringFieldArrayToMutableDateTime(chronology);
    }

    public static final <T extends Calendar> Function<T, MutableDateTime> calendarToMutableDateTime() {
        return new CalendarToMutableDateTime();
    }

    public static final <T extends Calendar> Function<T, MutableDateTime> calendarToMutableDateTime(DateTimeZone dateTimeZone) {
        return new CalendarToMutableDateTime(dateTimeZone);
    }

    public static final <T extends Calendar> Function<T, MutableDateTime> calendarToMutableDateTime(Chronology chronology) {
        return new CalendarToMutableDateTime(chronology);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CalendarToMutableDateTime<T extends Calendar>
    extends BaseToMutableDateTime<T> {
        public CalendarToMutableDateTime() {
        }

        public CalendarToMutableDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public CalendarToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new MutableDateTime(object, this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new MutableDateTime(object, this.chronology);
            }
            return new MutableDateTime(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldArrayToMutableDateTime
    extends BaseToMutableDateTime<String[]> {
        public StringFieldArrayToMutableDateTime() {
        }

        public StringFieldArrayToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(String[] object, ExecCtx ctx) throws Exception {
            String milli;
            if (object.length < 4 || object.length > 7) {
                throw new ExecutionException("String arguments array for MutableDateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.length + " is not valid.");
            }
            String year = object[0];
            String month = object[1];
            String day = object[2];
            String hour = object[3];
            String minute = object.length >= 5 ? object[4] : "0";
            String second = object.length >= 6 ? object[5] : "0";
            String string = milli = object.length >= 7 ? object[6] : "0";
            if (this.chronology != null) {
                return new MutableDateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli), this.chronology);
            }
            return new MutableDateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringFieldCollectionToMutableDateTime
    extends BaseToMutableDateTime<Collection<String>> {
        public StringFieldCollectionToMutableDateTime() {
        }

        public StringFieldCollectionToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(Collection<String> object, ExecCtx ctx) throws Exception {
            String milli;
            if (object.size() < 4 || object.size() > 7) {
                throw new ExecutionException("String arguments list for MutableDateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.size() + " is not valid.");
            }
            Iterator<String> iterator = object.iterator();
            String year = iterator.next();
            String month = iterator.next();
            String day = iterator.next();
            String hour = iterator.next();
            String minute = object.size() >= 5 ? iterator.next() : "0";
            String second = object.size() >= 6 ? iterator.next() : "0";
            String string = milli = object.size() >= 7 ? iterator.next() : "0";
            if (this.chronology != null) {
                return new MutableDateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli), this.chronology);
            }
            return new MutableDateTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(milli));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldArrayToMutableDateTime
    extends BaseToMutableDateTime<Integer[]> {
        public IntegerFieldArrayToMutableDateTime() {
        }

        public IntegerFieldArrayToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(Integer[] object, ExecCtx ctx) throws Exception {
            int milli;
            if (object.length < 4 || object.length > 7) {
                throw new ExecutionException("Integer arguments array for MutableDateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.length + " is not valid.");
            }
            int year = object[0];
            int month = object[1];
            int day = object[2];
            int hour = object[3];
            int minute = object.length >= 5 ? object[4] : 0;
            int second = object.length >= 6 ? object[5] : 0;
            int n = milli = object.length >= 7 ? object[6] : 0;
            if (this.chronology != null) {
                return new MutableDateTime(year, month, day, hour, minute, second, milli, this.chronology);
            }
            return new MutableDateTime(year, month, day, hour, minute, second, milli);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerFieldCollectionToMutableDateTime
    extends BaseToMutableDateTime<Collection<Integer>> {
        public IntegerFieldCollectionToMutableDateTime() {
        }

        public IntegerFieldCollectionToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(Collection<Integer> object, ExecCtx ctx) throws Exception {
            int milli;
            if (object.size() < 4 || object.size() > 7) {
                throw new ExecutionException("Integer arguments list for MutableDateTime conversion should of size between 4 and 7 (year, month, day, hour, minute, second, millisecond). Size " + object.size() + " is not valid.");
            }
            Iterator<Integer> iterator = object.iterator();
            int year = iterator.next();
            int month = iterator.next();
            int day = iterator.next();
            int hour = iterator.next();
            int minute = object.size() >= 5 ? iterator.next() : 0;
            int second = object.size() >= 6 ? iterator.next() : 0;
            int n = milli = object.size() >= 7 ? iterator.next() : 0;
            if (this.chronology != null) {
                return new MutableDateTime(year, month, day, hour, minute, second, milli, this.chronology);
            }
            return new MutableDateTime(year, month, day, hour, minute, second, milli);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LongToMutableDateTime
    extends BaseToMutableDateTime<Long> {
        public LongToMutableDateTime() {
        }

        public LongToMutableDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public LongToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(Long object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new MutableDateTime(object.longValue(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new MutableDateTime(object.longValue(), this.chronology);
            }
            return new MutableDateTime(object.longValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimestampToMutableDateTime
    extends BaseToMutableDateTime<Timestamp> {
        public TimestampToMutableDateTime() {
        }

        public TimestampToMutableDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public TimestampToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(Timestamp object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new MutableDateTime(object.getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new MutableDateTime(object.getTime(), this.chronology);
            }
            return new MutableDateTime(object.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DateToMutableDateTime<T extends Date>
    extends BaseToMutableDateTime<T> {
        public DateToMutableDateTime() {
        }

        public DateToMutableDateTime(DateTimeZone dateTimeZone) {
            super(dateTimeZone);
        }

        public DateToMutableDateTime(Chronology chronology) {
            super(chronology);
        }

        public MutableDateTime nullAsNullExecute(T object, ExecCtx ctx) throws Exception {
            if (this.dateTimeZone != null) {
                return new MutableDateTime(((Date)object).getTime(), this.dateTimeZone);
            }
            if (this.chronology != null) {
                return new MutableDateTime(((Date)object).getTime(), this.chronology);
            }
            return new MutableDateTime(((Date)object).getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringToMutableDateTime
    extends BaseToMutableDateTime<String> {
        private final String pattern;
        private final Locale locale;

        public StringToMutableDateTime(String pattern) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToMutableDateTime(String pattern, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToMutableDateTime(String pattern, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = null;
        }

        public StringToMutableDateTime(String pattern, Locale locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToMutableDateTime(String pattern, String locale) {
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToMutableDateTime(String pattern, Locale locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToMutableDateTime(String pattern, String locale, DateTimeZone dateTimeZone) {
            super(dateTimeZone);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public StringToMutableDateTime(String pattern, Locale locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notNull((Object)locale, (String)"locale can't be null");
            this.pattern = pattern;
            this.locale = locale;
        }

        public StringToMutableDateTime(String pattern, String locale, Chronology chronology) {
            super(chronology);
            Validate.notEmpty((String)pattern, (String)"pattern can't be neither empty nor null");
            Validate.notEmpty((String)locale, (String)"locale can't be neither empty nor null");
            this.pattern = pattern;
            this.locale = LocaleUtils.toLocale((String)locale);
        }

        public MutableDateTime nullAsNullExecute(String object, ExecCtx ctx) throws Exception {
            DateTimeFormatter dateTimeFormatter = null;
            if (this.locale == null) {
                if (StringUtils.contains((String)this.pattern, (String)"MMM") || StringUtils.contains((String)this.pattern, (String)"EEE")) {
                    throw new ExecutionException("The use of MMM, MMMM, EEE or EEEE as part of the date pattern requires a Locale");
                }
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern);
            } else {
                dateTimeFormatter = DateTimeFormat.forPattern((String)this.pattern).withLocale(this.locale);
            }
            MutableDateTime result = new MutableDateTime();
            if (this.dateTimeZone != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(this.dateTimeZone);
            }
            if (this.chronology != null) {
                dateTimeFormatter = dateTimeFormatter.withChronology(this.chronology);
            }
            result = dateTimeFormatter.parseMutableDateTime(object);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseToMutableDateTime<T>
    extends AbstractNullAsNullFunction<T, MutableDateTime> {
        final DateTimeZone dateTimeZone;
        final Chronology chronology;

        public BaseToMutableDateTime() {
            this.dateTimeZone = null;
            this.chronology = null;
        }

        public BaseToMutableDateTime(DateTimeZone dateTimeZone) {
            Validate.notNull((Object)dateTimeZone, (String)"dateTimeZone can't be null");
            this.dateTimeZone = dateTimeZone;
            this.chronology = null;
        }

        public BaseToMutableDateTime(Chronology chronology) {
            Validate.notNull((Object)chronology, (String)"chronology can't be null");
            this.dateTimeZone = null;
            this.chronology = chronology;
        }
    }
}

