/*
 * Decompiled with CFR 0.152.
 */
package org.openani.anitorrent.binding;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.openani.anitorrent.binding.anitorrentJNI;

public class CharVector
extends AbstractList<Character>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CharVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CharVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(CharVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                anitorrentJNI.delete_CharVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public CharVector(char[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (char element : initialElements) {
            this.add(Character.valueOf(element));
        }
    }

    public CharVector(Iterable<Character> initialElements) {
        this();
        for (char element : initialElements) {
            this.add(Character.valueOf(element));
        }
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.doGet(index));
    }

    @Override
    public Character set(int index, Character e) {
        return Character.valueOf(this.doSet(index, e.charValue()));
    }

    @Override
    public boolean add(Character e) {
        ++this.modCount;
        this.doAdd(e.charValue());
        return true;
    }

    @Override
    public void add(int index, Character e) {
        ++this.modCount;
        this.doAdd(index, e.charValue());
    }

    @Override
    public Character remove(int index) {
        ++this.modCount;
        return Character.valueOf(this.doRemove(index));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public CharVector() {
        this(anitorrentJNI.new_CharVector__SWIG_0(), true);
    }

    public CharVector(CharVector other) {
        this(anitorrentJNI.new_CharVector__SWIG_1(CharVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return anitorrentJNI.CharVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        anitorrentJNI.CharVector_clear(this.swigCPtr, this);
    }

    public CharVector(int count, char value) {
        this(anitorrentJNI.new_CharVector__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return anitorrentJNI.CharVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        anitorrentJNI.CharVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return anitorrentJNI.CharVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(char x) {
        anitorrentJNI.CharVector_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, char x) {
        anitorrentJNI.CharVector_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private char doRemove(int index) {
        return anitorrentJNI.CharVector_doRemove(this.swigCPtr, this, index);
    }

    private char doGet(int index) {
        return anitorrentJNI.CharVector_doGet(this.swigCPtr, this, index);
    }

    private char doSet(int index, char val) {
        return anitorrentJNI.CharVector_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        anitorrentJNI.CharVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

