/*
 * Copyright (C) 2024 OpenAni and contributors.
 *
 * Use of this source code is governed by the GNU GENERAL PUBLIC LICENSE version 3 license, which can be found at the following link.
 *
 * https://github.com/open-ani/mediamp/blob/main/LICENSE
 */

package org.openani.mediamp.metadata

import org.openani.mediamp.InternalMediampApi

public class VideoProperties @InternalMediampApi public constructor(
    public val title: String?,
    public val durationMillis: Long,
) {
    public fun copy(
        title: String? = this.title,
        durationMillis: Long = this.durationMillis,
    ): VideoProperties {
        @OptIn(InternalMediampApi::class)
        return VideoProperties(
            title = title,
            durationMillis = durationMillis,
        )
    }
}
