/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.mpv;

import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openani.mediamp.mpv.EventListener;
import org.openani.mediamp.mpv.LibraryLoader;
import org.openani.mediamp.mpv.MPVFormat;
import org.openani.mediamp.mpv.MPVHandleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 12\u00060\u0001j\u0002`\u0002:\u00011B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u001f\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017J\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001dJ\u0016\u0010$\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0011J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020!J\u0016\u0010&\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017J \u0010'\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\bJ\u0006\u0010.\u001a\u00020\u0011J\u0006\u0010/\u001a\u00020\u0011J\b\u00100\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/openani/mediamp/mpv/MPVHandle;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "ptr", "", "<init>", "(J)V", "context", "", "(Ljava/lang/Object;)V", "cleanable", "Ljava/lang/ref/Cleaner$Cleanable;", "kotlin.jvm.PlatformType", "Ljava/lang/ref/Cleaner$Cleanable;", "eventListener", "Lorg/openani/mediamp/mpv/EventListener;", "initialize", "", "setEventListener", "", "listener", "command", "", "", "([Ljava/lang/String;)Z", "option", "key", "value", "getPropertyInt", "", "name", "getPropertyBoolean", "getPropertyDouble", "", "getPropertyString", "setPropertyInt", "setPropertyBoolean", "setPropertyDouble", "setPropertyString", "observeProperty", "format", "Lorg/openani/mediamp/mpv/MPVFormat;", "replyData", "unobserveProperty", "attachAndroidSurface", "surface", "detachAndroidSurface", "destroy", "close", "Companion", "mediamp-mpv"})
public final class MPVHandle
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long ptr;
    private final Cleaner.Cleanable cleanable;
    @Nullable
    private EventListener eventListener;
    private static final Cleaner cleaner;

    private MPVHandle(long ptr) {
        this.ptr = ptr;
        this.cleanable = cleaner.register(this, new Companion.ReferenceHolder(this.ptr));
    }

    public MPVHandle(@NotNull Object context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(MPVHandleKt.access$nMake(context));
        if (this.ptr == 0L) {
            throw new IllegalStateException("Failed to create native mpv handle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize() {
        try {
            boolean bl = MPVHandleKt.access$nInitialize(this.ptr);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public final void setEventListener(@NotNull EventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventListener = listener;
        MPVHandleKt.access$nSetEventListener(this.ptr, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean command(String ... command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        try {
            boolean bl = MPVHandleKt.access$nCommand(this.ptr, command);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean option(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            boolean bl = MPVHandleKt.access$nOption(this.ptr, key, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPropertyInt(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            int n = MPVHandleKt.access$nGetPropertyInt(this.ptr, name);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getPropertyBoolean(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            boolean bl = MPVHandleKt.access$nGetPropertyBoolean(this.ptr, name);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getPropertyDouble(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            double d = MPVHandleKt.access$nGetPropertyDouble(this.ptr, name);
            return d;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getPropertyString(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            String string = MPVHandleKt.access$nGetPropertyString(this.ptr, name);
            return string;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setPropertyInt(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            boolean bl = MPVHandleKt.access$nSetPropertyInt(this.ptr, name, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setPropertyBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            boolean bl = MPVHandleKt.access$nSetPropertyBoolean(this.ptr, name, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setPropertyDouble(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            boolean bl = MPVHandleKt.access$nSetPropertyDouble(this.ptr, name, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setPropertyString(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            boolean bl = MPVHandleKt.access$nSetPropertyString(this.ptr, name, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean observeProperty(@NotNull String name, @NotNull MPVFormat format, long replyData) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        try {
            boolean bl = MPVHandleKt.access$nObserveProperty(this.ptr, name, format.ordinal(), replyData);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public static /* synthetic */ boolean observeProperty$default(MPVHandle mPVHandle, String string, MPVFormat mPVFormat, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        return mPVHandle.observeProperty(string, mPVFormat, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unobserveProperty(long replyData) {
        try {
            boolean bl = MPVHandleKt.access$nUnobserveProperty(this.ptr, replyData);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean attachAndroidSurface(@NotNull Object surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        try {
            boolean bl = MPVHandleKt.access$nAttachAndroidSurface(this.ptr, surface);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean detachAndroidSurface() {
        try {
            boolean bl = MPVHandleKt.access$nDetachAndroidSurface(this.ptr);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean destroy() {
        try {
            boolean bl = MPVHandleKt.access$nDestroy(this.ptr);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void close() {
        this.cleanable.clean();
    }

    static {
        LibraryLoader.INSTANCE.loadLibraries();
        cleaner = Cleaner.create();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/openani/mediamp/mpv/MPVHandle$Companion;", "", "<init>", "()V", "cleaner", "Ljava/lang/ref/Cleaner;", "kotlin.jvm.PlatformType", "Ljava/lang/ref/Cleaner;", "ReferenceHolder", "mediamp-mpv"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/openani/mediamp/mpv/MPVHandle$Companion$ReferenceHolder;", "Ljava/lang/Runnable;", "nativePtr", "", "<init>", "(J)V", "run", "", "mediamp-mpv"})
        private static final class ReferenceHolder
        implements Runnable {
            private final long nativePtr;

            public ReferenceHolder(long nativePtr) {
                this.nativePtr = nativePtr;
            }

            @Override
            public void run() {
                MPVHandleKt.access$nFinalize(this.nativePtr);
            }
        }
    }
}

