/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.mpv;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openani.mediamp.AbstractMediampPlayer;
import org.openani.mediamp.InternalMediampApi;
import org.openani.mediamp.PlaybackState;
import org.openani.mediamp.features.PlayerFeatures;
import org.openani.mediamp.features.PlayerFeaturesBuilder;
import org.openani.mediamp.internal.Platform;
import org.openani.mediamp.internal.PlatformKt;
import org.openani.mediamp.metadata.MediaProperties;
import org.openani.mediamp.mpv.EventListener;
import org.openani.mediamp.mpv.LibraryLoader;
import org.openani.mediamp.mpv.MPVFormat;
import org.openani.mediamp.mpv.MPVHandle;
import org.openani.mediamp.mpv.MPVHandleDesktop;
import org.openani.mediamp.mpv.MpvMediampPlayer;
import org.openani.mediamp.mpv.MpvMediampPlayer_desktopKt;
import org.openani.mediamp.source.MediaData;
import org.openani.mediamp.source.SeekableInputMediaData;
import org.openani.mediamp.source.UriMediaData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f*\u0001\f\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000234B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\b\u0010#\u001a\u00020!H\u0007J\u0016\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0094@\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0002H\u0094@\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020)H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0013H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020)H\u0014J\b\u00102\u001a\u00020)H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lorg/openani/mediamp/mpv/MpvMediampPlayer;", "Lorg/openani/mediamp/AbstractMediampPlayer;", "Lorg/openani/mediamp/mpv/MpvMediampPlayer$MPVPlayerData;", "context", "", "parentCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Ljava/lang/Object;Lkotlin/coroutines/CoroutineContext;)V", "handle", "Lorg/openani/mediamp/mpv/MPVHandle;", "eventListener", "org/openani/mediamp/mpv/MpvMediampPlayer$eventListener$1", "Lorg/openani/mediamp/mpv/MpvMediampPlayer$eventListener$1;", "impl", "getImpl", "()Lorg/openani/mediamp/mpv/MPVHandle;", "currentPositionMillis", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getCurrentPositionMillis", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "mediaProperties", "Lorg/openani/mediamp/metadata/MediaProperties;", "getMediaProperties", "features", "Lorg/openani/mediamp/features/PlayerFeatures;", "getFeatures", "()Lorg/openani/mediamp/features/PlayerFeatures;", "getCurrentMediaProperties", "getCurrentPlaybackState", "Lorg/openani/mediamp/PlaybackState;", "attachRenderSurface", "", "surface", "detachRenderSurface", "setDataImpl", "data", "Lorg/openani/mediamp/source/MediaData;", "(Lorg/openani/mediamp/source/MediaData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startPlayer", "", "(Lorg/openani/mediamp/mpv/MpvMediampPlayer$MPVPlayerData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resume", "pause", "seekTo", "positionMillis", "skip", "deltaMillis", "stopPlaybackImpl", "closeImpl", "MPVPlayerData", "Companion", "mediamp-mpv"})
@SourceDebugExtension(value={"SMAP\nMpvMediampPlayer.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MpvMediampPlayer.jvm.kt\norg/openani/mediamp/mpv/MpvMediampPlayer\n+ 2 PlayerFeatures.kt\norg/openani/mediamp/features/PlayerFeaturesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,242:1\n49#2:243\n216#3,2:244\n*S KotlinDebug\n*F\n+ 1 MpvMediampPlayer.jvm.kt\norg/openani/mediamp/mpv/MpvMediampPlayer\n*L\n81#1:243\n181#1:244,2\n*E\n"})
public final class MpvMediampPlayer
extends AbstractMediampPlayer<MPVPlayerData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MPVHandle handle;
    @NotNull
    private final eventListener.1 eventListener;
    @NotNull
    private final MutableStateFlow<Long> currentPositionMillis;
    @NotNull
    private final MutableStateFlow<MediaProperties> mediaProperties;
    @NotNull
    private final PlayerFeatures features;

    public MpvMediampPlayer(@NotNull Object context, @NotNull CoroutineContext parentCoroutineContext) {
        PlayerFeaturesBuilder playerFeaturesBuilder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineContext, (String)"parentCoroutineContext");
        super(parentCoroutineContext);
        this.handle = new MPVHandle(context);
        this.eventListener = new EventListener(this){
            final /* synthetic */ MpvMediampPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPropertyChange(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }

            public void onPropertyChange(String name, boolean value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"pause")) {
                    this.this$0.getPlaybackState().setValue((Object)(value ? PlaybackState.PAUSED : PlaybackState.PLAYING));
                } else if (Intrinsics.areEqual((Object)string, (Object)"paused-for-cache")) {
                    this.this$0.getPlaybackState().setValue((Object)(value ? PlaybackState.PAUSED_BUFFERING : PlaybackState.PLAYING));
                }
            }

            public void onPropertyChange(String name, long value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"time-pos/full")) {
                    this.this$0.getCurrentPositionMillis().setValue((Object)(value * (long)1000));
                } else if (Intrinsics.areEqual((Object)string, (Object)"duration/full")) {
                    Object object;
                    MutableStateFlow<MediaProperties> mutableStateFlow = this.this$0.getMediaProperties();
                    if (this.this$0.getMediaProperties().getValue() == null) {
                        object = new MediaProperties(null, value * (long)1000);
                    } else {
                        MediaProperties mediaProperties = (MediaProperties)this.this$0.getMediaProperties().getValue();
                        object = mediaProperties != null ? MediaProperties.copy$default((MediaProperties)mediaProperties, null, (long)(value * (long)1000), (int)1, null) : null;
                    }
                    mutableStateFlow.setValue(object);
                }
            }

            public void onPropertyChange(String name, double value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }

            public void onPropertyChange(String name, String value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (Intrinsics.areEqual((Object)name, (Object)"media-title")) {
                    Object object;
                    MutableStateFlow<MediaProperties> mutableStateFlow = this.this$0.getMediaProperties();
                    if (this.this$0.getMediaProperties().getValue() == null) {
                        object = new MediaProperties(value, -1L);
                    } else {
                        MediaProperties mediaProperties = (MediaProperties)this.this$0.getMediaProperties().getValue();
                        object = mediaProperties != null ? MediaProperties.copy$default((MediaProperties)mediaProperties, (String)value, (long)0L, (int)2, null) : null;
                    }
                    mutableStateFlow.setValue(object);
                }
            }
        };
        this.currentPositionMillis = StateFlowKt.MutableStateFlow((Object)0L);
        this.mediaProperties = StateFlowKt.MutableStateFlow(null);
        boolean $i$f$buildPlayerFeatures22 = false;
        PlayerFeaturesBuilder playerFeaturesBuilder2 = playerFeaturesBuilder = new PlayerFeaturesBuilder();
        MpvMediampPlayer mpvMediampPlayer = this;
        boolean bl = false;
        mpvMediampPlayer.features = playerFeaturesBuilder.build();
        this.handle.setEventListener(this.eventListener);
        this.handle.option("config", "no");
        this.handle.option("profile", "fast");
        this.handle.option("vo", "gpu-next");
        Platform $i$f$buildPlayerFeatures22 = PlatformKt.currentPlatform();
        if ($i$f$buildPlayerFeatures22 instanceof Platform.Android) {
            this.handle.option("gpu-context", "android");
            this.handle.option("opengl-es", "yes");
            this.handle.option("ao", "audiotrack,opensles");
        } else if ($i$f$buildPlayerFeatures22 instanceof Platform.Windows) {
            this.handle.option("gpu-context", "d3d11");
            this.handle.option("opengl-es", "no");
            this.handle.option("ao", "audiotrack");
        } else if ($i$f$buildPlayerFeatures22 instanceof Platform.MacOS) {
            this.handle.option("gpu-context", "macvk");
            this.handle.option("opengl-es", "no");
            this.handle.option("ao", "audiotrack");
        }
        this.handle.option("hwdec", "auto");
        this.handle.option("hwdec-codecs", "h264,hevc,mpeg4,mpeg2video,vp8,vp9,av1");
        this.handle.option("input-default-bindings", "yes");
        int cacheMegs = MpvMediampPlayer_desktopKt.limitDemuxer() ? 32 : 64;
        this.handle.option("demuxer-max-bytes", String.valueOf(cacheMegs * 1024 * 1024));
        this.handle.option("demuxer-max-back-bytes", String.valueOf(cacheMegs * 1024 * 1024));
        this.handle.option("vd-lavc-film-grain", "cpu");
        this.handle.initialize();
        this.handle.option("save-position-on-quit", "no");
        this.handle.option("force-window", "no");
        this.handle.option("idle", "yes");
        this.handle.option("keep-open", "always");
        MPVHandle.observeProperty$default(this.handle, "time-pos/full", MPVFormat.MPV_FORMAT_INT64, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "duration/full", MPVFormat.MPV_FORMAT_INT64, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "pause", MPVFormat.MPV_FORMAT_FLAG, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "paused-for-cache", MPVFormat.MPV_FORMAT_FLAG, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "speed", MPVFormat.MPV_FORMAT_STRING, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "media-title", MPVFormat.MPV_FORMAT_STRING, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "metadata", MPVFormat.MPV_FORMAT_NONE, 0L, 4, null);
        MPVHandle.observeProperty$default(this.handle, "hwdec-current", MPVFormat.MPV_FORMAT_NONE, 0L, 4, null);
    }

    @NotNull
    public MPVHandle getImpl() {
        return this.handle;
    }

    @NotNull
    public MutableStateFlow<Long> getCurrentPositionMillis() {
        return this.currentPositionMillis;
    }

    @NotNull
    public MutableStateFlow<MediaProperties> getMediaProperties() {
        return this.mediaProperties;
    }

    @NotNull
    public PlayerFeatures getFeatures() {
        return this.features;
    }

    @Nullable
    public MediaProperties getCurrentMediaProperties() {
        return (MediaProperties)this.getMediaProperties().getValue();
    }

    @NotNull
    public PlaybackState getCurrentPlaybackState() {
        return (PlaybackState)this.getPlaybackState().getValue();
    }

    public long getCurrentPositionMillis() {
        return ((Number)this.getCurrentPositionMillis().getValue()).longValue();
    }

    @InternalMediampApi
    public final boolean attachRenderSurface(@NotNull Object surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        return MPVHandleDesktop.attachSurface(this.handle.getPtr$mediamp_mpv(), surface);
    }

    @InternalMediampApi
    public final boolean detachRenderSurface() {
        return MPVHandleDesktop.detachSurface(this.handle.getPtr$mediamp_mpv());
    }

    @Nullable
    protected Object setDataImpl(@NotNull MediaData data, @NotNull Continuation<? super MPVPlayerData> $completion) {
        MediaData mediaData = data;
        if (mediaData instanceof UriMediaData) {
            Map headers = ((UriMediaData)data).getHeaders();
            String[] stringArray = new String[]{"stop"};
            this.handle.command(stringArray);
            stringArray = new String[]{"playlist-clear"};
            this.handle.command(stringArray);
            String string = (String)headers.get("User-Agent");
            if (string == null) {
                string = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3";
            }
            this.handle.option("user-agent", string);
            this.handle.option("http-header-fields-clr", "");
            Map $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.handle.option("http-header-fields", key + ": " + value);
            }
        } else {
            if (mediaData instanceof SeekableInputMediaData) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return new MPVPlayerData(data, (Function0<Unit>)((Function0)() -> MpvMediampPlayer.setDataImpl$lambda$2(this, data)), (Function0<Unit>)((Function0)() -> MpvMediampPlayer.setDataImpl$lambda$3(data)));
    }

    @Nullable
    protected Object startPlayer(@NotNull MPVPlayerData data, @NotNull Continuation<? super Unit> $completion) {
        data.getSetMedia().invoke();
        return Unit.INSTANCE;
    }

    public void resume() {
        if (this.getPlaybackState().getValue() == PlaybackState.PLAYING) {
            return;
        }
        String[] stringArray = new String[]{"cycle", "pause"};
        this.handle.command(stringArray);
    }

    public void pause() {
        if (this.getPlaybackState().getValue() == PlaybackState.PAUSED) {
            return;
        }
        String[] stringArray = new String[]{"cycle", "pause"};
        this.handle.command(stringArray);
    }

    public void seekTo(long positionMillis) {
        String[] stringArray = new String[]{"seek", String.valueOf(positionMillis), "absolute+exact"};
        this.handle.command(stringArray);
        this.getCurrentPositionMillis().setValue((Object)positionMillis);
    }

    public void skip(long deltaMillis) {
        String[] stringArray = new String[]{"seek", String.valueOf(deltaMillis), "relative+relative"};
        this.handle.command(stringArray);
        stringArray = this.getCurrentPositionMillis();
        stringArray.setValue((Object)(((Number)stringArray.getValue()).longValue() + deltaMillis));
    }

    protected void stopPlaybackImpl() {
        String[] stringArray = new String[]{"stop"};
        this.handle.command(stringArray);
        this.getCurrentPositionMillis().setValue((Object)0L);
    }

    protected void closeImpl() {
        String[] stringArray = new String[]{"stop"};
        this.handle.command(stringArray);
        this.handle.destroy();
        this.handle.close();
    }

    private static final Unit setDataImpl$lambda$2(MpvMediampPlayer this$0, MediaData $data) {
        this$0.handle.option("pause", "true");
        String[] stringArray = new String[]{"loadfile", ((UriMediaData)$data).getUri()};
        this$0.handle.command(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit setDataImpl$lambda$3(MediaData $data) {
        $data.close();
        return Unit.INSTANCE;
    }

    static {
        LibraryLoader.INSTANCE.loadLibraries();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/openani/mediamp/mpv/MpvMediampPlayer$Companion;", "", "<init>", "()V", "mediamp-mpv"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/openani/mediamp/mpv/MpvMediampPlayer$MPVPlayerData;", "Lorg/openani/mediamp/AbstractMediampPlayer$Data;", "mediaData", "Lorg/openani/mediamp/source/MediaData;", "setMedia", "Lkotlin/Function0;", "", "releaseResource", "<init>", "(Lorg/openani/mediamp/source/MediaData;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getSetMedia", "()Lkotlin/jvm/functions/Function0;", "mediamp-mpv"})
    public static final class MPVPlayerData
    extends AbstractMediampPlayer.Data {
        @NotNull
        private final Function0<Unit> setMedia;

        public MPVPlayerData(@NotNull MediaData mediaData, @NotNull Function0<Unit> setMedia, @NotNull Function0<Unit> releaseResource) {
            Intrinsics.checkNotNullParameter((Object)mediaData, (String)"mediaData");
            Intrinsics.checkNotNullParameter(setMedia, (String)"setMedia");
            Intrinsics.checkNotNullParameter(releaseResource, (String)"releaseResource");
            super(mediaData, releaseResource);
            this.setMedia = setMedia;
        }

        @NotNull
        public final Function0<Unit> getSetMedia() {
            return this.setMedia;
        }
    }
}

