/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.test;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openani.mediamp.AbstractMediampPlayer;
import org.openani.mediamp.MediampPlayerFactory;
import org.openani.mediamp.PlaybackState;
import org.openani.mediamp.features.Feature;
import org.openani.mediamp.features.FeatureKey;
import org.openani.mediamp.features.MediaMetadata;
import org.openani.mediamp.features.PlaybackSpeed;
import org.openani.mediamp.features.PlayerFeatures;
import org.openani.mediamp.features.PlayerFeaturesBuilder;
import org.openani.mediamp.metadata.AudioTrack;
import org.openani.mediamp.metadata.Chapter;
import org.openani.mediamp.metadata.MediaProperties;
import org.openani.mediamp.metadata.SubtitleTrack;
import org.openani.mediamp.metadata.TrackGroup;
import org.openani.mediamp.metadata.TrackGroupKt;
import org.openani.mediamp.source.MediaData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0094@\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u001fH\u0014J\b\u0010\"\u001a\u00020\u001fH\u0014J\b\u0010#\u001a\u00020\u001fH\u0014J\b\u0010$\u001a\u00020\u001fH\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lorg/openani/mediamp/test/TestMediampPlayer;", "Lorg/openani/mediamp/AbstractMediampPlayer;", "Lorg/openani/mediamp/AbstractMediampPlayer$Data;", "defaultDispatcher", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lkotlin/coroutines/CoroutineContext;)V", "impl", "", "getImpl", "()Ljava/lang/Object;", "mediaProperties", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/openani/mediamp/metadata/MediaProperties;", "getMediaProperties", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getCurrentMediaProperties", "currentPositionMillis", "", "getCurrentPositionMillis", "getCurrentPlaybackState", "Lorg/openani/mediamp/PlaybackState;", "features", "Lorg/openani/mediamp/features/PlayerFeatures;", "getFeatures", "()Lorg/openani/mediamp/features/PlayerFeatures;", "setMediaDataImpl", "data", "Lorg/openani/mediamp/source/MediaData;", "(Lorg/openani/mediamp/source/MediaData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "seekTo", "", "positionMillis", "resumeImpl", "pauseImpl", "stopPlaybackImpl", "closeImpl", "Factory", "mediamp-test"})
@SourceDebugExtension(value={"SMAP\nTestMediampPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestMediampPlayer.kt\norg/openani/mediamp/test/TestMediampPlayer\n+ 2 PlayerFeatures.kt\norg/openani/mediamp/features/PlayerFeaturesKt\n*L\n1#1,128:1\n49#2:129\n*S KotlinDebug\n*F\n+ 1 TestMediampPlayer.kt\norg/openani/mediamp/test/TestMediampPlayer\n*L\n62#1:129\n*E\n"})
public final class TestMediampPlayer
extends AbstractMediampPlayer<AbstractMediampPlayer.Data> {
    @NotNull
    private final MutableStateFlow<MediaProperties> mediaProperties;
    @NotNull
    private final MutableStateFlow<Long> currentPositionMillis;
    @NotNull
    private final PlayerFeatures features;

    /*
     * WARNING - void declaration
     */
    public TestMediampPlayer(@NotNull CoroutineContext defaultDispatcher) {
        void $this$features_u24lambda_u240;
        PlayerFeaturesBuilder playerFeaturesBuilder;
        Intrinsics.checkNotNullParameter((Object)defaultDispatcher, (String)"defaultDispatcher");
        super(defaultDispatcher);
        this.mediaProperties = StateFlowKt.MutableStateFlow((Object)new MediaProperties("Test Video", 100000L));
        this.currentPositionMillis = StateFlowKt.MutableStateFlow((Object)10000L);
        boolean $i$f$buildPlayerFeatures = false;
        PlayerFeaturesBuilder playerFeaturesBuilder2 = playerFeaturesBuilder = new PlayerFeaturesBuilder();
        TestMediampPlayer testMediampPlayer = this;
        boolean bl = false;
        $this$features_u24lambda_u240.add((FeatureKey)PlaybackSpeed.Key, (Feature)new PlaybackSpeed(){
            private final MutableStateFlow<Float> valueFlow;
            {
                this.valueFlow = StateFlowKt.MutableStateFlow((Object)Float.valueOf(1.0f));
            }

            public MutableStateFlow<Float> getValueFlow() {
                return this.valueFlow;
            }

            public float getValue() {
                return ((Number)this.getValueFlow().getValue()).floatValue();
            }

            public void set(float speed) {
                this.getValueFlow().setValue((Object)Float.valueOf(speed));
            }
        });
        $this$features_u24lambda_u240.add((FeatureKey)MediaMetadata.Key, (Feature)new MediaMetadata(){
            private final TrackGroup<AudioTrack> audioTracks;
            private final TrackGroup<SubtitleTrack> subtitleTracks;
            private final Flow<List<Chapter>> chapters;
            {
                this.audioTracks = TrackGroupKt.emptyTrackGroup();
                this.subtitleTracks = TrackGroupKt.emptyTrackGroup();
                Object[] objectArray = new Chapter[]{new Chapter("chapter1", 90000L, 0L), new Chapter("chapter2", 5000L, 90000L)};
                this.chapters = (Flow)StateFlowKt.MutableStateFlow((Object)CollectionsKt.listOf((Object[])objectArray));
            }

            public TrackGroup<AudioTrack> getAudioTracks() {
                return this.audioTracks;
            }

            public TrackGroup<SubtitleTrack> getSubtitleTracks() {
                return this.subtitleTracks;
            }

            public Flow<List<Chapter>> getChapters() {
                return this.chapters;
            }
        });
        testMediampPlayer.features = playerFeaturesBuilder.build();
    }

    public /* synthetic */ TestMediampPlayer(CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(coroutineContext);
    }

    @NotNull
    public Object getImpl() {
        return this;
    }

    @NotNull
    public MutableStateFlow<MediaProperties> getMediaProperties() {
        return this.mediaProperties;
    }

    @Nullable
    public MediaProperties getCurrentMediaProperties() {
        return (MediaProperties)this.getMediaProperties().getValue();
    }

    @NotNull
    public MutableStateFlow<Long> getCurrentPositionMillis() {
        return this.currentPositionMillis;
    }

    public long getCurrentPositionMillis() {
        return ((Number)this.getCurrentPositionMillis().getValue()).longValue();
    }

    @NotNull
    public PlaybackState getCurrentPlaybackState() {
        return (PlaybackState)this.getPlaybackState().getValue();
    }

    @NotNull
    public PlayerFeatures getFeatures() {
        return this.features;
    }

    @Nullable
    protected Object setMediaDataImpl(@NotNull MediaData data, @NotNull Continuation<? super AbstractMediampPlayer.Data> $completion) {
        return new AbstractMediampPlayer.Data(data, () -> TestMediampPlayer.setMediaDataImpl$lambda$1(data));
    }

    public void seekTo(long positionMillis) {
        this.getCurrentPositionMillis().setValue((Object)positionMillis);
    }

    protected void resumeImpl() {
        this.getPlaybackState().setValue((Object)PlaybackState.PLAYING);
    }

    protected void pauseImpl() {
        this.getPlaybackState().setValue((Object)PlaybackState.PAUSED);
    }

    protected void stopPlaybackImpl() {
        this.getCurrentPositionMillis().setValue((Object)0L);
        this.getMediaProperties().setValue(null);
        this.getPlaybackState().setValue((Object)PlaybackState.FINISHED);
    }

    protected void closeImpl() {
        this.getPlaybackState().setValue((Object)PlaybackState.DESTROYED);
    }

    private static final Unit setMediaDataImpl$lambda$1(MediaData $data) {
        $data.close();
        return Unit.INSTANCE;
    }

    public TestMediampPlayer() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/openani/mediamp/test/TestMediampPlayer$Factory;", "Lorg/openani/mediamp/MediampPlayerFactory;", "Lorg/openani/mediamp/test/TestMediampPlayer;", "<init>", "()V", "forClass", "Lkotlin/reflect/KClass;", "getForClass", "()Lkotlin/reflect/KClass;", "create", "context", "", "parentCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "mediamp-test"})
    public static final class Factory
    implements MediampPlayerFactory<TestMediampPlayer> {
        @NotNull
        public static final Factory INSTANCE = new Factory();
        @NotNull
        private static final KClass<TestMediampPlayer> forClass = Reflection.getOrCreateKotlinClass(TestMediampPlayer.class);

        private Factory() {
        }

        @NotNull
        public KClass<TestMediampPlayer> getForClass() {
            return forClass;
        }

        @NotNull
        public TestMediampPlayer create(@NotNull Object context, @NotNull CoroutineContext parentCoroutineContext) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)parentCoroutineContext, (String)"parentCoroutineContext");
            return new TestMediampPlayer(parentCoroutineContext);
        }
    }
}

