/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.vlc.loader;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openani.mediamp.internal.Arch;
import org.openani.mediamp.internal.Platform;
import org.openani.mediamp.internal.PlatformKt;
import org.openani.mediamp.vlc.loader.TestDiscoveryDirectoryProvider;
import org.openani.mediamp.vlc.loader.VlcPlatformIdentifier;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/openani/mediamp/vlc/loader/MediampVlcLoader;", "", "<init>", "()V", "enableTestDiscovery", "", "baseDir", "Ljava/io/File;", "getCurrentPlatformIdentifier", "Lorg/openani/mediamp/vlc/loader/VlcPlatformIdentifier;", "MyArch", "mediamp-vlc-loader"})
public final class MediampVlcLoader {
    @NotNull
    public static final MediampVlcLoader INSTANCE = new MediampVlcLoader();

    private MediampVlcLoader() {
    }

    public final void enableTestDiscovery(@NotNull File baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        TestDiscoveryDirectoryProvider.Companion.setBaseDir(baseDir);
    }

    public static /* synthetic */ void enableTestDiscovery$default(MediampVlcLoader mediampVlcLoader, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File(System.getProperty("user.dir"), "appResources");
        }
        mediampVlcLoader.enableTestDiscovery(file);
    }

    @NotNull
    public final VlcPlatformIdentifier getCurrentPlatformIdentifier() {
        VlcPlatformIdentifier vlcPlatformIdentifier;
        block18: {
            block20: {
                Platform.Desktop desktop;
                MyArch arch;
                block19: {
                    block17: {
                        MyArch myArch;
                        Platform.Desktop platform = PlatformKt.currentPlatformDesktop();
                        switch (WhenMappings.$EnumSwitchMapping$0[platform.getArch().ordinal()]) {
                            case 1: {
                                myArch = MyArch.X64;
                                break;
                            }
                            case 2: {
                                myArch = MyArch.ARM64;
                                break;
                            }
                            case 3: 
                            case 4: {
                                throw new UnsupportedOperationException("Unsupported architecture: " + platform.getArch());
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        arch = myArch;
                        desktop = platform;
                        if (!(desktop instanceof Platform.MacOS)) break block17;
                        switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
                            case 1: {
                                vlcPlatformIdentifier = VlcPlatformIdentifier.MACOS_X64;
                                break block18;
                            }
                            case 2: {
                                vlcPlatformIdentifier = VlcPlatformIdentifier.MACOS_ARM64;
                                break block18;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (!(desktop instanceof Platform.Windows)) break block19;
                    switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
                        case 1: {
                            vlcPlatformIdentifier = VlcPlatformIdentifier.WINDOWS_X64;
                            break block18;
                        }
                        case 2: {
                            vlcPlatformIdentifier = VlcPlatformIdentifier.WINDOWS_ARM64;
                            break block18;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(desktop instanceof Platform.Linux)) break block20;
                switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
                    case 1: {
                        vlcPlatformIdentifier = VlcPlatformIdentifier.LINUX_X64;
                        break block18;
                    }
                    case 2: {
                        vlcPlatformIdentifier = VlcPlatformIdentifier.LINUX_ARM64;
                        break block18;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return vlcPlatformIdentifier;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openani/mediamp/vlc/loader/MediampVlcLoader$MyArch;", "", "<init>", "(Ljava/lang/String;I)V", "X64", "ARM64", "mediamp-vlc-loader"})
    private static final class MyArch
    extends Enum<MyArch> {
        public static final /* enum */ MyArch X64 = new MyArch();
        public static final /* enum */ MyArch ARM64 = new MyArch();
        private static final /* synthetic */ MyArch[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MyArch[] values() {
            return (MyArch[])$VALUES.clone();
        }

        public static MyArch valueOf(String value) {
            return Enum.valueOf(MyArch.class, value);
        }

        @NotNull
        public static EnumEntries<MyArch> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = myArchArray = new MyArch[]{MyArch.X64, MyArch.ARM64};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Arch.values().length];
            try {
                nArray[Arch.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.AARCH64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.ARMV7A.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.ARMV8A.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MyArch.values().length];
            try {
                nArray[MyArch.X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MyArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

