/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.vlc.compose.internal;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ImageInfo;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_format_cb;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB%\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface;", "Luk/co/caprica/vlcj/player/embedded/videosurface/VideoSurface;", "renderCallback", "Lkotlin/Function1;", "Lorg/jetbrains/skia/Bitmap;", "", "videoSurfaceAdapter", "Luk/co/caprica/vlcj/player/embedded/videosurface/VideoSurfaceAdapter;", "<init>", "(Lkotlin/jvm/functions/Function1;Luk/co/caprica/vlcj/player/embedded/videosurface/VideoSurfaceAdapter;)V", "setup", "Luk/co/caprica/vlcj/binding/internal/libvlc_video_format_cb;", "cleanup", "Luk/co/caprica/vlcj/binding/internal/libvlc_video_cleanup_cb;", "lock", "Luk/co/caprica/vlcj/binding/internal/libvlc_lock_callback_t;", "unlock", "Luk/co/caprica/vlcj/binding/internal/libvlc_unlock_callback_t;", "display", "Luk/co/caprica/vlcj/binding/internal/libvlc_display_callback_t;", "bitmap", "mediaPlayer", "Luk/co/caprica/vlcj/player/base/MediaPlayer;", "attach", "SetupCallback", "CleanupCallback", "LockCallback", "UnlockCallback", "DisplayCallback", "mediamp-vlc"})
final class SkiaVideoSurface
extends VideoSurface {
    @NotNull
    private final Function1<Bitmap, Unit> renderCallback;
    @NotNull
    private final libvlc_video_format_cb setup;
    @NotNull
    private final libvlc_video_cleanup_cb cleanup;
    @NotNull
    private final libvlc_lock_callback_t lock;
    @NotNull
    private final libvlc_unlock_callback_t unlock;
    @NotNull
    private final libvlc_display_callback_t display;
    private Bitmap bitmap;
    @Nullable
    private MediaPlayer mediaPlayer;

    public SkiaVideoSurface(@NotNull Function1<? super Bitmap, Unit> renderCallback, @Nullable VideoSurfaceAdapter videoSurfaceAdapter) {
        Intrinsics.checkNotNullParameter(renderCallback, (String)"renderCallback");
        super(videoSurfaceAdapter);
        this.renderCallback = renderCallback;
        this.setup = new SetupCallback();
        this.cleanup = new CleanupCallback();
        this.lock = new LockCallback();
        this.unlock = new UnlockCallback();
        this.display = new DisplayCallback();
    }

    public void attach(@NotNull MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)mediaPlayer, (String)"mediaPlayer");
        this.mediaPlayer = mediaPlayer;
        LibVlc.libvlc_video_set_format_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_video_format_cb)this.setup, (libvlc_video_cleanup_cb)this.cleanup);
        LibVlc.libvlc_video_set_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_lock_callback_t)this.lock, (libvlc_unlock_callback_t)this.unlock, (libvlc_display_callback_t)this.display, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface$CleanupCallback;", "Luk/co/caprica/vlcj/binding/internal/libvlc_video_cleanup_cb;", "<init>", "(Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface;)V", "cleanup", "", "opaque", "Lcom/sun/jna/Pointer;", "mediamp-vlc"})
    private final class CleanupCallback
    implements libvlc_video_cleanup_cb {
        public void cleanup(@NotNull Pointer opaque) {
            Intrinsics.checkNotNullParameter((Object)opaque, (String)"opaque");
            Bitmap bitmap = SkiaVideoSurface.this.bitmap;
            if (bitmap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bitmap");
                bitmap = null;
            }
            bitmap.close();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface$DisplayCallback;", "Luk/co/caprica/vlcj/binding/internal/libvlc_display_callback_t;", "<init>", "(Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface;)V", "display", "", "opaque", "Lcom/sun/jna/Pointer;", "picture", "mediamp-vlc"})
    private final class DisplayCallback
    implements libvlc_display_callback_t {
        public void display(@NotNull Pointer opaque, @NotNull Pointer picture) {
            Intrinsics.checkNotNullParameter((Object)opaque, (String)"opaque");
            Intrinsics.checkNotNullParameter((Object)picture, (String)"picture");
            Function1 function1 = SkiaVideoSurface.this.renderCallback;
            Bitmap bitmap = SkiaVideoSurface.this.bitmap;
            if (bitmap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bitmap");
                bitmap = null;
            }
            function1.invoke((Object)bitmap);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface$LockCallback;", "Luk/co/caprica/vlcj/binding/internal/libvlc_lock_callback_t;", "<init>", "(Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface;)V", "lock", "Lcom/sun/jna/Pointer;", "opaque", "planes", "Lcom/sun/jna/ptr/PointerByReference;", "mediamp-vlc"})
    private final class LockCallback
    implements libvlc_lock_callback_t {
        @Nullable
        public Pointer lock(@NotNull Pointer opaque, @NotNull PointerByReference planes) {
            Intrinsics.checkNotNullParameter((Object)opaque, (String)"opaque");
            Intrinsics.checkNotNullParameter((Object)planes, (String)"planes");
            Bitmap bitmap = SkiaVideoSurface.this.bitmap;
            if (bitmap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bitmap");
                bitmap = null;
            }
            long ptr = bitmap.get_ptr$skiko();
            long[] lArray = new long[]{ptr};
            planes.getPointer().write(0L, lArray, 0, 1);
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface$SetupCallback;", "Luk/co/caprica/vlcj/binding/internal/libvlc_video_format_cb;", "<init>", "(Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface;)V", "format", "", "opaque", "Lcom/sun/jna/ptr/PointerByReference;", "chroma", "width", "Lcom/sun/jna/ptr/IntByReference;", "height", "pitches", "lines", "applyBufferFormat", "", "bufferFormat", "Luk/co/caprica/vlcj/player/embedded/videosurface/callback/BufferFormat;", "mediamp-vlc"})
    private final class SetupCallback
    implements libvlc_video_format_cb {
        public int format(@NotNull PointerByReference opaque, @NotNull PointerByReference chroma, @NotNull IntByReference width, @NotNull IntByReference height, @NotNull PointerByReference pitches, @NotNull PointerByReference lines) {
            Intrinsics.checkNotNullParameter((Object)opaque, (String)"opaque");
            Intrinsics.checkNotNullParameter((Object)chroma, (String)"chroma");
            Intrinsics.checkNotNullParameter((Object)width, (String)"width");
            Intrinsics.checkNotNullParameter((Object)height, (String)"height");
            Intrinsics.checkNotNullParameter((Object)pitches, (String)"pitches");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            ImageInfo imageInfo = ImageInfo.Companion.makeN32Premul(width.getValue(), height.getValue());
            SkiaVideoSurface.this.bitmap = new Bitmap();
            Bitmap bitmap = SkiaVideoSurface.this.bitmap;
            if (bitmap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bitmap");
                bitmap = null;
            }
            if (!bitmap.allocPixels(imageInfo)) {
                boolean bl = false;
                String string = "Failed bitmap.allocPixels";
                throw new IllegalStateException(string.toString());
            }
            int[] nArray = new int[]{width.getValue() * 4};
            int[] nArray2 = nArray;
            nArray = new int[]{height.getValue()};
            BufferFormat format = new BufferFormat("RV32", width.getValue(), height.getValue(), nArray2, nArray);
            this.applyBufferFormat(format, chroma, width, height, pitches, lines);
            return format.getPlaneCount();
        }

        private final void applyBufferFormat(BufferFormat bufferFormat, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface$UnlockCallback;", "Luk/co/caprica/vlcj/binding/internal/libvlc_unlock_callback_t;", "<init>", "(Lorg/openani/mediamp/vlc/compose/internal/SkiaVideoSurface;)V", "unlock", "", "opaque", "Lcom/sun/jna/Pointer;", "picture", "plane", "mediamp-vlc"})
    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        public void unlock(@NotNull Pointer opaque, @NotNull Pointer picture, @NotNull Pointer plane) {
            Intrinsics.checkNotNullParameter((Object)opaque, (String)"opaque");
            Intrinsics.checkNotNullParameter((Object)picture, (String)"picture");
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
        }
    }
}

