/*
 * Decompiled with CFR 0.152.
 */
package org.openani.mediamp.vlc;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.openani.mediamp.features.AudioLevelController;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/openani/mediamp/vlc/VlcAudioLevelController;", "Lorg/openani/mediamp/features/AudioLevelController;", "player", "Luk/co/caprica/vlcj/player/base/MediaPlayer;", "<init>", "(Luk/co/caprica/vlcj/player/base/MediaPlayer;)V", "volume", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getVolume", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "isMute", "", "maxVolume", "getMaxVolume", "()F", "setMute", "", "mute", "setVolume", "volumeUp", "value", "volumeDown", "mediamp-vlc"})
@StabilityInferred(parameters=0)
public final class VlcAudioLevelController
implements AudioLevelController {
    @NotNull
    private final MediaPlayer player;
    @NotNull
    private final MutableStateFlow<Float> volume;
    @NotNull
    private final MutableStateFlow<Boolean> isMute;
    private final float maxVolume;
    public static final int $stable = 8;

    public VlcAudioLevelController(@NotNull MediaPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.volume = StateFlowKt.MutableStateFlow((Object)Float.valueOf((float)this.player.audio().volume() / 100.0f));
        this.isMute = StateFlowKt.MutableStateFlow((Object)this.player.audio().isMute());
        this.maxVolume = 2.0f;
    }

    @NotNull
    public MutableStateFlow<Float> getVolume() {
        return this.volume;
    }

    @NotNull
    public MutableStateFlow<Boolean> isMute() {
        return this.isMute;
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public void setMute(boolean mute) {
        if (this.player.audio().isMute() == mute) {
            return;
        }
        this.isMute().setValue((Object)mute);
        this.player.audio().mute();
    }

    public void setVolume(float volume) {
        this.getVolume().setValue((Object)Float.valueOf(RangesKt.coerceIn((float)volume, (float)0.0f, (float)this.getMaxVolume())));
        this.player.audio().setVolume(MathKt.roundToInt((float)(volume * (float)100)));
    }

    public void volumeUp(float value) {
        this.setVolume(((Number)this.getVolume().getValue()).floatValue() + value);
    }

    public void volumeDown(float value) {
        this.setVolume(((Number)this.getVolume().getValue()).floatValue() - value);
    }
}

