/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy;

import com.guigarage.responsive.ResponsiveHandler;
import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.openbase.bco.bcozy.controller.CenterPaneController;
import org.openbase.bco.bcozy.controller.ContextMenuController;
import org.openbase.bco.bcozy.controller.LocationController;
import org.openbase.bco.bcozy.controller.MainMenuController;
import org.openbase.bco.bcozy.controller.RemotePool;
import org.openbase.bco.bcozy.jp.JPLanguage;
import org.openbase.bco.bcozy.view.BackgroundPane;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.ImageViewProvider;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.JPDebugMode;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCozy
extends Application {
    public static final String APP_NAME = BCozy.class.getSimpleName().toLowerCase();
    private static final Logger LOGGER = LoggerFactory.getLogger(BCozy.class);
    private static Stage primaryStage;
    private InfoPane infoPane;
    private RemotePool remotePool;
    private ContextMenuController contextMenuController;
    private LocationController locationController;
    private Thread initThread;

    public static void main(String ... args) {
        LOGGER.info("Start " + APP_NAME + "...");
        BCozy.registerListeners();
        JPService.setApplicationName((String)APP_NAME);
        JPService.registerProperty(JPDebugMode.class);
        JPService.registerProperty(JPLanguage.class);
        try {
            JPService.parseAndExitOnError((String[])args);
            BCozy.launch((String[])args);
        }
        catch (IllegalStateException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            LOGGER.info(APP_NAME + " finished unexpected.");
        }
        LOGGER.info(APP_NAME + " finished.");
    }

    public void start(Stage primaryStage) {
        BCozy.primaryStage = primaryStage;
        double screenWidth = Screen.getPrimary().getVisualBounds().getWidth();
        double screenHeight = Screen.getPrimary().getVisualBounds().getHeight();
        primaryStage.setTitle("BCozy");
        StackPane root = new StackPane();
        ForegroundPane foregroundPane = new ForegroundPane(screenHeight, screenWidth);
        foregroundPane.setMinHeight(root.getHeight());
        foregroundPane.setMinWidth(root.getWidth());
        BackgroundPane backgroundPane = new BackgroundPane(foregroundPane);
        this.infoPane = new InfoPane(screenHeight, screenWidth);
        this.infoPane.setMinHeight(root.getHeight());
        this.infoPane.setMinWidth(root.getWidth());
        this.infoPane.setCloseButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> this.stop()));
        root.getChildren().addAll((Object[])new Node[]{backgroundPane, foregroundPane, this.infoPane});
        primaryStage.setMinWidth(foregroundPane.getMainMenu().getMinWidth() + foregroundPane.getContextMenu().getMinWidth() + 300.0);
        primaryStage.setHeight(screenHeight);
        primaryStage.setScene(new Scene((Parent)root, screenWidth, screenHeight));
        primaryStage.getScene().getStylesheets().addAll((Object[])new String[]{"/css/skin.css", "/css/light.css"});
        ResponsiveHandler.addResponsiveToWindow((Window)primaryStage);
        primaryStage.show();
        new MainMenuController(foregroundPane);
        new CenterPaneController(foregroundPane);
        this.remotePool = new RemotePool(foregroundPane);
        this.contextMenuController = new ContextMenuController(foregroundPane, backgroundPane.getLocationPane(), this.remotePool);
        this.locationController = new LocationController(foregroundPane, backgroundPane.getLocationPane(), this.remotePool);
        try {
            if (((Boolean)((JPDebugMode)JPService.getProperty(JPDebugMode.class)).getValue()).booleanValue()) {
                this.infoPane.setVisible(false);
            } else {
                this.initRemotesAndLocation();
            }
        }
        catch (JPNotAvailableException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            this.initRemotesAndLocation();
        }
    }

    private void initRemotesAndLocation() {
        this.initThread = new Thread((Runnable)new Task(){

            protected Object call() throws Exception {
                BCozy.this.infoPane.setTextLabelIdentifier("initRemotes");
                BCozy.this.remotePool.initRegistryRemotes();
                BCozy.this.infoPane.setTextLabelIdentifier("fillDeviceAndLocationMap");
                BCozy.this.remotePool.fillDeviceAndLocationMap();
                BCozy.this.infoPane.setTextLabelIdentifier("fillUserMap");
                BCozy.this.remotePool.fillUserMap();
                BCozy.this.infoPane.setTextLabelIdentifier("fillContextMenu");
                BCozy.this.contextMenuController.initTitledPaneMap();
                BCozy.this.infoPane.setTextLabelIdentifier("connectLocationRemote");
                BCozy.this.locationController.connectLocationRemote();
                return null;
            }

            protected void succeeded() {
                super.succeeded();
                BCozy.this.infoPane.setVisible(false);
            }
        });
        this.initThread.start();
    }

    public void stop() {
        if (this.initThread != null && this.initThread.isAlive()) {
            this.initThread.interrupt();
            try {
                this.initThread.join();
            }
            catch (InterruptedException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        }
        try {
            super.stop();
        }
        catch (Exception e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.remotePool.shutdownAllRemotes();
        System.exit(0);
    }

    public static void changeTheme(String themeName) {
        if (primaryStage != null) {
            switch (themeName) {
                case "/css/dark.css": {
                    primaryStage.getScene().getStylesheets().clear();
                    primaryStage.getScene().getStylesheets().addAll((Object[])new String[]{"/css/skin.css", "/css/dark.css"});
                    ImageViewProvider.colorizeIconsToWhite();
                    break;
                }
                case "/css/light.css": {
                    primaryStage.getScene().getStylesheets().clear();
                    primaryStage.getScene().getStylesheets().addAll((Object[])new String[]{"/css/skin.css", "/css/light.css"});
                    ImageViewProvider.colorizeIconsToBlack();
                    break;
                }
                default: {
                    primaryStage.getScene().getStylesheets().clear();
                }
            }
        }
    }

    private static void registerListeners() {
        LOGGER.info("Executing Registration of Listeners");
        ResponsiveHandler.setOnDeviceTypeChanged((over, oldDeviceType, newDeviceType) -> {
            switch (newDeviceType) {
                case LARGE: {
                    BCozy.adjustToLargeDevice();
                    break;
                }
                case MEDIUM: {
                    BCozy.adjustToMediumDevice();
                    break;
                }
                case SMALL: {
                    BCozy.adjustToSmallDevice();
                    break;
                }
                case EXTRA_SMALL: {
                    BCozy.adjustToExtremeSmallDevice();
                    break;
                }
            }
        });
    }

    private static void adjustToLargeDevice() {
        LOGGER.info("Detected Large Device");
    }

    private static void adjustToMediumDevice() {
        LOGGER.info("Detected Medium Device");
    }

    private static void adjustToSmallDevice() {
        LOGGER.info("Detected Small Device");
    }

    private static void adjustToExtremeSmallDevice() {
        LOGGER.info("Detected Extreme Small Device");
    }
}

