/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javax.vecmath.Point3d;
import org.openbase.bco.bcozy.controller.RemotePool;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rst.domotic.registry.LocationRegistryDataType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationConfigType;
import rst.math.Vec3DDoubleType;

public class LocationController
implements Observer<LocationRegistryDataType.LocationRegistryData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationController.class);
    private final ForegroundPane foregroundPane;
    private final LocationPane locationPane;
    private final RemotePool remotePool;
    private LocationRegistryRemote locationRegistryRemote;

    public LocationController(ForegroundPane foregroundPane, LocationPane locationPane, RemotePool remotePool) {
        this.foregroundPane = foregroundPane;
        this.locationPane = locationPane;
        this.remotePool = remotePool;
        this.foregroundPane.getMainMenu().addFetchLocationButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> this.connectLocationRemote()));
    }

    public void connectLocationRemote() {
        if (this.remotePool.isInit()) {
            try {
                this.locationRegistryRemote = this.remotePool.getLocationRegistryRemote();
                this.locationRegistryRemote.addDataObserver((Observer)this);
                this.updateAndZoomFit();
            }
            catch (Exception e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        } else {
            LOGGER.warn("Registry Remotes are not initialized. Thus a Dummy Location will be loaded.");
            this.fetchDummyLocation();
        }
    }

    private void fetchLocations() throws CouldNotPerformException {
        List locationUnitConfigList = this.locationRegistryRemote.getLocationConfigs();
        this.locationPane.clearLocations();
        String rootLocationFrameId = this.locationRegistryRemote.getRootLocationConfig().getPlacementConfig().getTransformationFrameId();
        for (UnitConfigType.UnitConfig locationUnitConfig : locationUnitConfigList) {
            try {
                if (locationUnitConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
                LinkedList<Point2D> vertices = new LinkedList<Point2D>();
                Future transform = this.remotePool.getTransformReceiver().requestTransform(rootLocationFrameId, locationUnitConfig.getPlacementConfig().getTransformationFrameId(), System.currentTimeMillis());
                List shape = locationUnitConfig.getPlacementConfig().getShape().getFloorList();
                for (Vec3DDoubleType.Vec3DDouble rstVertex : shape) {
                    Point3d vertex = new Point3d(rstVertex.getX(), rstVertex.getY(), rstVertex.getZ());
                    ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(vertex);
                    vertices.add(new Point2D(vertex.x, vertex.y));
                }
                this.locationPane.addLocation(locationUnitConfig.getId(), locationUnitConfig.getLabel(), locationUnitConfig.getLocationConfig().getChildIdList(), vertices, locationUnitConfig.getLocationConfig().getType().toString());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                LOGGER.error("Error while fetching transformation for location \"" + locationUnitConfig.getLabel() + "\", locationID: " + locationUnitConfig.getId());
            }
        }
    }

    private void fetchConnections() throws CouldNotPerformException {
        List connectionUnitConfigList = this.locationRegistryRemote.getConnectionConfigs();
        this.locationPane.clearConnections();
        String rootLocationFrameId = this.locationRegistryRemote.getRootLocationConfig().getPlacementConfig().getTransformationFrameId();
        for (UnitConfigType.UnitConfig connectionUnitConfig : connectionUnitConfigList) {
            try {
                if (connectionUnitConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
                LinkedList<Point2D> vertices = new LinkedList<Point2D>();
                Future transform = this.remotePool.getTransformReceiver().requestTransform(rootLocationFrameId, connectionUnitConfig.getPlacementConfig().getTransformationFrameId(), System.currentTimeMillis());
                List shape = connectionUnitConfig.getPlacementConfig().getShape().getFloorList();
                for (Vec3DDoubleType.Vec3DDouble rstVertex : shape) {
                    Point3d vertex = new Point3d(rstVertex.getX(), rstVertex.getY(), rstVertex.getZ());
                    ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(vertex);
                    vertices.add(new Point2D(vertex.x, vertex.y));
                }
                this.locationPane.addConnection(connectionUnitConfig.getId(), connectionUnitConfig.getLabel(), vertices, connectionUnitConfig.getConnectionConfig().getType().toString(), connectionUnitConfig.getConnectionConfig().getTileIdList());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                LOGGER.error("Error while fetching transformation for connection \"" + connectionUnitConfig.getLabel() + "\", connectionID: " + connectionUnitConfig.getId());
            }
        }
    }

    private void fetchDummyLocation() {
        this.locationPane.clearLocations();
        LinkedList<Point2D> zoneVertices = new LinkedList<Point2D>();
        zoneVertices.add(new Point2D(0.0, 0.0));
        zoneVertices.add(new Point2D(10.0, 0.0));
        zoneVertices.add(new Point2D(10.0, 10.0));
        zoneVertices.add(new Point2D(0.0, 10.0));
        this.locationPane.addLocation("DummyID0", "DummyLabel0", new LinkedList<String>(), zoneVertices, LocationConfigType.LocationConfig.LocationType.ZONE.toString());
        LinkedList<Point2D> tile0Vertices = new LinkedList<Point2D>();
        tile0Vertices.add(new Point2D(1.0, 1.0));
        tile0Vertices.add(new Point2D(5.0, 1.0));
        tile0Vertices.add(new Point2D(5.0, 3.0));
        tile0Vertices.add(new Point2D(1.0, 3.0));
        this.locationPane.addLocation("DummyID1", "DummyLabel1", new LinkedList<String>(), tile0Vertices, LocationConfigType.LocationConfig.LocationType.TILE.toString());
        LinkedList<Point2D> tile1Vertices = new LinkedList<Point2D>();
        tile1Vertices.add(new Point2D(6.0, 1.0));
        tile1Vertices.add(new Point2D(6.0, 8.0));
        tile1Vertices.add(new Point2D(8.0, 8.0));
        tile1Vertices.add(new Point2D(8.0, 1.0));
        this.locationPane.addLocation("DummyID2", "DummyLabel2", new LinkedList<String>(), tile1Vertices, LocationConfigType.LocationConfig.LocationType.TILE.toString());
        this.locationPane.zoomFit();
    }

    public void update(Observable<LocationRegistryDataType.LocationRegistryData> observable, LocationRegistryDataType.LocationRegistryData locationRegistry) throws Exception {
        Platform.runLater(() -> {
            try {
                this.fetchLocations();
                this.fetchConnections();
                this.locationPane.updateLocationPane();
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        });
    }

    public void updateAndZoomFit() throws Exception {
        Platform.runLater(() -> {
            try {
                this.fetchLocations();
                this.fetchConnections();
                this.locationPane.updateLocationPane();
                this.locationPane.zoomFit();
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        });
    }
}

