/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.openbase.bco.bcozy.BCozy;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.mainmenupanes.AvailableUsersPane;
import org.openbase.bco.bcozy.view.mainmenupanes.ConnectionPane;
import org.openbase.bco.bcozy.view.mainmenupanes.LoginPane;
import org.openbase.bco.bcozy.view.mainmenupanes.SettingsPane;

public class MainMenuController {
    private final LoginPane loginPane;
    private final SettingsPane settingsPane;
    private final AvailableUsersPane availableUsersPane;
    private final ConnectionPane connectionPane;

    public MainMenuController(ForegroundPane foregroundPane) {
        this.loginPane = foregroundPane.getMainMenu().getLoginPane();
        this.settingsPane = foregroundPane.getMainMenu().getSettingsPane();
        this.availableUsersPane = foregroundPane.getMainMenu().getAvailableUsersPanePane();
        this.connectionPane = foregroundPane.getMainMenu().getConnectionPane();
        this.loginPane.getStartLoginBtn().setOnAction(event -> this.startLogin());
        this.loginPane.getLoginBtn().setOnAction(event -> this.loginUser());
        this.loginPane.getBackBtn().setOnAction(event -> this.resetLogin());
        this.loginPane.getLogoutBtn().setOnAction(event -> this.resetLogin());
        this.loginPane.getPasswordField().setOnAction(event -> this.loginUser());
        this.loginPane.getNameTxt().setOnAction(event -> this.loginUser());
        this.loginPane.getNameTxt().setOnKeyTyped(event -> this.resetWrongInput());
        this.loginPane.getPasswordField().setOnKeyTyped(event -> this.resetWrongInput());
        this.loginPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        this.settingsPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        this.availableUsersPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        this.connectionPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        this.settingsPane.getThemeChoice().setOnAction(event -> this.chooseTheme());
        this.settingsPane.getLanguageChoice().setOnAction(event -> this.chooseLanguage());
        this.settingsPane.getThemeChoice().getSelectionModel().select(0);
        this.settingsPane.getLanguageChoice().getSelectionModel().select(0);
        foregroundPane.getMainMenu().getMainMenuFloatingButton().setOnAction(event -> this.showHideMainMenu(foregroundPane));
    }

    private void startLogin() {
        this.loginPane.setState(LoginPane.State.LOGINACTIVE);
    }

    private void resetWrongInput() {
        if (this.loginPane.getInputWrongLbl().isVisible()) {
            this.loginPane.resetUserOrPasswordWrong();
        }
    }

    private void loginUser() {
        if (this.loginPane.getNameTxt().getText().equals("Admin") && this.loginPane.getPasswordField().getText().equals("")) {
            this.loginPane.resetUserOrPasswordWrong();
            this.loginPane.getLoggedInUserLbl().setText(this.loginPane.getNameTxt().getText());
            this.loginPane.getNameTxt().setText("");
            this.loginPane.getPasswordField().setText("");
            this.loginPane.setState(LoginPane.State.LOGOUT);
        } else {
            this.loginPane.indicateUserOrPasswordWrong();
        }
    }

    private void resetLogin() {
        if (this.loginPane.getInputWrongLbl().isVisible()) {
            this.loginPane.resetUserOrPasswordWrong();
        }
        this.loginPane.getNameTxt().setText("");
        this.loginPane.getPasswordField().setText("");
        this.loginPane.getLoggedInUserLbl().setText("");
        this.loginPane.setState(LoginPane.State.LOGIN);
    }

    private void showHideMainMenu(ForegroundPane foregroundPane) {
        if (foregroundPane.getMainMenu().isMaximized()) {
            foregroundPane.getMainMenu().minimizeMainMenu();
        } else {
            foregroundPane.getMainMenu().maximizeMainMenu();
        }
    }

    private void chooseTheme() {
        final ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        this.settingsPane.getThemeChoice().getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (((String)MainMenuController.this.settingsPane.getAvailableThemes().get(number2.intValue())).equals(languageBundle.getString("light"))) {
                    BCozy.changeTheme("/css/light.css");
                } else if (((String)MainMenuController.this.settingsPane.getAvailableThemes().get(number2.intValue())).equals(languageBundle.getString("dark"))) {
                    BCozy.changeTheme("/css/dark.css");
                }
            }
        });
    }

    private void chooseLanguage() {
        this.settingsPane.getLanguageChoice().getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (((String)MainMenuController.this.settingsPane.getAvailableLanguages().get(number2.intValue())).equals("English")) {
                    LanguageSelection.getInstance().setSelectedLocale(new Locale("en", "US"));
                } else if (((String)MainMenuController.this.settingsPane.getAvailableLanguages().get(number2.intValue())).equals("Deutsch")) {
                    LanguageSelection.getInstance().setSelectedLocale(new Locale("de", "DE"));
                }
            }
        });
    }
}

