/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ProgressIndicator;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.manager.user.remote.UserRemote;
import org.openbase.bco.registry.device.remote.DeviceRegistryRemote;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.bco.registry.unit.lib.UnitRegistry;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.bco.registry.user.remote.UserRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.TransformReceiver;
import rct.TransformerFactory;
import rst.domotic.state.InventoryStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class RemotePool {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotePool.class);
    private final Map<String, AbstractIdentifiableRemote> deviceMap;
    private final Map<String, Map<String, AbstractIdentifiableRemote>> locationMap;
    private final Map<String, UserRemote> userMap;
    private LocationRegistryRemote locationRegistryRemote;
    private DeviceRegistryRemote deviceRegistryRemote;
    private UserRegistryRemote userRegistryRemote;
    private UnitRegistry unitRegistry;
    private TransformReceiver transformReceiver;
    private boolean init;
    private boolean mapsFilled;

    public RemotePool(final ForegroundPane foregroundPane) {
        foregroundPane.getMainMenu().addInitRemoteButtonEventHandler(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Task task = new Task(){
                    private final ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);

                    protected Object call() throws Exception {
                        Platform.runLater(() -> {
                            foregroundPane.getContextMenu().getTitledPaneContainer().clearTitledPane();
                            foregroundPane.getContextMenu().getChildren().add((Object)this.progressIndicator);
                        });
                        try {
                            RemotePool.this.initRegistryRemotes();
                        }
                        catch (InterruptedException | CouldNotPerformException | TransformerFactory.TransformerFactoryException e) {
                            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                        }
                        return null;
                    }

                    protected void succeeded() {
                        super.succeeded();
                        Platform.runLater(() -> foregroundPane.getContextMenu().getChildren().remove((Object)this.progressIndicator));
                    }
                };
                new Thread((Runnable)task).start();
            }
        });
        foregroundPane.getMainMenu().addFillHashesButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> {
            Task task = new Task(){
                private final ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);

                protected Object call() throws Exception {
                    Platform.runLater(() -> {
                        foregroundPane.getContextMenu().getTitledPaneContainer().clearTitledPane();
                        foregroundPane.getContextMenu().getChildren().add((Object)this.progressIndicator);
                    });
                    try {
                        RemotePool.this.fillDeviceAndLocationMap();
                    }
                    catch (CouldNotPerformException e) {
                        ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                        RemotePool.this.shutdownDALRemotesAndClearMaps();
                    }
                    return null;
                }

                protected void succeeded() {
                    super.succeeded();
                    Platform.runLater(() -> foregroundPane.getContextMenu().getChildren().remove((Object)this.progressIndicator));
                }
            };
            GlobalExecutionService.execute((Runnable)task);
        }));
        this.deviceMap = new HashMap<String, AbstractIdentifiableRemote>();
        this.locationMap = new HashMap<String, Map<String, AbstractIdentifiableRemote>>();
        this.userMap = new HashMap<String, UserRemote>();
        this.init = false;
        this.mapsFilled = false;
    }

    public void initRegistryRemotes() throws CouldNotPerformException, InterruptedException, TransformerFactory.TransformerFactoryException {
        if (this.init) {
            LOGGER.info("INFO: RegistryRemotes were already initialized.");
            return;
        }
        this.unitRegistry = CachedUnitRegistryRemote.getRegistry();
        CachedUnitRegistryRemote.waitForData();
        this.locationRegistryRemote = new LocationRegistryRemote();
        this.locationRegistryRemote.init();
        this.locationRegistryRemote.activate();
        try {
            this.deviceRegistryRemote = new DeviceRegistryRemote();
            this.deviceRegistryRemote.init();
            this.deviceRegistryRemote.activate();
        }
        catch (InterruptedException | CouldNotPerformException e) {
            this.locationRegistryRemote.shutdown();
            throw e;
        }
        try {
            this.userRegistryRemote = new UserRegistryRemote();
            this.userRegistryRemote.init();
            this.userRegistryRemote.activate();
        }
        catch (InterruptedException | CouldNotPerformException e) {
            this.locationRegistryRemote.shutdown();
            this.deviceRegistryRemote.shutdown();
            throw e;
        }
        try {
            this.transformReceiver = TransformerFactory.getInstance().createTransformReceiver();
        }
        catch (TransformerFactory.TransformerFactoryException e) {
            this.locationRegistryRemote.shutdown();
            this.deviceRegistryRemote.shutdown();
            this.userRegistryRemote.shutdown();
            throw e;
        }
        this.init = true;
        LOGGER.info("INFO: RegistryRemotes are initialized.");
    }

    private void checkInit() throws CouldNotPerformException {
        if (!this.init) {
            throw new CouldNotPerformException("RegistryRemotes are not initialized.");
        }
    }

    public void fillDeviceAndLocationMap() throws CouldNotPerformException {
        this.checkInit();
        if (this.mapsFilled) {
            this.shutdownDALRemotesAndClearMaps();
        }
        this.fillDeviceMap();
        for (UnitConfigType.UnitConfig currentLocationUnitConfig : this.locationRegistryRemote.getLocationConfigs()) {
            LOGGER.info("INFO: Room: " + currentLocationUnitConfig.getId());
            for (String unitId : currentLocationUnitConfig.getLocationConfig().getUnitIdList()) {
                LOGGER.info("INFO: Unit: " + unitId);
                if (!this.deviceMap.containsKey(unitId)) continue;
                AbstractIdentifiableRemote currentDalRemoteService = this.deviceMap.get(unitId);
                if (!this.locationMap.containsKey(currentLocationUnitConfig.getId())) {
                    this.locationMap.put(currentLocationUnitConfig.getId(), new TreeMap());
                }
                this.locationMap.get(currentLocationUnitConfig.getId()).put(unitId, currentDalRemoteService);
            }
        }
        this.mapsFilled = true;
    }

    private void fillDeviceMap() throws CouldNotPerformException {
        UnitRemoteFactory unitRemoteFactoryInterface = UnitRemoteFactoryImpl.getInstance();
        for (UnitConfigType.UnitConfig deviceUnitConfig : this.deviceRegistryRemote.getDeviceConfigs()) {
            if (deviceUnitConfig.getDeviceConfig().getInventoryState().getValue() != InventoryStateType.InventoryState.State.INSTALLED) continue;
            ArrayList<UnitConfigType.UnitConfig> dalUnitConfigList = new ArrayList<UnitConfigType.UnitConfig>();
            for (String unitId : deviceUnitConfig.getDeviceConfig().getUnitIdList()) {
                dalUnitConfigList.add(this.unitRegistry.getUnitConfigById(unitId));
            }
            for (UnitConfigType.UnitConfig currentUnitConfig : dalUnitConfigList) {
                AbstractIdentifiableRemote currentDalRemoteService;
                try {
                    currentDalRemoteService = unitRemoteFactoryInterface.createAndInitUnitRemote(currentUnitConfig);
                }
                catch (CouldNotPerformException e) {
                    ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                    continue;
                }
                try {
                    currentDalRemoteService.activate();
                }
                catch (InterruptedException | CouldNotPerformException e) {
                    ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                    continue;
                }
                this.deviceMap.put(currentUnitConfig.getId(), currentDalRemoteService);
            }
        }
    }

    public void fillUserMap() throws CouldNotPerformException {
        for (UnitConfigType.UnitConfig currentUserUnitConfig : this.userRegistryRemote.getUserConfigs()) {
            UserRemote currentUserRemote = new UserRemote();
            try {
                currentUserRemote.init((GeneratedMessage)currentUserUnitConfig);
                currentUserRemote.activate();
            }
            catch (InterruptedException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        }
    }

    public <Remote extends AbstractIdentifiableRemote> Remote getUnitRemoteById(String unitId) throws CouldNotPerformException {
        this.checkInit();
        return (Remote)this.deviceMap.get(unitId);
    }

    public <Remote extends AbstractIdentifiableRemote> Remote getUnitRemoteByIdAndLocation(String unitId, String locationId) throws CouldNotPerformException {
        this.checkInit();
        return (Remote)this.locationMap.get(locationId).get(unitId);
    }

    public <Remote extends AbstractIdentifiableRemote> List<Remote> getUnitRemoteListOfClass(Class<? extends Remote> remoteClass) throws CouldNotPerformException {
        this.checkInit();
        ArrayList<AbstractIdentifiableRemote> unitRemoteList = new ArrayList<AbstractIdentifiableRemote>();
        for (Map.Entry<String, AbstractIdentifiableRemote> stringDALRemoteServiceEntry : this.deviceMap.entrySet()) {
            AbstractIdentifiableRemote currentDalRemoteService = stringDALRemoteServiceEntry.getValue();
            if (!currentDalRemoteService.getClass().equals(remoteClass)) continue;
            unitRemoteList.add(currentDalRemoteService);
        }
        return unitRemoteList;
    }

    public List<AbstractIdentifiableRemote> getUnitRemoteListOfLocation(String locationId) throws CouldNotPerformException {
        this.checkInit();
        ArrayList<AbstractIdentifiableRemote> unitRemoteList = new ArrayList<AbstractIdentifiableRemote>();
        if (this.locationMap.containsKey(locationId)) {
            Map<String, AbstractIdentifiableRemote> unitRemoteHashOfLocation = this.locationMap.get(locationId);
            for (Map.Entry<String, AbstractIdentifiableRemote> currentEntry : unitRemoteHashOfLocation.entrySet()) {
                unitRemoteList.add(currentEntry.getValue());
            }
        }
        return unitRemoteList;
    }

    public Map<UnitTemplateType.UnitTemplate.UnitType, List<AbstractIdentifiableRemote>> getUnitRemoteMapOfLocation(String locationId) {
        UnitTemplateType.UnitTemplate.UnitType[] unitTypes;
        TreeMap<UnitTemplateType.UnitTemplate.UnitType, List<AbstractIdentifiableRemote>> unitRemoteMap = new TreeMap<UnitTemplateType.UnitTemplate.UnitType, List<AbstractIdentifiableRemote>>();
        for (UnitTemplateType.UnitTemplate.UnitType type : unitTypes = UnitTemplateType.UnitTemplate.UnitType.values()) {
            try {
                Class remote = UnitRemoteFactoryImpl.loadUnitRemoteClass((UnitTemplateType.UnitTemplate.UnitType)type);
                List unitRemoteList = this.getUnitRemoteListOfLocationAndClass(locationId, remote);
                if (unitRemoteList.isEmpty()) continue;
                unitRemoteMap.put(type, unitRemoteList);
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        }
        return unitRemoteMap;
    }

    public <Remote extends AbstractIdentifiableRemote> List<Remote> getUnitRemoteListOfLocationAndClass(String locationId, Class<? extends Remote> remoteClass) throws CouldNotPerformException {
        this.checkInit();
        ArrayList<AbstractIdentifiableRemote> unitRemoteList = new ArrayList<AbstractIdentifiableRemote>();
        if (this.locationMap.containsKey(locationId)) {
            Map<String, AbstractIdentifiableRemote> unitRemoteHashOfLocation = this.locationMap.get(locationId);
            for (Map.Entry<String, AbstractIdentifiableRemote> currentEntry : unitRemoteHashOfLocation.entrySet()) {
                if (currentEntry.getValue().getClass() != remoteClass) continue;
                unitRemoteList.add(currentEntry.getValue());
            }
        }
        return unitRemoteList;
    }

    public List<UserRemote> getUserRemoteList() throws CouldNotPerformException {
        this.checkInit();
        List<UserRemote> userRemoteList = this.userMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        return userRemoteList;
    }

    public void shutdownDALRemotesAndClearMaps() {
        this.shutdownDALRemotes();
        this.deviceMap.clear();
        this.locationMap.clear();
        this.mapsFilled = false;
    }

    public void shutdownDALRemotes() {
        for (Map.Entry<String, AbstractIdentifiableRemote> stringDALRemoteServiceEntry : this.deviceMap.entrySet()) {
            AbstractIdentifiableRemote remote = stringDALRemoteServiceEntry.getValue();
            remote.shutdown();
        }
    }

    public void shutdownAllRemotes() {
        for (Map.Entry<String, AbstractIdentifiableRemote> stringDALRemoteServiceEntry : this.deviceMap.entrySet()) {
            AbstractIdentifiableRemote remote = stringDALRemoteServiceEntry.getValue();
            remote.shutdown();
        }
        if (this.locationRegistryRemote != null) {
            LOGGER.info("Shutting down locationRegistryRemote...");
            this.locationRegistryRemote.shutdown();
        }
        if (this.deviceRegistryRemote != null) {
            LOGGER.info("Shutting down deviceRegistryRemote...");
            this.deviceRegistryRemote.shutdown();
        }
        TransformerFactory.killInstance();
        this.init = false;
    }

    public DeviceRegistryRemote getDeviceRegistryRemote() throws CouldNotPerformException {
        this.checkInit();
        return this.deviceRegistryRemote;
    }

    public LocationRegistryRemote getLocationRegistryRemote() throws CouldNotPerformException {
        this.checkInit();
        return this.locationRegistryRemote;
    }

    public TransformReceiver getTransformReceiver() throws CouldNotPerformException {
        this.checkInit();
        return this.transformReceiver;
    }

    public boolean isInit() {
        return this.init;
    }

    public boolean isMapsFilled() {
        return this.mapsFilled;
    }
}

