/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.devicepanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.devicepanes.TamperDetectorPane;
import org.openbase.bco.bcozy.view.devicepanes.UnitPane;
import org.openbase.bco.manager.app.remote.AppRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;
import rst.domotic.unit.agent.AgentDataType;
import rst.domotic.unit.app.AppDataType;

public class AppPane
extends UnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(TamperDetectorPane.class);
    private final SVGIcon appIcon;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final AppRemote appRemote;
    private final BorderPane headContent;

    public AppPane(AbstractIdentifiableRemote appRemote) {
        this.appRemote = (AppRemote)appRemote;
        this.headContent = new BorderPane();
        this.appIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.POWER, 32.0, false);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, true);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.appRemote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        ActivationStateType.ActivationState.State state = ActivationStateType.ActivationState.State.UNKNOWN;
        try {
            state = ((AppDataType.AppData)this.appRemote.getData()).getActivationState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setAppIconAndText(state);
    }

    private void setAppIconAndText(ActivationStateType.ActivationState.State state) {
        this.iconPane.getChildren().clear();
        if (state.equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
            this.appIcon.setForegroundIconColor(Color.GREEN);
            this.iconPane.add((Node)this.appIcon, 0, 0);
            this.observerText.setIdentifier("active");
            if (!this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(true);
            }
        } else if (state.equals((Object)ActivationStateType.ActivationState.State.DEACTIVE)) {
            this.appIcon.changeForegroundIcon((GlyphIcons)MaterialDesignIcon.POWER);
            this.iconPane.add((Node)this.appIcon, 0, 0);
            this.observerText.setIdentifier("inactive");
            if (this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(false);
            }
        } else {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
    }

    private void sendStateToRemote(ActivationStateType.ActivationState.State state) {
        try {
            this.appRemote.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(state).build());
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            this.setWidgetPaneDisable(true);
        }
    }

    @Override
    protected void initTitle() {
        this.oneClick.addListener((observable, oldValue, newValue) -> new Thread((Runnable)new Task(){

            protected Object call() {
                if (AppPane.this.toggleSwitch.isSelected()) {
                    AppPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.DEACTIVE);
                } else {
                    AppPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.ACTIVE);
                }
                return null;
            }
        }).start());
        this.toggleSwitch.setOnMouseClicked(event -> new Thread((Runnable)new Task(){

            protected Object call() {
                if (AppPane.this.toggleSwitch.isSelected()) {
                    AppPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.ACTIVE);
                } else {
                    AppPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.DEACTIVE);
                }
                return null;
            }
        }).start());
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.appIcon.getHeight() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((AppDataType.AppData)this.appRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.appRemote;
    }

    @Override
    void removeObserver() {
        this.appRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object agent) throws Exception {
        Platform.runLater(() -> {
            ActivationStateType.ActivationState.State state = ((AgentDataType.AgentData)agent).getActivationState().getValue();
            this.setAppIconAndText(state);
        });
    }
}

