/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.devicepanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.devicepanes.UnitPane;
import org.openbase.bco.dal.remote.unit.BatteryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.BatteryStateType;
import rst.domotic.unit.dal.BatteryDataType;

public class BatteryPane
extends UnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatteryPane.class);
    private final BatteryRemote batteryRemote;
    private final SVGIcon batteryIcon;
    private final Text batteryStatus;
    private final BorderPane headContent;

    public BatteryPane(AbstractIdentifiableRemote batteryRemote) {
        this.batteryRemote = (BatteryRemote)batteryRemote;
        this.headContent = new BorderPane();
        this.batteryIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.BATTERY, (GlyphIcons)MaterialDesignIcon.BATTERY_OUTLINE, 32.0);
        this.batteryStatus = new Text();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.batteryRemote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        double batteryLevel = 0.0;
        BatteryStateType.BatteryState.State batteryState = BatteryStateType.BatteryState.State.UNKNOWN;
        try {
            batteryLevel = this.batteryRemote.getBatteryState().getLevel();
            batteryState = this.batteryRemote.getBatteryState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setStatusBatteryIcon(batteryLevel);
        this.setBatteryStateColorAndIcon(batteryState);
    }

    private void setBatteryStateColorAndIcon(BatteryStateType.BatteryState.State batteryState) {
        switch (batteryState) {
            case UNKNOWN: {
                this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_UNKNOWN);
                this.batteryIcon.setBackgroundIconColorAnimated(Color.BLACK);
                this.observerText.setIdentifier("unknown");
                break;
            }
            case OK: {
                this.batteryIcon.setBackgroundIconColorAnimated(Color.GREEN);
                this.observerText.setIdentifier("okay");
                break;
            }
            case CRITICAL: {
                this.batteryIcon.setBackgroundIconColorAnimated(Color.RED);
                this.observerText.setIdentifier("critical");
                break;
            }
            case INSUFFICIENT: {
                this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_ALERT);
                this.batteryIcon.setBackgroundIconColorAnimated(Color.RED);
                this.observerText.setIdentifier("insufficient");
                break;
            }
        }
    }

    private void setStatusBatteryIcon(double batteryLevel) {
        this.batteryStatus.setText((int)batteryLevel + "%");
        if (batteryLevel > 95.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY);
        } else if (batteryLevel > 85.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_90);
        } else if (batteryLevel > 75.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_80);
        } else if (batteryLevel > 55.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_60);
        } else if (batteryLevel > 35.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_40);
        } else if (batteryLevel > 25.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_30);
        } else if (batteryLevel > 15.0) {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_20);
        } else {
            this.batteryIcon.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.BATTERY_OUTLINE);
        }
    }

    @Override
    protected void initTitle() {
        this.batteryStatus.getStyleClass().add((Object)"icons");
        this.batteryIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
        this.iconPane.add((Node)this.batteryIcon, 0, 0);
        this.iconPane.add((Node)this.batteryStatus, 1, 0);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.iconPane.getHeight() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((BatteryDataType.BatteryData)this.batteryRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.batteryRemote;
    }

    @Override
    void removeObserver() {
        this.batteryRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object battery) throws Exception {
        Platform.runLater(() -> {
            double batteryLevel = ((BatteryDataType.BatteryData)battery).getBatteryState().getLevel();
            this.setStatusBatteryIcon(batteryLevel);
            BatteryStateType.BatteryState.State batteryState = ((BatteryDataType.BatteryData)battery).getBatteryState().getValue();
            this.setBatteryStateColorAndIcon(batteryState);
        });
    }
}

