/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.devicepanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.devicepanes.UnitPane;
import org.openbase.bco.dal.remote.unit.LightRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.LightDataType;

public class LightPane
extends UnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPane.class);
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final LightRemote lightRemote;
    private final SVGIcon lightBulbIcon;
    private final BorderPane headContent;

    public LightPane(AbstractIdentifiableRemote lightRemote) {
        this.lightRemote = (LightRemote)lightRemote;
        this.lightBulbIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB, (GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, 32.0);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.headContent = new BorderPane();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, true);
        this.initEffectAndSwitch();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.lightRemote.addDataObserver((Observer)this);
    }

    private void initEffectAndSwitch() {
        PowerStateType.PowerState.State powerState = PowerStateType.PowerState.State.OFF;
        try {
            powerState = this.lightRemote.getPowerState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setPowerStateSwitchAndIcon(powerState);
    }

    private void setPowerStateSwitchAndIcon(PowerStateType.PowerState.State powerState) {
        this.iconPane.getChildren().clear();
        if (powerState.equals((Object)PowerStateType.PowerState.State.ON)) {
            this.iconPane.add((Node)this.lightBulbIcon, 0, 0);
            this.lightBulbIcon.setBackgroundIconColorAnimated(Constants.LIGHTBULB_COLOR);
            this.observerText.setIdentifier("lightOn");
            if (!this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(true);
            }
        } else if (powerState.equals((Object)PowerStateType.PowerState.State.OFF)) {
            this.iconPane.add((Node)this.lightBulbIcon, 0, 0);
            this.lightBulbIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
            this.observerText.setIdentifier("lightOff");
            if (this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(false);
            }
        } else {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
    }

    private void sendStateToRemote(PowerStateType.PowerState.State state) {
        try {
            this.lightRemote.setPowerState(state);
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            this.setWidgetPaneDisable(true);
        }
    }

    @Override
    protected void initTitle() {
        this.oneClick.addListener((observable, oldValue, newValue) -> new Thread((Runnable)new Task(){

            protected Object call() {
                if (LightPane.this.toggleSwitch.isSelected()) {
                    LightPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                } else {
                    LightPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                }
                return null;
            }
        }).start());
        this.toggleSwitch.setOnMouseClicked(event -> new Thread((Runnable)new Task(){

            protected Object call() {
                if (LightPane.this.toggleSwitch.isSelected()) {
                    LightPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                } else {
                    LightPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                }
                return null;
            }
        }).start());
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.lightBulbIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.lightBulbIcon.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((LightDataType.LightData)this.lightRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.lightRemote;
    }

    @Override
    void removeObserver() {
        this.lightRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object light) throws Exception {
        Platform.runLater(() -> {
            PowerStateType.PowerState.State powerState = ((LightDataType.LightData)light).getPowerState().getValue();
            this.setPowerStateSwitchAndIcon(powerState);
        });
    }
}

