/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.devicepanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.devicepanes.UnitPane;
import org.openbase.bco.dal.remote.unit.SmokeDetectorRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.AlarmStateType;
import rst.domotic.state.SmokeStateType;
import rst.domotic.unit.dal.SmokeDetectorDataType;

public class SmokeDetectorPane
extends UnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmokeDetectorPane.class);
    private final SmokeDetectorRemote smokeDetectorRemote;
    private final SVGIcon smokeDetectorIconFire;
    private final SVGIcon smokeDetectorIconNoFire;
    private final SVGIcon smokeDetectorIconFireFade;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final BorderPane headContent;
    private final FadeTransition flashAnimation;

    public SmokeDetectorPane(AbstractIdentifiableRemote smokeDetectorRemote) {
        this.smokeDetectorRemote = (SmokeDetectorRemote)smokeDetectorRemote;
        this.headContent = new BorderPane();
        this.smokeDetectorIconFire = new SVGIcon((GlyphIcons)MaterialDesignIcon.FIRE, 32.0, false);
        this.smokeDetectorIconNoFire = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE, 32.0, false);
        this.smokeDetectorIconFireFade = new SVGIcon((GlyphIcons)MaterialDesignIcon.FIRE, 32.0, false);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.flashAnimation = new FadeTransition(Duration.millis((double)1000.0));
        this.flashAnimation.setNode((Node)this.smokeDetectorIconFireFade);
        this.flashAnimation.setFromValue(0.0);
        this.flashAnimation.setToValue(1.0);
        this.flashAnimation.setCycleCount(-1);
        this.flashAnimation.setAutoReverse(true);
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.smokeDetectorRemote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        AlarmStateType.AlarmState.State alarmState = AlarmStateType.AlarmState.State.UNKNOWN;
        SmokeStateType.SmokeState.State smokeState = SmokeStateType.SmokeState.State.UNKNOWN;
        try {
            alarmState = this.smokeDetectorRemote.getSmokeAlarmState().getValue();
            smokeState = this.smokeDetectorRemote.getSmokeState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setSmokeDetectorIconAndText(alarmState, smokeState);
    }

    private void setSmokeDetectorIconAndText(AlarmStateType.AlarmState.State alarmState, SmokeStateType.SmokeState.State smokeState) {
        this.iconPane.getChildren().clear();
        if (smokeState == SmokeStateType.SmokeState.State.SMOKE) {
            this.smokeDetectorIconFire.setForegroundIconColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0));
            this.iconPane.add((Node)this.smokeDetectorIconFire, 0, 0);
            this.observerText.setIdentifier("smoke");
        } else if (smokeState == SmokeStateType.SmokeState.State.SOME_SMOKE) {
            this.smokeDetectorIconFire.setForegroundIconColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5));
            this.iconPane.add((Node)this.smokeDetectorIconFire, 0, 0);
            this.observerText.setIdentifier("someSmoke");
        } else if (smokeState == SmokeStateType.SmokeState.State.NO_SMOKE) {
            this.iconPane.add((Node)this.smokeDetectorIconNoFire, 0, 0);
            this.observerText.setIdentifier("noSmoke");
        } else if (smokeState == SmokeStateType.SmokeState.State.UNKNOWN || alarmState == AlarmStateType.AlarmState.State.UNKNOWN) {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
        if (alarmState == AlarmStateType.AlarmState.State.ALARM && smokeState != SmokeStateType.SmokeState.State.UNKNOWN) {
            if (smokeState == SmokeStateType.SmokeState.State.SMOKE || smokeState == SmokeStateType.SmokeState.State.SOME_SMOKE) {
                this.smokeDetectorIconFireFade.changeForegroundIcon((GlyphIcons)MaterialDesignIcon.FIRE);
            } else if (smokeState == SmokeStateType.SmokeState.State.NO_SMOKE) {
                this.smokeDetectorIconFireFade.changeForegroundIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE);
                this.observerText.setIdentifier("alarm");
            }
            this.iconPane.add((Node)this.smokeDetectorIconFireFade, 0, 0);
            this.flashAnimation.play();
        } else {
            this.flashAnimation.stop();
        }
    }

    @Override
    protected void initTitle() {
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.smokeDetectorIconFireFade.setForegroundIconColor(Color.RED);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.smokeDetectorIconFire.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((SmokeDetectorDataType.SmokeDetectorData)this.smokeDetectorRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.smokeDetectorRemote;
    }

    @Override
    void removeObserver() {
        this.smokeDetectorRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object smokeDetector) throws Exception {
        Platform.runLater(() -> {
            AlarmStateType.AlarmState.State alarmState = ((SmokeDetectorDataType.SmokeDetectorData)smokeDetector).getSmokeAlarmState().getValue();
            SmokeStateType.SmokeState.State smokeState = ((SmokeDetectorDataType.SmokeDetectorData)smokeDetector).getSmokeState().getValue();
            this.setSmokeDetectorIconAndText(alarmState, smokeState);
        });
    }
}

