/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.devicepanes;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.devicepanes.AgentPane;
import org.openbase.bco.bcozy.view.devicepanes.AppPane;
import org.openbase.bco.bcozy.view.devicepanes.BatteryPane;
import org.openbase.bco.bcozy.view.devicepanes.BrightnessSensorPane;
import org.openbase.bco.bcozy.view.devicepanes.ColorableLightPane;
import org.openbase.bco.bcozy.view.devicepanes.DimmableLightPane;
import org.openbase.bco.bcozy.view.devicepanes.LightPane;
import org.openbase.bco.bcozy.view.devicepanes.MotionDetectorPane;
import org.openbase.bco.bcozy.view.devicepanes.PowerConsumptionSensorPane;
import org.openbase.bco.bcozy.view.devicepanes.PowerSwitchPane;
import org.openbase.bco.bcozy.view.devicepanes.ReedContactPane;
import org.openbase.bco.bcozy.view.devicepanes.RollerShutterPane;
import org.openbase.bco.bcozy.view.devicepanes.ScenePane;
import org.openbase.bco.bcozy.view.devicepanes.SmokeDetectorPane;
import org.openbase.bco.bcozy.view.devicepanes.TamperDetectorPane;
import org.openbase.bco.bcozy.view.devicepanes.TemperatureControllerPane;
import org.openbase.bco.bcozy.view.devicepanes.TemperatureSensorPane;
import org.openbase.bco.bcozy.view.devicepanes.UnitPane;
import org.openbase.bco.bcozy.view.mainmenupanes.ObserverTitledPane;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitTemplateType;

public class UnitPaneContainer
extends ObserverTitledPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitPaneContainer.class);
    private final VBox vBox = new VBox();

    public UnitPaneContainer(String unitTypeName) {
        super(unitTypeName);
        this.vBox.getStyleClass().add((Object)"observer-titled-pane");
        this.getStyleClass().add((Object)"observer-titled-pane");
        this.setContent((Node)this.vBox);
    }

    public boolean createAndAddNewUnitPanes(UnitTemplateType.UnitTemplate.UnitType unitType, List<AbstractIdentifiableRemote> dalRemoteServiceList) {
        this.setExpanded(false);
        if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.AGENT)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                AgentPane agentPane = new AgentPane(dalRemoteService);
                this.vBox.getChildren().add((Object)agentPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.COLORABLE_LIGHT)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                ColorableLightPane ambientLightPane = new ColorableLightPane(dalRemoteService);
                this.vBox.getChildren().add((Object)ambientLightPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.APP)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                AppPane appPane = new AppPane(dalRemoteService);
                this.vBox.getChildren().add((Object)appPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.BATTERY)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                BatteryPane batteryPanePane = new BatteryPane(dalRemoteService);
                this.vBox.getChildren().add((Object)batteryPanePane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.BRIGHTNESS_SENSOR)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                BrightnessSensorPane brightnessSensorPane = new BrightnessSensorPane(dalRemoteService);
                this.vBox.getChildren().add((Object)brightnessSensorPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.DIMMABLE_LIGHT)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                DimmableLightPane dimmerPane = new DimmableLightPane(dalRemoteService);
                this.vBox.getChildren().add((Object)dimmerPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.LIGHT)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                LightPane lightPane = new LightPane(dalRemoteService);
                this.vBox.getChildren().add((Object)lightPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.MOTION_DETECTOR)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                MotionDetectorPane motionSensorPane = new MotionDetectorPane(dalRemoteService);
                this.vBox.getChildren().add((Object)motionSensorPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.POWER_CONSUMPTION_SENSOR)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                PowerConsumptionSensorPane powerConsumptionSensorPane = new PowerConsumptionSensorPane(dalRemoteService);
                this.vBox.getChildren().add((Object)powerConsumptionSensorPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.POWER_SWITCH)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                PowerSwitchPane powerPlugPane = new PowerSwitchPane(dalRemoteService);
                this.vBox.getChildren().add((Object)powerPlugPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.REED_CONTACT)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                ReedContactPane reedSwitchPane = new ReedContactPane(dalRemoteService);
                this.vBox.getChildren().add((Object)reedSwitchPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.ROLLER_SHUTTER)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                RollerShutterPane rollerShutterPane = new RollerShutterPane(dalRemoteService);
                this.vBox.getChildren().add((Object)rollerShutterPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.SCENE)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                ScenePane scenePane = new ScenePane(dalRemoteService);
                this.vBox.getChildren().add((Object)scenePane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.SMOKE_DETECTOR)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                SmokeDetectorPane smokeDetectorPane = new SmokeDetectorPane(dalRemoteService);
                this.vBox.getChildren().add((Object)smokeDetectorPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.TAMPER_DETECTOR)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                TamperDetectorPane tamperSwitchPane = new TamperDetectorPane(dalRemoteService);
                this.vBox.getChildren().add((Object)tamperSwitchPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_CONTROLLER)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                TemperatureControllerPane temperatureControllerPane = new TemperatureControllerPane(dalRemoteService);
                this.vBox.getChildren().add((Object)temperatureControllerPane);
            }
        } else if (unitType.equals((Object)UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_SENSOR)) {
            for (AbstractIdentifiableRemote dalRemoteService : dalRemoteServiceList) {
                TemperatureSensorPane temperatureSensorPane = new TemperatureSensorPane(dalRemoteService);
                this.vBox.getChildren().add((Object)temperatureSensorPane);
            }
        } else {
            LOGGER.info("INFO: Unit Type is not supported yet: ".concat(unitType.toString()));
            return false;
        }
        return true;
    }

    public void clearUnitPaneContainer() {
        for (Node node : this.vBox.getChildren()) {
            ((UnitPane)node).removeObserver();
        }
        this.getChildren().clear();
    }
}

