/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.location.ConnectionPolygon;
import org.openbase.bco.bcozy.view.location.DoorPolygon;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.bco.bcozy.view.location.PassagePolygon;
import org.openbase.bco.bcozy.view.location.RegionPolygon;
import org.openbase.bco.bcozy.view.location.TilePolygon;
import org.openbase.bco.bcozy.view.location.UnitButton;
import org.openbase.bco.bcozy.view.location.WindowPolygon;
import org.openbase.bco.bcozy.view.location.ZonePolygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocationPane
extends Pane {
    private static LocationPane instance;
    private static final Logger LOGGER;
    private LocationPolygon selectedLocation;
    private ZonePolygon rootRoom;
    private final ForegroundPane foregroundPane;
    private final Map<String, TilePolygon> tileMap;
    private final Map<String, RegionPolygon> regionMap;
    private final SimpleStringProperty selectedLocationId;
    private final Map<String, ConnectionPolygon> connectionMap;
    private LocationPolygon lastFirstClickTarget;
    private LocationPolygon lastSelectedTile;
    private final EventHandler<MouseEvent> onEmptyAreaClickHandler;

    private LocationPane(ForegroundPane foregroundPane) {
        this.foregroundPane = foregroundPane;
        this.tileMap = new HashMap<String, TilePolygon>();
        this.regionMap = new HashMap<String, RegionPolygon>();
        this.connectionMap = new HashMap<String, ConnectionPolygon>();
        this.selectedLocation = new ZonePolygon("DUMMY", "DUMMY", new LinkedList<String>(), 0.0, 0.0, 0.0, 0.0);
        this.selectedLocationId = new SimpleStringProperty("DUMMY");
        this.rootRoom = null;
        this.lastSelectedTile = this.selectedLocation;
        this.lastFirstClickTarget = this.selectedLocation;
        this.onEmptyAreaClickHandler = event -> {
            if (event.isStillSincePress() && this.rootRoom != null) {
                if (event.getClickCount() == 1) {
                    if (!this.selectedLocation.equals(this.rootRoom)) {
                        this.selectedLocation.setSelected(false);
                        this.rootRoom.setSelected(true);
                        this.setSelectedLocation(this.rootRoom);
                    }
                } else if (event.getClickCount() == 2) {
                    this.autoFocusPolygonAnimated(this.rootRoom);
                }
                foregroundPane.getContextMenu().getRoomInfo().setText(this.selectedLocation.getLabel());
            }
        };
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.setTranslateY(this.getTranslateY() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0 * this.getScaleY()));
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.setTranslateX(this.getTranslateX() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0 * this.getScaleX()));
        this.foregroundPane.getMainMenuWidthProperty().addListener((observable, oldValue, newValue) -> this.setTranslateX(this.getTranslateX() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationPane getInstance() throws InstantiationException {
        Class<LocationPane> clazz = LocationPane.class;
        synchronized (LocationPane.class) {
            if (instance == null) {
                throw new InstantiationException();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationPane getInstance(ForegroundPane foregroundPane) {
        Class<LocationPane> clazz = LocationPane.class;
        synchronized (LocationPane.class) {
            if (instance == null) {
                instance = new LocationPane(foregroundPane);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void addLocation(String locationId, String locationLabel, List<String> childIds, List<Point2D> vertices, String locationType) {
        double[] points = new double[vertices.size() * 2];
        for (int i = 0; i < vertices.size(); ++i) {
            points[i * 2] = vertices.get(i).getY() * 50.0;
            points[i * 2 + 1] = vertices.get(i).getX() * 50.0;
        }
        switch (locationType) {
            case "TILE": {
                TilePolygon locationPolygon = new TilePolygon(locationLabel, locationId, childIds, points);
                this.addMouseEventHandlerToTile(locationPolygon);
                this.tileMap.put(locationId, locationPolygon);
                break;
            }
            case "REGION": {
                RegionPolygon locationPolygon = new RegionPolygon(locationLabel, locationId, childIds, points);
                this.addMouseEventHandlerToRegion(locationPolygon);
                this.regionMap.put(locationId, locationPolygon);
                break;
            }
            case "ZONE": {
                ZonePolygon locationPolygon;
                this.rootRoom = locationPolygon = new ZonePolygon(locationLabel, locationId, childIds, points);
                break;
            }
            default: {
                LOGGER.warn("The following location has an unknown LocationType and will be ignored:\n  location UUID:  " + locationId + "\n  location Label: " + locationLabel + "\n  location Type:  " + locationType);
            }
        }
    }

    public void addConnection(String connectionId, String connectionLabel, List<Point2D> vertices, String connectionType, List<String> locationIds) {
        ConnectionPolygon connectionPolygon;
        double[] points = new double[vertices.size() * 2];
        for (int i = 0; i < vertices.size(); ++i) {
            points[i * 2] = vertices.get(i).getY() * 50.0;
            points[i * 2 + 1] = vertices.get(i).getX() * 50.0;
        }
        switch (connectionType) {
            case "DOOR": {
                connectionPolygon = new DoorPolygon(connectionLabel, connectionId, points);
                break;
            }
            case "WINDOW": {
                connectionPolygon = new WindowPolygon(connectionLabel, connectionId, points);
                break;
            }
            case "PASSAGE": {
                connectionPolygon = new PassagePolygon(connectionLabel, connectionId, points);
                break;
            }
            default: {
                LOGGER.warn("The following connection has an unknown LocationType and will be ignored:\n  connection UUID:  " + connectionId + "\n  connection Label: " + connectionLabel + "\n  connection Type:  " + connectionType);
                return;
            }
        }
        this.connectionMap.put(connectionId, connectionPolygon);
        locationIds.forEach(locationId -> {
            if (this.tileMap.containsKey(locationId)) {
                LocationPolygon locationPolygon = this.tileMap.get(locationId);
                locationPolygon.addCuttingShape((Shape)connectionPolygon);
            } else {
                LOGGER.error("Location ID \"" + locationId + "\" can not be found in the location Map. " + "No Cutting will be applied");
            }
        });
    }

    public void addUnit(SVGIcon svgIcon, EventHandler<ActionEvent> onActionHandler, Point2D position) {
        UnitButton unitButton = new UnitButton(svgIcon, onActionHandler);
        unitButton.setTranslateX(position.getX());
        unitButton.setTranslateY(position.getY());
        this.getChildren().add((Object)unitButton);
    }

    public void clearLocations() {
        this.tileMap.forEach((locationId, locationPolygon) -> this.getChildren().remove(locationPolygon));
        this.tileMap.clear();
        this.regionMap.forEach((locationId, locationPolygon) -> this.getChildren().remove(locationPolygon));
        this.regionMap.clear();
        this.rootRoom = null;
    }

    public void clearConnections() {
        this.connectionMap.forEach((connectionId, connectionPolygon) -> this.getChildren().remove(connectionPolygon));
        this.connectionMap.clear();
    }

    public void updateLocationPane() {
        this.getChildren().clear();
        this.tileMap.forEach((locationId, locationPolygon) -> {
            this.rootRoom.addCuttingShape((Shape)locationPolygon);
            this.getChildren().add(locationPolygon);
        });
        this.regionMap.forEach((locationId, locationPolygon) -> {
            this.rootRoom.addCuttingShape((Shape)locationPolygon);
            this.getChildren().add(locationPolygon);
        });
        this.connectionMap.forEach((connectionId, connectionPolygon) -> {
            this.rootRoom.addCuttingShape((Shape)connectionPolygon);
            this.getChildren().add(connectionPolygon);
        });
        if (this.rootRoom != null) {
            this.getChildren().add((Object)this.rootRoom);
        }
    }

    public void addMouseEventHandlerToTile(TilePolygon tile) {
        tile.setOnMouseClicked(event -> {
            event.consume();
            if (event.isStillSincePress()) {
                if (event.getClickCount() == 1) {
                    this.setSelectedLocation(tile);
                    this.lastFirstClickTarget = tile;
                } else if (event.getClickCount() == 2) {
                    this.autoFocusPolygonAnimated(tile);
                }
            }
        });
        tile.setOnMouseEntered(event -> {
            event.consume();
            tile.mouseEntered();
            this.foregroundPane.getInfoFooter().getMouseOverText().setText(tile.getLabel());
        });
        tile.setOnMouseExited(event -> {
            event.consume();
            tile.mouseLeft();
            this.foregroundPane.getInfoFooter().getMouseOverText().setText("");
        });
    }

    public void addMouseEventHandlerToRegion(RegionPolygon region) {
        region.setOnMouseClicked(event -> {
            event.consume();
            if (event.isStillSincePress()) {
                if (event.getClickCount() == 1) {
                    this.setSelectedLocation(region);
                    this.lastFirstClickTarget = region;
                } else if (event.getClickCount() == 2) {
                    if (this.lastFirstClickTarget.equals(region)) {
                        this.autoFocusPolygonAnimated(region);
                    } else {
                        this.selectedLocation.fireEvent((Event)event.copyFor(null, (EventTarget)this.selectedLocation));
                    }
                }
            }
        });
        region.setOnMouseEntered(event -> {
            event.consume();
            region.mouseEntered();
            this.foregroundPane.getInfoFooter().getMouseOverText().setText(region.getLabel());
        });
        region.setOnMouseExited(event -> {
            event.consume();
            region.mouseLeft();
            this.foregroundPane.getInfoFooter().getMouseOverText().setText("");
        });
    }

    private void setSelectedLocation(LocationPolygon newSelectedLocation) {
        if (!this.selectedLocation.equals(newSelectedLocation)) {
            if (!newSelectedLocation.getClass().equals(RegionPolygon.class)) {
                this.lastSelectedTile.getChildIds().forEach(childId -> this.regionMap.get(childId).changeStyleOnSelectable(false));
            }
            if (newSelectedLocation.getClass().equals(TilePolygon.class)) {
                this.lastSelectedTile = newSelectedLocation;
                newSelectedLocation.getChildIds().forEach(childId -> this.regionMap.get(childId).changeStyleOnSelectable(true));
            }
            this.selectedLocation.setSelected(false);
            newSelectedLocation.setSelected(true);
            this.selectedLocation = newSelectedLocation;
            this.selectedLocationId.set(newSelectedLocation.getUuid());
            this.foregroundPane.getContextMenu().getRoomInfo().setText(this.selectedLocation.getLabel());
        }
    }

    public void zoomFit() {
        if (this.rootRoom != null) {
            this.autoFocusPolygon(this.rootRoom);
        } else if (!this.tileMap.isEmpty()) {
            this.autoFocusPolygon(this.tileMap.values().iterator().next());
        }
    }

    public void addSelectedLocationIdListener(ChangeListener<? super String> changeListener) {
        this.selectedLocationId.addListener(changeListener);
    }

    public void removeSelectedLocationIdListener(ChangeListener<? super String> changeListener) {
        this.selectedLocationId.removeListener(changeListener);
    }

    public EventHandler<MouseEvent> getOnEmptyAreaClickHandler() {
        return this.onEmptyAreaClickHandler;
    }

    private void autoFocusPolygon(LocationPolygon polygon) {
        double yScale;
        double xScale = this.foregroundPane.getBoundingBox().getWidth() / polygon.prefWidth(0.0) * 0.7;
        double scale = xScale < (yScale = this.foregroundPane.getBoundingBox().getHeight() / polygon.prefHeight(0.0) * 0.7) ? xScale : yScale;
        this.setScaleX(scale);
        this.setScaleY(scale);
        Point2D transition = this.calculateTransition(scale, polygon);
        this.setTranslateX(transition.getX());
        this.setTranslateY(transition.getY());
    }

    private void autoFocusPolygonAnimated(LocationPolygon polygon) {
        double yScale;
        double xScale = this.foregroundPane.getBoundingBox().getWidth() / polygon.prefWidth(0.0) * 0.7;
        double scale = xScale < (yScale = this.foregroundPane.getBoundingBox().getHeight() / polygon.prefHeight(0.0) * 0.7) ? xScale : yScale;
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)500.0));
        scaleTransition.setToX(scale);
        scaleTransition.setToY(scale);
        scaleTransition.setCycleCount(1);
        scaleTransition.setAutoReverse(true);
        Point2D transition = this.calculateTransition(scale, polygon);
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)500.0));
        translateTransition.setToX(transition.getX());
        translateTransition.setToY(transition.getY());
        translateTransition.setCycleCount(1);
        translateTransition.setAutoReverse(true);
        ParallelTransition parallelTransition = new ParallelTransition((Node)this, new Animation[]{scaleTransition, translateTransition});
        parallelTransition.play();
    }

    private Point2D calculateTransition(double scale, LocationPolygon polygon) {
        double polygonDistanceToCenterX = -(polygon.getCenterX() - this.getLayoutBounds().getWidth() / 2.0) * scale;
        double polygonDistanceToCenterY = -(polygon.getCenterY() - this.getLayoutBounds().getHeight() / 2.0) * scale;
        double boundingBoxCenterX = (this.foregroundPane.getBoundingBox().getMinX() + this.foregroundPane.getBoundingBox().getMaxX()) / 2.0;
        double boundingBoxCenterY = (this.foregroundPane.getBoundingBox().getMinY() + this.foregroundPane.getBoundingBox().getMaxY()) / 2.0;
        double bbCenterDistanceToCenterX = this.getLayoutBounds().getWidth() / 2.0 - boundingBoxCenterX;
        double bbCenterDistanceToCenterY = this.getLayoutBounds().getHeight() / 2.0 - boundingBoxCenterY;
        double transitionX = polygonDistanceToCenterX - bbCenterDistanceToCenterX;
        double transitionY = polygonDistanceToCenterY - bbCenterDistanceToCenterY;
        return new Point2D(transitionX, transitionY);
    }

    static {
        LOGGER = LoggerFactory.getLogger(LocationPane.class);
    }
}

