/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.BoundingBox;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import org.openbase.bco.bcozy.view.CenterPane;
import org.openbase.bco.bcozy.view.ContextMenu;
import org.openbase.bco.bcozy.view.InfoFooter;
import org.openbase.bco.bcozy.view.MainMenu;
import org.openbase.bco.bcozy.view.MenuHeader;

public class ForegroundPane
extends BorderPane {
    private final MainMenu mainMenu;
    private final ContextMenu contextMenu;
    private final CenterPane centerPane;
    private final MenuHeader menuHeader;
    private final InfoFooter infoFooter;

    public ForegroundPane(double height, double width) {
        this.mainMenu = new MainMenu(height - 150.0, 300.0);
        this.contextMenu = new ContextMenu(height - 150.0, 300.0);
        this.menuHeader = new MenuHeader(30.0, width);
        this.infoFooter = new InfoFooter(20.0, width);
        this.centerPane = new CenterPane();
        this.setLeft((Node)this.mainMenu);
        this.setRight((Node)this.contextMenu);
        this.setBottom((Node)this.infoFooter);
        this.setCenter((Node)this.centerPane);
        this.setTop((Node)this.menuHeader);
        this.setPickOnBounds(false);
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public CenterPane getCenterPane() {
        return this.centerPane;
    }

    public InfoFooter getInfoFooter() {
        return this.infoFooter;
    }

    public BoundingBox getBoundingBox() {
        return new BoundingBox(this.mainMenu.getLayoutBounds().getMaxX(), this.menuHeader.getLayoutBounds().getMaxY(), this.centerPane.getWidth(), this.centerPane.getHeight());
    }

    public ReadOnlyDoubleProperty getMainMenuWidthProperty() {
        return this.mainMenu.widthProperty();
    }
}

