/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;
import org.openbase.bco.bcozy.view.location.Colorable;

public abstract class AbstractPolygon
extends Polygon
implements Colorable {
    public static final double CUSTOM_COLOR_WEIGHT = 0.5;
    private Color mainColor;
    private Color customColor;
    private final double centerX = (super.getLayoutBounds().getMaxX() + super.getLayoutBounds().getMinX()) / 2.0;
    private final double centerY = (super.getLayoutBounds().getMaxY() + super.getLayoutBounds().getMinY()) / 2.0;
    private final String label;
    private final String uuid;

    public AbstractPolygon(String label, String uuid, double ... points) {
        super(points);
        this.label = label;
        this.uuid = uuid;
        this.mainColor = Color.TRANSPARENT;
        this.customColor = Color.TRANSPARENT;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUuid() {
        return this.uuid;
    }

    protected void setMainColor(Color mainColor) {
        this.mainColor = mainColor;
        this.onColorChange(this.mainColor, this.customColor);
    }

    protected Color getMainColor() {
        return this.mainColor;
    }

    @Override
    public void setCustomColor(Color color) {
        this.customColor = color;
        this.onColorChange(this.mainColor, this.customColor);
    }

    @Override
    public Color getCustomColor() {
        return this.customColor;
    }

    protected abstract void onColorChange(Color var1, Color var2);
}

