/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.location.LocationPolygon;

public class TilePolygon
extends LocationPolygon {
    public TilePolygon(String locationLabel, String locationId, List<String> childIds, double ... points) {
        super(locationLabel, locationId, childIds, points);
    }

    @Override
    protected void setLocationStyle() {
        this.setMainColor(Color.TRANSPARENT);
        this.setStroke((Paint)Color.WHITE);
        this.setStrokeWidth(1.0);
    }

    @Override
    protected void changeStyleOnSelection(boolean selected) {
        if (selected) {
            this.setMainColor(Constants.TILE_SELECTION);
        } else {
            this.setMainColor(Color.TRANSPARENT);
        }
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }

    public void mouseEntered() {
        this.setStrokeWidth(3.0);
    }

    public void mouseLeft() {
        this.setStrokeWidth(1.0);
    }
}

