/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;

public class LoginPane
extends PaneElement {
    private final Button startLoginBtn = new Button("", (Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.LOGIN, 32.0, true));
    private final ObserverButton loginBtn;
    private final Button backBtn;
    private final ObserverButton logoutBtn;
    private final TextField nameTxt;
    private final PasswordField passwordField;
    private final ObserverLabel inputWrongLbl;
    private final Label loggedInUserLbl;
    private final VBox loginLayout;
    private final VBox logoutLayout;
    private final ObserverLabel nameLbl = new ObserverLabel("username");
    private final ObserverLabel pwLbl;
    private final BorderPane statusIcon;

    public LoginPane() {
        this.nameLbl.setAlignment(Pos.BOTTOM_LEFT);
        this.nameTxt = new TextField();
        this.pwLbl = new ObserverLabel("password");
        this.passwordField = new PasswordField();
        this.inputWrongLbl = new ObserverLabel("inputWrong");
        this.inputWrongLbl.setAlignment(Pos.TOP_LEFT);
        this.loginBtn = new ObserverButton("login");
        HBox rightAlignLoginButton = new HBox(new Node[]{this.loginBtn});
        rightAlignLoginButton.setAlignment(Pos.CENTER_RIGHT);
        this.backBtn = new Button("", (Node)new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_LEFT, 16.0, true));
        this.loginLayout = new VBox(10.0);
        BorderPane loginFirstLineLayout = new BorderPane();
        loginFirstLineLayout.setLeft((Node)this.nameLbl);
        loginFirstLineLayout.setRight((Node)this.backBtn);
        this.loginLayout.getStyleClass().clear();
        this.loginLayout.setAlignment(Pos.BOTTOM_LEFT);
        this.loginLayout.getChildren().addAll((Object[])new Node[]{loginFirstLineLayout, this.nameTxt, this.pwLbl, this.passwordField, rightAlignLoginButton});
        this.logoutLayout = new VBox(10.0);
        SVGIcon loggedInUserIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.ACCOUNT_CIRCLE, 32.0, true);
        this.loggedInUserLbl = new Label();
        this.logoutBtn = new ObserverButton("logout");
        HBox rightAlignLogoutButton = new HBox(new Node[]{this.logoutBtn});
        rightAlignLogoutButton.setAlignment(Pos.CENTER_RIGHT);
        this.logoutLayout.getStyleClass().clear();
        this.logoutLayout.setAlignment(Pos.TOP_CENTER);
        this.logoutLayout.getChildren().addAll((Object[])new Node[]{loggedInUserIcon, this.loggedInUserLbl, rightAlignLogoutButton});
        this.nameLbl.getStyleClass().clear();
        this.nameLbl.getStyleClass().add((Object)"small-label");
        this.inputWrongLbl.getStyleClass().clear();
        this.inputWrongLbl.getStyleClass().add((Object)"wrong-input-indicator");
        this.pwLbl.getStyleClass().clear();
        this.pwLbl.getStyleClass().add((Object)"small-label");
        this.loginBtn.getStyleClass().clear();
        this.loginBtn.getStyleClass().add((Object)"transparent-button");
        this.logoutBtn.getStyleClass().clear();
        this.logoutBtn.getStyleClass().add((Object)"transparent-button");
        this.getChildren().addAll((Object[])new Node[]{this.startLoginBtn});
        this.statusIcon = new BorderPane((Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.LOGIN, 48.0, true));
    }

    public Button getStartLoginBtn() {
        return this.startLoginBtn;
    }

    public ObserverButton getLoginBtn() {
        return this.loginBtn;
    }

    public Button getBackBtn() {
        return this.backBtn;
    }

    public TextField getNameTxt() {
        return this.nameTxt;
    }

    public PasswordField getPasswordField() {
        return this.passwordField;
    }

    public ObserverButton getLogoutBtn() {
        return this.logoutBtn;
    }

    public ObserverLabel getInputWrongLbl() {
        return this.inputWrongLbl;
    }

    public Label getLoggedInUserLbl() {
        return this.loggedInUserLbl;
    }

    public ObserverLabel getPwLbl() {
        return this.pwLbl;
    }

    public ObserverLabel getNameLbl() {
        return this.nameLbl;
    }

    public void indicateUserOrPasswordWrong() {
        if (!this.loginLayout.getChildren().contains((Object)this.inputWrongLbl)) {
            this.passwordField.getStyleClass().add((Object)"password-field-wrong");
            this.nameTxt.getStyleClass().add((Object)"text-field-wrong");
            this.loginLayout.getChildren().add(this.loginLayout.getChildren().size() - 1, (Object)this.inputWrongLbl);
        }
    }

    public void resetUserOrPasswordWrong() {
        this.passwordField.getStyleClass().clear();
        this.nameTxt.getStyleClass().clear();
        this.passwordField.getStyleClass().add((Object)"password-field");
        this.nameTxt.getStyleClass().add((Object)"text-field");
        if (this.loginLayout.getChildren().contains((Object)this.inputWrongLbl)) {
            this.loginLayout.getChildren().remove((Object)this.inputWrongLbl);
        }
    }

    @Override
    public Node getStatusIcon() {
        return this.statusIcon;
    }

    public void setState(State state) {
        switch (state) {
            case LOGINACTIVE: {
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.loginLayout});
                this.statusIcon.getChildren().clear();
                this.statusIcon.setCenter((Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.LOGIN, 48.0, true));
                break;
            }
            case LOGIN: {
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.startLoginBtn});
                this.statusIcon.getChildren();
                this.statusIcon.setCenter((Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.LOGIN, 48.0, true));
                break;
            }
            case LOGOUT: {
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.logoutLayout});
                this.statusIcon.getChildren();
                this.statusIcon.setCenter((Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.LOGOUT, 48.0, true));
                break;
            }
            default: {
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.startLoginBtn});
                this.statusIcon.getChildren();
                this.statusIcon.setCenter((Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.LOGIN, 32.0, true));
            }
        }
    }

    public static enum State {
        LOGINACTIVE,
        LOGIN,
        LOGOUT;

    }
}

