/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;

public class SettingsPane
extends PaneElement {
    private final ChoiceBox<String> themeChoice;
    private final ChoiceBox<String> languageChoice;
    private final ObservableList<String> availableThemes;
    private final ObservableList<String> availableLanguages;
    private final ObserverLabel settingsLbl;
    private final SVGIcon settingsIcon;
    private final SVGIcon statusIcon;

    public SettingsPane() {
        ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        this.statusIcon = new SVGIcon((GlyphIcons)MaterialIcon.TUNE, 32.0, true);
        TitledPane settingsPane = new TitledPane();
        settingsPane.getStyleClass().add((Object)"settings-pane");
        this.settingsIcon = new SVGIcon((GlyphIcons)MaterialIcon.TUNE, 16.0, true);
        this.settingsLbl = new ObserverLabel("settings", (Node)this.settingsIcon);
        BorderPane verticalLayout = new BorderPane();
        this.availableLanguages = FXCollections.observableArrayList((Object[])new String[]{"English", "Deutsch"});
        this.languageChoice = new ChoiceBox(this.availableLanguages);
        this.languageChoice.setPrefWidth(250.0);
        this.availableThemes = FXCollections.observableArrayList((Object[])new String[]{languageBundle.getString("light"), languageBundle.getString("dark")});
        this.themeChoice = new ChoiceBox(this.availableThemes);
        this.themeChoice.setPrefWidth(250.0);
        verticalLayout.setTop(this.languageChoice);
        verticalLayout.setBottom(this.themeChoice);
        settingsPane.setGraphic((Node)this.settingsLbl);
        settingsPane.setContent((Node)verticalLayout);
        this.getChildren().addAll((Object[])new Node[]{settingsPane});
    }

    public ChoiceBox<String> getThemeChoice() {
        return this.themeChoice;
    }

    public ChoiceBox<String> getLanguageChoice() {
        return this.languageChoice;
    }

    public ObservableList<String> getAvailableThemes() {
        return this.availableThemes;
    }

    public ObservableList<String> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public ObserverLabel getSettingsLbl() {
        return this.settingsLbl;
    }

    @Override
    public Node getStatusIcon() {
        return this.statusIcon;
    }
}

