/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.SVGIcon;

public class UserPane
extends BorderPane {
    private SVGIcon userIcon;
    private SVGIcon atHomeIcon;
    private Label userNameLabel;
    private ObserverLabel userStateLabel;

    public UserPane(String userName, boolean guest, String userState, boolean atHome) {
        this.init(userName, guest, userState, atHome);
    }

    private void init(String userName, boolean guest, String userState, boolean atHome) {
        this.userIcon = new SVGIcon((GlyphIcons)MaterialIcon.PERSON, 48.0, false);
        this.setAtHome(atHome);
        GridPane userIconPane = new GridPane();
        userIconPane.setVgap(10.0);
        userIconPane.setHgap(10.0);
        userIconPane.add((Node)this.userIcon, 0, 0, 5, 5);
        userIconPane.add((Node)this.atHomeIcon, 4, 4, 1, 1);
        this.userNameLabel = new Label(userName);
        this.userNameLabel.getStyleClass().add((Object)"bold-label");
        ObserverLabel guestLabel = new ObserverLabel("guest");
        guestLabel.getStyleClass().add((Object)"bold-label");
        if (guest) {
            guestLabel.setVisible(true);
        } else {
            guestLabel.setVisible(false);
        }
        HBox nameAndGuestLayout = new HBox(10.0);
        nameAndGuestLayout.getChildren().addAll((Object[])new Node[]{this.userNameLabel, guestLabel});
        nameAndGuestLayout.setAlignment(Pos.CENTER);
        this.userStateLabel = new ObserverLabel(userState);
        VBox nameAndStateLayout = new VBox(5.0);
        nameAndStateLayout.setAlignment(Pos.CENTER);
        nameAndStateLayout.getChildren().addAll((Object[])new Node[]{nameAndGuestLayout, this.userStateLabel});
        this.setLeft((Node)userIconPane);
        this.setCenter((Node)nameAndStateLayout);
    }

    public void setAtHome(boolean atHome) {
        if (atHome) {
            this.atHomeIcon = new SVGIcon((GlyphIcons)MaterialIcon.HOME, 16.0, true);
            this.userIcon.setForegroundIconColor(Color.DODGERBLUE);
        } else {
            this.atHomeIcon = new SVGIcon((GlyphIcons)MaterialIcon.DIRECTIONS_WALK, 16.0, true);
            this.userIcon.setForegroundIconColor(Color.LIGHTGRAY);
        }
    }

    public void setUserState(String newUserState) {
        this.userStateLabel.setIdentifier(newUserState);
    }

    public void setUserName(String newUserName) {
        this.userNameLabel.setText(newUserName);
    }
}

