/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.PowerConsumptionSensorRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.dal.PowerConsumptionSensorDataType;

public class PowerConsumptionSensorPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerConsumptionSensorPane.class);
    private final PowerConsumptionSensorRemote powerConsumptionSensorRemote;
    private final SVGIcon powerConsumptionIcon;
    private final Text currentPowerConsumption;
    private final BorderPane headContent;
    private final Text sumPowerConsumption;
    private final Text voltagePowerConsumption;
    private final Text sumLabelText;
    private final Text voltageLabelText;
    private final GridPane bodyContent;

    public PowerConsumptionSensorPane(AbstractIdentifiableRemote powerConsumptionSensorRemote) {
        this.powerConsumptionSensorRemote = (PowerConsumptionSensorRemote)powerConsumptionSensorRemote;
        this.headContent = new BorderPane();
        this.bodyContent = new GridPane();
        this.powerConsumptionIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.POWER, 32.0, true);
        this.currentPowerConsumption = new Text();
        this.sumPowerConsumption = new Text();
        this.voltagePowerConsumption = new Text();
        this.sumLabelText = new Text("Power Consumption:");
        this.voltageLabelText = new Text("Current Voltage:");
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, (Pane)this.bodyContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.powerConsumptionSensorRemote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        double currentPowerConsumption = 0.0;
        double sumPowerConsumption = 0.0;
        double voltagePowerConsumption = 0.0;
        try {
            currentPowerConsumption = this.powerConsumptionSensorRemote.getPowerConsumptionState().getCurrent();
            sumPowerConsumption = this.powerConsumptionSensorRemote.getPowerConsumptionState().getConsumption();
            voltagePowerConsumption = this.powerConsumptionSensorRemote.getPowerConsumptionState().getVoltage();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setPowerConsumptionIconAndText(currentPowerConsumption, sumPowerConsumption, voltagePowerConsumption);
    }

    private void setPowerConsumptionIconAndText(double currentPowerConsumption, double sumPowerConsumption, double voltagePowerConsumption) {
        if (currentPowerConsumption == 0.0) {
            this.powerConsumptionIcon.changeForegroundIcon((GlyphIcons)MaterialDesignIcon.POWER);
            this.observerText.setIdentifier("powerOff");
        } else {
            this.powerConsumptionIcon.setForegroundIconColor(Color.GREEN);
            this.observerText.setIdentifier("powerOn");
        }
        this.currentPowerConsumption.setText(currentPowerConsumption + "W");
        this.sumPowerConsumption.setText(sumPowerConsumption + "W");
        this.voltagePowerConsumption.setText(voltagePowerConsumption + "V");
    }

    @Override
    protected void initTitle() {
        this.currentPowerConsumption.getStyleClass().add((Object)"icons");
        this.iconPane.add((Node)this.powerConsumptionIcon, 0, 0);
        this.iconPane.add((Node)this.currentPowerConsumption, 1, 0);
        this.iconPane.setHgap(10.0);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.powerConsumptionIcon.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
        this.sumPowerConsumption.getStyleClass().add((Object)"icons");
        this.voltagePowerConsumption.getStyleClass().add((Object)"icons");
        this.bodyContent.add((Node)this.sumLabelText, 0, 0);
        this.bodyContent.add((Node)this.sumPowerConsumption, 1, 0);
        this.bodyContent.add((Node)this.voltageLabelText, 0, 1);
        this.bodyContent.add((Node)this.voltagePowerConsumption, 1, 1);
        this.bodyContent.prefHeightProperty().set(60.0);
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((PowerConsumptionSensorDataType.PowerConsumptionSensorData)this.powerConsumptionSensorRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.powerConsumptionSensorRemote;
    }

    @Override
    void removeObserver() {
        this.powerConsumptionSensorRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object powerConsumption) throws Exception {
        Platform.runLater(() -> {
            double voltagePowerConsumption = ((PowerConsumptionSensorDataType.PowerConsumptionSensorData)powerConsumption).getPowerConsumptionState().getVoltage();
            double currentPowerConsumption = ((PowerConsumptionSensorDataType.PowerConsumptionSensorData)powerConsumption).getPowerConsumptionState().getCurrent();
            double sumPowerConsumption = ((PowerConsumptionSensorDataType.PowerConsumptionSensorData)powerConsumption).getPowerConsumptionState().getConsumption();
            this.setPowerConsumptionIconAndText(currentPowerConsumption, sumPowerConsumption, voltagePowerConsumption);
        });
    }
}

