/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.PowerSwitchRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.PowerSwitchDataType;

public class PowerSwitchPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerSwitchPane.class);
    private final PowerSwitchRemote powerSwitchRemote;
    private final SVGIcon powerPlugIcon;
    private final SVGIcon powerStatusIcon;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final BorderPane headContent;

    public PowerSwitchPane(AbstractIdentifiableRemote powerPlugRemote) {
        this.powerSwitchRemote = (PowerSwitchRemote)powerPlugRemote;
        this.headContent = new BorderPane();
        this.powerPlugIcon = new SVGIcon((GlyphIcons)FontAwesomeIcon.PLUG, 32.0, true);
        this.powerStatusIcon = new SVGIcon((GlyphIcons)FontAwesomeIcon.BOLT, 16.0, false);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, true);
        this.initEffectAndSwitch();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.powerSwitchRemote.addDataObserver((Observer)this);
    }

    private void initEffectAndSwitch() {
        PowerStateType.PowerState.State powerState = PowerStateType.PowerState.State.OFF;
        try {
            powerState = this.powerSwitchRemote.getPowerState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setPowerStateSwitchAndIcon(powerState);
    }

    private void setPowerStateSwitchAndIcon(PowerStateType.PowerState.State powerState) {
        this.iconPane.getChildren().clear();
        switch (powerState) {
            case ON: {
                this.powerStatusIcon.setForegroundIconColor(Color.YELLOW, Color.BLACK, 0.5);
                this.iconPane.add((Node)this.powerPlugIcon, 1, 0, 3, 2);
                this.observerText.setIdentifier("powerOn");
                if (this.toggleSwitch.isSelected()) break;
                this.toggleSwitch.setSelected(true);
                break;
            }
            case OFF: {
                this.powerStatusIcon.setForegroundIconColor(Color.TRANSPARENT);
                this.iconPane.add((Node)this.powerPlugIcon, 1, 0, 3, 2);
                this.observerText.setIdentifier("powerOff");
                if (!this.toggleSwitch.isSelected()) break;
                this.toggleSwitch.setSelected(false);
                break;
            }
            default: {
                this.powerStatusIcon.setForegroundIconColor(Color.TRANSPARENT);
                this.iconPane.add((Node)this.unknownBackgroundIcon, 1, 0, 3, 2);
                this.iconPane.add((Node)this.unknownForegroundIcon, 1, 0, 3, 2);
                this.observerText.setIdentifier("unknown");
            }
        }
        this.iconPane.add((Node)this.powerStatusIcon, 0, 0);
    }

    private void sendStateToRemote(PowerStateType.PowerState.State state) {
        try {
            this.powerSwitchRemote.setPowerState(state).get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            this.setWidgetPaneDisable(true);
        }
    }

    @Override
    protected void initTitle() {
        this.oneClick.addListener((observable, oldValue, newValue) -> GlobalExecutionService.submit((Runnable)new Task(){

            protected Object call() {
                if (PowerSwitchPane.this.toggleSwitch.isSelected()) {
                    PowerSwitchPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                } else {
                    PowerSwitchPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                }
                return null;
            }
        }));
        this.toggleSwitch.setOnMouseClicked(event -> GlobalExecutionService.submit((Runnable)new Task(){

            protected Object call() {
                if (PowerSwitchPane.this.toggleSwitch.isSelected()) {
                    PowerSwitchPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                } else {
                    PowerSwitchPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                }
                return null;
            }
        }));
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.iconPane.getHeight() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((PowerSwitchDataType.PowerSwitchData)this.powerSwitchRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.powerSwitchRemote;
    }

    @Override
    void removeObserver() {
        this.powerSwitchRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object powerPlug) throws Exception {
        Platform.runLater(() -> {
            PowerStateType.PowerState.State powerState = ((PowerSwitchDataType.PowerSwitchData)powerPlug).getPowerState().getValue();
            this.setPowerStateSwitchAndIcon(powerState);
        });
    }
}

