/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.ReedContactRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ContactStateType;
import rst.domotic.unit.dal.ReedContactDataType;

public class ReedContactPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReedContactPane.class);
    private final ReedContactRemote reedContactRemote;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final SVGIcon reedSwitchIcon;
    private final BorderPane headContent;

    public ReedContactPane(AbstractIdentifiableRemote reedSwitchRemote) {
        this.reedContactRemote = (ReedContactRemote)reedSwitchRemote;
        this.reedSwitchIcon = new SVGIcon((GlyphIcons)MaterialIcon.RADIO_BUTTON_CHECKED, 32.0, true);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.headContent = new BorderPane();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, false);
        this.initEffectAndText();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.reedContactRemote.addDataObserver((Observer)this);
    }

    private void initEffectAndText() {
        ContactStateType.ContactState.State reedSwitchState = ContactStateType.ContactState.State.UNKNOWN;
        try {
            reedSwitchState = this.reedContactRemote.getContactState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setReedSwitchIconAndTooltip(reedSwitchState);
    }

    private void setReedSwitchIconAndTooltip(ContactStateType.ContactState.State reedSwitchState) {
        this.iconPane.getChildren().clear();
        if (reedSwitchState == ContactStateType.ContactState.State.CLOSED) {
            this.reedSwitchIcon.changeForegroundIcon((GlyphIcons)MaterialIcon.RADIO_BUTTON_CHECKED);
            this.iconPane.add((Node)this.reedSwitchIcon, 0, 0);
            this.observerText.setIdentifier("closed");
        } else if (reedSwitchState == ContactStateType.ContactState.State.OPEN) {
            this.reedSwitchIcon.changeForegroundIcon((GlyphIcons)MaterialIcon.RADIO_BUTTON_UNCHECKED);
            this.iconPane.add((Node)this.reedSwitchIcon, 0, 0);
            this.observerText.setIdentifier("open");
        } else {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
    }

    @Override
    protected void initTitle() {
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.reedSwitchIcon.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((ReedContactDataType.ReedContactData)this.reedContactRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.reedContactRemote;
    }

    @Override
    void removeObserver() {
        this.reedContactRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object reedSwitch) throws Exception {
        Platform.runLater(() -> {
            ContactStateType.ContactState.State reedSwitchState = ((ReedContactDataType.ReedContactData)reedSwitch).getContactState().getValue();
            this.setReedSwitchIconAndTooltip(reedSwitchState);
        });
    }
}

