/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.RollerShutterRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.BlindStateType;
import rst.domotic.unit.dal.RollerShutterDataType;

public class RollerShutterPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollerShutterPane.class);
    private RecurrenceEventFilter recurrenceEventFilter;
    private final RollerShutterRemote rollershutterRemote;
    private final BorderPane headContent;
    private final HBox bodyContent;
    private final SVGIcon rollerShutterIconBackground;
    private final SVGIcon rollerShutterIconForeground;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final Rectangle clip;
    private final Text rollerShutterStatus;
    private final EventHandler<MouseEvent> sendingUp = event -> GlobalExecutionService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                RollerShutterPane.this.rollershutterRemote.setBlindState(BlindStateType.BlindState.MovementState.UP).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                RollerShutterPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });
    private final EventHandler<MouseEvent> sendingDown = event -> GlobalExecutionService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                RollerShutterPane.this.rollershutterRemote.setBlindState(BlindStateType.BlindState.MovementState.DOWN).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                RollerShutterPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });
    private final EventHandler<MouseEvent> sendingStop = event -> GlobalExecutionService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                RollerShutterPane.this.rollershutterRemote.setBlindState(BlindStateType.BlindState.MovementState.STOP).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                RollerShutterPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });
    private final EventHandler<MouseEvent> sendingTotalOpening = event -> GlobalExecutionService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                RollerShutterPane.this.rollershutterRemote.setBlindState(BlindStateType.BlindState.newBuilder().setOpeningRatio(0.0).setMovementState(BlindStateType.BlindState.MovementState.STOP).build()).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                RollerShutterPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });
    private final EventHandler<MouseEvent> sendingTotalClosing = event -> GlobalExecutionService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                RollerShutterPane.this.rollershutterRemote.setBlindState(BlindStateType.BlindState.newBuilder().setOpeningRatio(1.0).setMovementState(BlindStateType.BlindState.MovementState.STOP).build()).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                RollerShutterPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });

    public RollerShutterPane(AbstractIdentifiableRemote rollerShutterRemote) {
        this.rollershutterRemote = (RollerShutterRemote)rollerShutterRemote;
        this.rollerShutterIconBackground = new SVGIcon((GlyphIcons)MaterialDesignIcon.FORMAT_ALIGN_JUSTIFY, 32.0, false);
        this.rollerShutterIconForeground = new SVGIcon((GlyphIcons)MaterialDesignIcon.FORMAT_ALIGN_JUSTIFY, 32.0, true);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.headContent = new BorderPane();
        this.bodyContent = new HBox();
        this.rollerShutterStatus = new Text();
        this.clip = new Rectangle();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, (Pane)this.bodyContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.rollershutterRemote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        BlindStateType.BlindState.MovementState shutterState = BlindStateType.BlindState.MovementState.UNKNOWN;
        double openingPercentage = 0.0;
        try {
            openingPercentage = this.rollershutterRemote.getBlindState().getOpeningRatio();
            shutterState = this.rollershutterRemote.getBlindState().getMovementState();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setEffectOpeningRatio(openingPercentage, shutterState);
    }

    private void setEffectOpeningRatio(double percentage, BlindStateType.BlindState.MovementState shutterState) {
        this.iconPane.getChildren().clear();
        if (shutterState.equals((Object)BlindStateType.BlindState.MovementState.UNKNOWN)) {
            this.rollerShutterStatus.setText((int)(100.0 * percentage) + "%");
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        } else {
            switch (shutterState) {
                case DOWN: {
                    this.observerText.setIdentifier("down");
                    break;
                }
                case UP: {
                    this.observerText.setIdentifier("up");
                    break;
                }
                default: {
                    this.observerText.setIdentifier("stop");
                }
            }
            this.rollerShutterIconBackground.changeBackgroundIcon((GlyphIcons)MaterialDesignIcon.FORMAT_ALIGN_JUSTIFY);
            this.rollerShutterIconBackground.setForegroundIconColor(Color.YELLOW);
            this.rollerShutterIconForeground.changeForegroundIcon((GlyphIcons)MaterialDesignIcon.FORMAT_ALIGN_JUSTIFY);
            ((Rectangle)this.rollerShutterIconForeground.getClip()).setHeight(32.0 * percentage);
            this.rollerShutterStatus.setText((int)(100.0 * percentage) + "%");
            this.iconPane.add((Node)this.rollerShutterIconBackground, 0, 0);
            this.iconPane.add((Node)this.rollerShutterIconForeground, 0, 0);
        }
        this.iconPane.add((Node)this.rollerShutterStatus, 1, 0);
    }

    @Override
    protected void initTitle() {
        this.rollerShutterStatus.getStyleClass().add((Object)"icons");
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.iconPane.setHgap(10.0);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(42.0);
        this.clip.setWidth(32.0);
        this.clip.setHeight(32.0);
        this.rollerShutterIconForeground.setClip((Node)this.clip);
    }

    @Override
    protected void initContent() {
        final Button buttonUp = new Button();
        final Button buttonDown = new Button();
        final Button buttonOpen = new Button();
        final Button buttonClose = new Button();
        this.recurrenceEventFilter = new RecurrenceEventFilter(100L){

            public void relay() {
                buttonOpen.setOnMouseClicked(RollerShutterPane.this.sendingTotalOpening);
                buttonClose.setOnMouseClicked(RollerShutterPane.this.sendingTotalClosing);
                buttonUp.setOnMousePressed(RollerShutterPane.this.sendingUp);
                buttonUp.setOnMouseReleased(RollerShutterPane.this.sendingStop);
                buttonDown.setOnMousePressed(RollerShutterPane.this.sendingDown);
                buttonDown.setOnMouseReleased(RollerShutterPane.this.sendingStop);
            }
        };
        this.recurrenceEventFilter.trigger();
        SVGIcon arrowUp = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHEVRON_UP, 32.0, true);
        SVGIcon arrowDown = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHEVRON_DOWN, 32.0, true);
        SVGIcon arrowDoubleUP = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHEVRON_DOUBLE_UP, 32.0, true);
        SVGIcon arrowDoubleDown = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHEVRON_DOUBLE_DOWN, 32.0, true);
        buttonUp.setGraphic((Node)arrowUp);
        buttonDown.setGraphic((Node)arrowDown);
        buttonOpen.setGraphic((Node)arrowDoubleUP);
        buttonClose.setGraphic((Node)arrowDoubleDown);
        this.bodyContent.getChildren().addAll((Object[])new Node[]{buttonOpen, buttonUp, buttonDown, buttonClose});
        this.bodyContent.setAlignment(Pos.CENTER);
        this.bodyContent.prefHeightProperty().set(80.0);
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((RollerShutterDataType.RollerShutterData)this.rollershutterRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.rollershutterRemote;
    }

    @Override
    void removeObserver() {
        this.rollershutterRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object rollerShutter) throws Exception {
        Platform.runLater(() -> {
            double openingPercentage = ((RollerShutterDataType.RollerShutterData)rollerShutter).getBlindState().getOpeningRatio();
            BlindStateType.BlindState.MovementState shutterState = ((RollerShutterDataType.RollerShutterData)rollerShutter).getBlindState().getMovementState();
            this.setEffectOpeningRatio(openingPercentage, shutterState);
        });
    }
}

