/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.TemperatureControllerRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableRemote;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.dal.TemperatureControllerDataType;

public class TemperatureControllerPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemperatureControllerPane.class);
    private RecurrenceEventFilter recurrenceEventFilter;
    private final TemperatureControllerRemote temperatureControllerRemote;
    private final SVGIcon temperatureControllerIcon;
    private final BorderPane headContent;
    private final VBox bodyContent;
    private final Slider slider;
    private final VBox vBox;
    private final Button actual;
    private final Button target;
    private final DecimalFormat decimalFormat;
    private double actualTemperature;
    private double targetTemperature;
    private final EventHandler<MouseEvent> sendingTargetTemperature = event -> GlobalExecutionService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                TemperatureControllerPane.this.temperatureControllerRemote.setTargetTemperatureState(TemperatureStateType.TemperatureState.newBuilder().setTemperature(TemperatureControllerPane.this.slider.getValue()).build()).get(3000L, TimeUnit.MILLISECONDS);
                StackPane track = (StackPane)TemperatureControllerPane.this.slider.lookup(".track");
                TemperatureControllerPane.this.target.setTranslateX(track.getLayoutX());
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                TemperatureControllerPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });

    public TemperatureControllerPane(AbstractIdentifiableRemote temperatureControllerRemote) {
        this.temperatureControllerRemote = (TemperatureControllerRemote)temperatureControllerRemote;
        this.temperatureControllerIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.RADIATOR, 32.0, true);
        this.decimalFormat = new DecimalFormat("#.#");
        this.headContent = new BorderPane();
        this.bodyContent = new VBox();
        this.slider = new Slider();
        this.vBox = new VBox();
        this.actual = new Button();
        this.target = new Button();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, (Pane)this.bodyContent, false);
        this.initEffectSlider();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.temperatureControllerRemote.addDataObserver((Observer)this);
    }

    private void initEffectSlider() {
        this.actualTemperature = this.slider.getMin();
        this.targetTemperature = this.slider.getMin();
        this.slider.setValue(0.0);
        try {
            this.actualTemperature = this.temperatureControllerRemote.getTemperatureState().getTemperature();
            this.targetTemperature = this.temperatureControllerRemote.getTargetTemperatureState().getTemperature();
            this.slider.setValue(this.targetTemperature);
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setLabelValues();
    }

    private void setLabelValues() {
        this.decimalFormat.setRoundingMode(RoundingMode.CEILING);
        this.actualTemperature = this.actualTemperature < 10.0 ? 10.0 : this.actualTemperature;
        this.targetTemperature = this.targetTemperature < 10.0 ? 10.0 : this.targetTemperature;
        this.actual.setText("Actual: " + this.decimalFormat.format(this.actualTemperature) + "\u00b0C");
        this.actual.setTranslateX((this.actualTemperature - this.slider.getMin()) * (this.slider.getMinWidth() / (this.slider.getMax() - this.slider.getMin())) - this.slider.getMinWidth() / 2.0);
        this.target.setText(this.decimalFormat.format(this.targetTemperature) + "\u00b0C");
    }

    @Override
    protected void initTitle() {
        this.observerText.setIdentifier("heating");
        this.iconPane.add((Node)this.temperatureControllerIcon, 0, 0);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.temperatureControllerIcon.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
        double sliderWidth = 200.0;
        this.slider.setPrefHeight(25.0);
        this.slider.setMinHeight(25.0);
        this.slider.setMin(10.0);
        this.slider.setMax(35.0);
        this.slider.setMinWidth(200.0);
        this.slider.setMaxWidth(200.0);
        this.slider.getStyleClass().add((Object)"temperature-slider");
        this.actual.getStyleClass().addAll((Object[])new String[]{"temperature-slider-pane-top"});
        this.target.getStyleClass().addAll((Object[])new String[]{"temperature-slider-pane-bottom"});
        this.recurrenceEventFilter = new RecurrenceEventFilter(100L){

            public void relay() {
                TemperatureControllerPane.this.slider.setOnMousePressed(TemperatureControllerPane.this.sendingTargetTemperature);
                TemperatureControllerPane.this.slider.setOnMouseDragged(TemperatureControllerPane.this.sendingTargetTemperature);
            }
        };
        this.recurrenceEventFilter.trigger();
        this.vBox.getChildren().addAll((Object[])new Node[]{this.actual, this.slider, this.target});
        this.vBox.setAlignment(Pos.CENTER);
        this.bodyContent.getChildren().addAll((Object[])new Node[]{this.vBox});
        this.bodyContent.prefHeightProperty().set(160.0);
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((TemperatureControllerDataType.TemperatureControllerData)this.temperatureControllerRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public AbstractIdentifiableRemote getDALRemoteService() {
        return this.temperatureControllerRemote;
    }

    @Override
    void removeObserver() {
        this.temperatureControllerRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object temperatureController) throws Exception {
        Platform.runLater(() -> {
            this.actualTemperature = ((TemperatureControllerDataType.TemperatureControllerData)temperatureController).getActualTemperatureState().getTemperature();
            this.targetTemperature = ((TemperatureControllerDataType.TemperatureControllerData)temperatureController).getTargetTemperatureState().getTemperature();
            this.setLabelValues();
        });
    }
}

