/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.openbase.bco.bcozy.model.LanguageSelection;

public class ObserverButton
extends Button
implements Observer {
    private final String identifier;
    private ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());

    public ObserverButton(String languageString) {
        this.identifier = languageString;
        super.setText(this.languageBundle.getString(this.identifier));
        LanguageSelection.getInstance().addObserver(this);
    }

    public ObserverButton(String languageString, Node graphic) {
        this.identifier = languageString;
        super.setText(this.languageBundle.getString(this.identifier));
        super.setGraphic(graphic);
        LanguageSelection.getInstance().addObserver(this);
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        super.setText(this.languageBundle.getString(this.identifier));
    }
}

