/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverLabel
extends Label
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserverLabel.class);
    private String identifier;
    private ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());

    public ObserverLabel(String identifier) {
        LanguageSelection.getInstance().addObserver(this);
        this.setIdentifier(identifier);
    }

    public ObserverLabel(String identifier, Node graphic) {
        super.setGraphic(graphic);
        LanguageSelection.getInstance().addObserver(this);
        this.setIdentifier(identifier);
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.setIdentifier(this.identifier);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
        this.languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        try {
            super.setText(this.languageBundle.getString(this.identifier));
        }
        catch (MissingResourceException ex) {
            ExceptionPrinter.printHistory((String)("Could not resolve Identifier[" + identifier + "]"), (Throwable)ex, (Logger)LOGGER);
            super.setText(this.identifier);
        }
    }
}

