/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.openbase.bco.bcozy.view.location.ConnectionPolygon;

public class DoorPolygon
extends ConnectionPolygon {
    public DoorPolygon(String connectionLabel, String connectionId, double ... points) {
        super(connectionLabel, connectionId, points);
        ObservableList pointList = super.getPoints();
        if (this.isHorizontal()) {
            for (int i = 1; i < pointList.size(); i += 2) {
                if (((Double)pointList.get(i)).doubleValue() == this.getMinY()) {
                    pointList.set(i, (Object)(this.getMinY() - 0.5));
                    continue;
                }
                pointList.set(i, (Object)(this.getMaxY() + 0.5));
            }
        } else {
            for (int i = 0; i < pointList.size(); i += 2) {
                if (((Double)pointList.get(i)).doubleValue() == this.getMinX()) {
                    pointList.set(i, (Object)(this.getMinX() - 0.5));
                    continue;
                }
                pointList.set(i, (Object)(this.getMaxX() + 0.5));
            }
        }
    }

    @Override
    protected void setConnectionStyle() {
        this.setMainColor(Color.AZURE);
        this.setStroke((Paint)Color.WHITE);
        this.getStrokeDashArray().addAll((Object[])new Double[]{2.0, 4.0});
        this.setStrokeWidth(1.0);
        this.setStrokeType(StrokeType.INSIDE);
        this.setMouseTransparent(true);
    }

    @Override
    protected void changeStyleOnOpening(boolean open) {
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }
}

